/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.demo;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.looks.LookUtils;
import com.jgoodies.uif_lite.component.UIFSplitPane;
import java.awt.BorderLayout;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;

final class SplitTab {
    static /* synthetic */ Class class$java$lang$Boolean;

    SplitTab() {
    }

    JComponent build() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        panel.setBorder(Borders.DIALOG_BORDER);
        panel.add(this.buildHorizontalSplit());
        return panel;
    }

    private JComponent buildHorizontalSplit() {
        JScrollPane left = new JScrollPane(this.buildTree());
        left.setPreferredSize(new Dimension(200, 100));
        JScrollPane upperRight = new JScrollPane(this.buildTextArea());
        upperRight.setPreferredSize(new Dimension(100, 100));
        JScrollPane lowerRight = new JScrollPane(this.buildTable());
        lowerRight.setPreferredSize(new Dimension(100, 100));
        UIFSplitPane verticalSplit = UIFSplitPane.createStrippedSplitPane(0, upperRight, lowerRight);
        verticalSplit.setOpaque(false);
        UIFSplitPane horizontalSplit = UIFSplitPane.createStrippedSplitPane(1, left, verticalSplit);
        horizontalSplit.setOpaque(false);
        return horizontalSplit;
    }

    private JTree buildTree() {
        JTree tree = new JTree(this.createSampleTreeModel());
        tree.expandRow(3);
        tree.expandRow(2);
        tree.expandRow(1);
        return tree;
    }

    private JTextArea buildTextArea() {
        JTextArea area = new JTextArea();
        area.setText("May\nI\nKindly\nRemind you that a\nMargin\nImproves a text's readability.");
        return area;
    }

    private JTable buildTable() {
        SampleTableModel model = new SampleTableModel(this.createSampleTableData(), new String[]{"Artist", "Title      ", "Free"});
        JTable table = new JTable(model);
        table.setAutoResizeMode(0);
        table.getColumnModel().getColumn(0).setPreferredWidth(100);
        table.getColumnModel().getColumn(1).setPreferredWidth(250);
        table.getColumnModel().getColumn(2).setPreferredWidth(50);
        table.setRowSelectionInterval(2, 2);
        int tableFontSize = table.getFont().getSize();
        int minimumRowHeight = tableFontSize + 6;
        int defaultRowHeight = LookUtils.IS_LOW_RESOLUTION ? 17 : 18;
        table.setRowHeight(Math.max(minimumRowHeight, defaultRowHeight));
        return table;
    }

    private TreeModel createSampleTreeModel() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Musicians");
        DefaultMutableTreeNode parent = new DefaultMutableTreeNode("Drums");
        root.add(parent);
        parent.add(new DefaultMutableTreeNode("Elvin Jones"));
        parent.add(new DefaultMutableTreeNode("Jack DeJohnette"));
        parent.add(new DefaultMutableTreeNode("Rashied Ali"));
        parent = new DefaultMutableTreeNode("Piano");
        root.add(parent);
        parent.add(new DefaultMutableTreeNode("Alexander von Schlippenbach"));
        parent.add(new DefaultMutableTreeNode("McCoy Tyner"));
        parent.add(new DefaultMutableTreeNode("Sun Ra"));
        parent = new DefaultMutableTreeNode("Saxophon");
        root.add(parent);
        parent.add(new DefaultMutableTreeNode("Albert Ayler"));
        parent.add(new DefaultMutableTreeNode("Archie Shepp"));
        parent.add(new DefaultMutableTreeNode("Charlie Parker"));
        parent.add(new DefaultMutableTreeNode("John Coltrane"));
        parent.add(new DefaultMutableTreeNode("Ornette Coleman"));
        parent.add(new DefaultMutableTreeNode("Pharoa Sanders"));
        parent.add(new DefaultMutableTreeNode("Sonny Rollins"));
        return new DefaultTreeModel(root);
    }

    private Object[][] createSampleTableData() {
        return new Object[][]{{"Albert Ayler", "Greenwich Village", Boolean.TRUE}, {"Carla Bley", "Escalator Over the Hill", Boolean.TRUE}, {"Frank Zappa", "Yo' Mama", Boolean.TRUE}, {"John Coltrane", "Ascension", Boolean.TRUE}, {"Miles Davis", "In a Silent Way", Boolean.TRUE}, {"Pharoa Sanders", "Karma", Boolean.TRUE}, {"Wayne Shorter", "Juju", Boolean.TRUE}, {"", "", Boolean.FALSE}, {"", "", Boolean.FALSE}, {"", "", Boolean.FALSE}, {"", "", Boolean.FALSE}, {"", "", Boolean.FALSE}, {"", "", Boolean.FALSE}, {"", "", Boolean.FALSE}, {"", "", Boolean.FALSE}, {"", "", Boolean.FALSE}};
    }

    private static final class SampleTableModel
    extends AbstractTableModel {
        private final String[] columnNames;
        private final Object[][] rowData;

        SampleTableModel(Object[][] rowData, String[] columnNames) {
            this.columnNames = columnNames;
            this.rowData = rowData;
        }

        public String getColumnName(int column) {
            return this.columnNames[column].toString();
        }

        public int getRowCount() {
            return this.rowData.length;
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public Class getColumnClass(int column) {
            Class clazz = column == 2 ? (class$java$lang$Boolean == null ? (class$java$lang$Boolean = SplitTab.class$("java.lang.Boolean")) : class$java$lang$Boolean) : super.getColumnClass(column);
            return clazz;
        }

        public Object getValueAt(int row, int col) {
            return this.rowData[row][col];
        }

        public boolean isCellEditable(int row, int column) {
            return true;
        }

        public void setValueAt(Object value, int row, int col) {
            this.rowData[row][col] = value;
            this.fireTableCellUpdated(row, col);
        }
    }
}

