// $Id: pretoggle.pike,v 1.1.1.1 1997/06/08 11:13:30 kinkie Exp $

#include <module.h>
inherit "module";

string cvs_version="$Id: pretoggle.pike,v 1.1.1.1 1997/06/08 11:13:30 kinkie Exp $";
/*
 * Some copyright information: 
 * This code is (C) 1997 Francesco Chemolli <kinkie@comedia.it>
 * You may do what you wish with it, even sell it if you find someone
 * crazy enough to pay for it.
 * I disclaim every warranty on this code, if you use it you implicitly
 * declare you are aware of this.
 */

string handle_pretoggle (string tag_name, mapping args, string contents,
	object id, mapping defines)
{
	string toshow=contents, what=(indices(args)-({"separator"}))[0];
	string to_set, to_reset,to_out,index;
	if (tag_name=="conftoggle") {
		to_out="ACONF";
		to_set=" +";
		to_reset=" -";
		index="config";
	} else {
		to_out="APRE";
		to_set=" ";
		to_reset=" -";
		index="prestate";
	}

	if (args->separator) {
		string *fields=contents/args->separator;
		if (id[index][what])
			toshow=fields[1];
		else
			toshow=fields[0];
	}
	if (id->config[what])
		return sprintf("<%s%s%s>%s</%s>",to_out,to_reset,what,toshow,to_out);
	return sprintf("<%s%s%s>%s</%s>",to_out,to_set,what,toshow,to_out);
}

array register_module() {
	return ({
		MODULE_PARSER,
		"Pretoggle",
		"Support for prestate and configs toggling.\n<p>"
		"This module complements prestate and configs handling, acting as a toggle "
		"(pretoggle means prestate toggle), and behaves in a fashion "
		"similar to the <TT>&lt;apre&gt;</TT> container.<BR>"
		"It handles two containers: <CODE>&lt;PRETOGGLE&gt;</CODE> "
		"and <CODE>&lt;CONFTOGGLE&gt;</CODE>; the former handles prestates, "
		"the latter handles configs in a similar fashion.<BR>"
		"<CODE>&lt;PRETOGGLE foo&gt;bar</PRETOGGLE></CODE> "
		"is functionally equivalent to "
		"<CODE>&lt;IF prestate=foo&gt;&lt;APRE -foo&gt;bar&lt;/APRE&gt;&lt;/IF&gt;"
		"&lt;ELSE&gt;&lt;APRE foo&gt;bar&lt;/APRE&gt;&lt;/ELSE&gt;</CODE><BR>"
		"An exception is when the <I>separator</I> argument to the tag is given: "
		"<CODE>&lt;PRETOGGLE foo separator=\"|\"&gt;bar|boo"
		"&lt;/PRETOGGLE&gt;</CODE>"
		" is functionally equivalent to: "
		"<CODE>&lt;IF prestate=foo&gt;&lt;APRE -foo&gt;boo&lt;/APRE&gt;&lt;/IF&gt;"
		"&lt;ELSE&gt;&lt;APRE foo&gt;bar&lt;/APRE&gt;&lt;/ELSE&gt;</CODE> " 
		"that is to say, if the prestate is not present, the text before the "
		"declared separator is shown, if it's not, the text after the (first) "
		"separator is shown.<BR>"
		"&copy; 1997 Francesco Chemolli "
		"<I><A href=mailto:kinkie@comedia.it>kinkie@comedia.it</A></I>"
		,
		0,
		1
	});
}

mapping query_container_callers() {
	return 
		(["pretoggle":handle_pretoggle,
			"conftoggle":handle_pretoggle,
		]);
}

