#!/usr/bin/pike7
/*
	test xmlrpc.pmod
	$Id: call.pike,v 1.1 2002/06/12 18:30:18 pit Exp $
*/

inherit "xmlrpc.pmod";

string URI="http://bet.root.at/rpc/";

int main(int argc, array argv) {
	
	if(argc<2) {
		write("\nCall with: " + 
				(argv[0]/"/")[sizeof(argv[0]/"/")-1] +
				" remote-method [argument 1]\n\n");
		exit(1);
	}

	object rpc=xmlRPC();
	mixed result;
	array args; 
	mixed err=catch {
		if(argc>2) {
			args=argv[2..];
		} else {
			args=({"x"});
		}

		if(sizeof(args)) {
			result = rpc->http_call(URI, argv[1], @args);
		} else {
			result = rpc->http_call(URI, argv[1]);
		}

	};
	if(err) {
		write(sprintf("\n%s\n\n%s", err[0], describe_backtrace(err)));
		exit(1);
	} else {
		write(sprintf("%O\n", result));
		exit(0);
	}
}
/* vi: set ts=3: */
