/***************************************************************************
                     libxbox-i2c.h - Xbox I2C defines
                             -------------------
    begin                : Thu Dec 09 23:02:12 BST 2004
    copyright            : (C) 2004 by David Pye
    email                : dmp@davidmpye.dyndns.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//Addresses, commands and registers for I2C
#define XBOX_SMC_ADDR 		0x10 
#define XBOX_EEPROM_ADDR 	0x54	
#define XBOX_ENC_CONEXANT_ADDR 	0x45
#define XBOX_ENC_FOCUS_ADDR 	0x6A
#define XBOX_ENC_XCALIBUR_ADDR	0x70

#define CPU_TEMP_REG 		0x09 
#define MCPX_TEMP_REG 		0x0A

#define SMC_POWER_CTL_REG	0x02
#define SMC_REBOOT_SLOW_CMD	0x40
#define SMC_REBOOT_FAST_CMD	0x01
#define SMC_POWEROFF_CMD	0x80

#define SMC_RST_ON_EJECT_REG	0x19
#define SMC_DVD_CTL_REG 	0x0C
#define SMC_DVD_STATE_REG 	0x03
#define SMC_DVD_EJECT_CMD	0x00
#define SMC_DVD_LOAD_CMD	0x01	

#define SMC_FAN_CTL_MODE	0x05
#define SMC_FAN_SPEED_REG	0x06
#define SMC_FAN_READBACK_REG	0x10

#define SMC_LED_MODE_REG	0x07
#define SMC_LED_COLOR_REG	0x08
        

//LED COLORS - bitwise or together
#define SMC_LED_RED0		0x80
#define SMC_LED_RED1		0x40
#define SMC_LED_RED2		0x20
#define	SMC_LED_RED3 		0x10
#define	SMC_LED_GREEN0 		0x08
#define	SMC_LED_GREEN1 		0x04
#define	SMC_LED_GREEN2 		0x02
#define	SMC_LED_GREEN3	 	0x01
	
