/*
 * Copyright (C) 2014-2016 Stichting Mapcode Foundation (http://www.mapcode.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __INTERNAL_ISO3166_DATA_H__
#define __INTERNAL_ISO3166_DATA_H__

#ifdef __cplusplus
extern "C" {
#endif

#include "mapcode_territories.h"

// *** GENERATED FILE (dividemaps/fast_territories), DO NOT CHANGE OR PRETTIFY ***

static const char PARENT_LETTER[_TERRITORY_MAX - _TERRITORY_MIN] = {
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
        5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2,
        2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4, 4,
        4, 4, 4, 4, 4, 4, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
        6, 6, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3,
        3, 3, 3, 3, 0, 0, 0, 0, 0, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
        7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
        7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 0,
        0, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
        8, 0, 0, 0, 0, 0, 0};


static const char PARENT_NUMBER[_TERRITORY_MAX - _TERRITORY_MIN] = {
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 2, 4, 6, 1, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3,
        7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 8, 0, 0, 0, 0, 0};

#define NR_TERRITORY_RECS 916
typedef struct {
    const char *alphaCode;
    enum Territory territory;
} AlphaRec;

static const AlphaRec ALPHA_SEARCH[NR_TERRITORY_RECS] = {
        {"AAA",    TERRITORY_AAA},
        {"AB",     TERRITORY_CA_AB},
        {"ABW",    TERRITORY_ABW},
        {"AC",     TERRITORY_BR_AC},
        {"ACT",    TERRITORY_AU_ACT},
        {"AD",     TERRITORY_RU_AD},
        {"AFG",    TERRITORY_AFG},
        {"AG",     TERRITORY_MX_AGU},
        {"AGO",    TERRITORY_AGO},
        {"AGU",    TERRITORY_MX_AGU},
        {"AH",     TERRITORY_CN_AH},
        {"AIA",    TERRITORY_AIA},
        {"AK",     TERRITORY_US_AK},
        {"AL",     TERRITORY_BR_AL},
        {"ALA",    TERRITORY_ALA},
        {"ALB",    TERRITORY_ALB},
        {"ALT",    TERRITORY_RU_ALT},
        {"AM",     TERRITORY_BR_AM},
        {"AMU",    TERRITORY_RU_AMU},
        {"AN",     TERRITORY_IN_AN},
        {"AND",    TERRITORY_AND},
        {"AP",     TERRITORY_IN_AP},
        {"AR",     TERRITORY_IN_AR},
        {"ARE",    TERRITORY_ARE},
        {"ARG",    TERRITORY_ARG},
        {"ARK",    TERRITORY_RU_ARK},
        {"ARM",    TERRITORY_ARM},
        {"AS",     TERRITORY_IN_AS},
        {"ASC",    TERRITORY_SHN},
        {"ASM",    TERRITORY_ASM},
        {"AST",    TERRITORY_RU_AST},
        {"ATA",    TERRITORY_ATA},
        {"ATF",    TERRITORY_ATF},
        {"ATG",    TERRITORY_ATG},
        {"AU",     TERRITORY_AUS},
        {"AU-ACT", TERRITORY_AU_ACT},
        {"AU-CC",  TERRITORY_CCK},
        {"AU-CX",  TERRITORY_CXR},
        {"AU-HM",  TERRITORY_HMD},
        {"AU-JBT", TERRITORY_AU_JBT},
        {"AU-NF",  TERRITORY_NFK},
        {"AU-NSW", TERRITORY_AU_NSW},
        {"AU-NT",  TERRITORY_AU_NT},
        {"AU-QLD", TERRITORY_AU_QLD},
        {"AU-SA",  TERRITORY_AU_SA},
        {"AU-TAS", TERRITORY_AU_TAS},
        {"AU-VIC", TERRITORY_AU_VIC},
        {"AU-WA",  TERRITORY_AU_WA},
        {"AUS",    TERRITORY_AUS},
        {"AUT",    TERRITORY_AUT},
        {"AZ",     TERRITORY_US_AZ},
        {"AZE",    TERRITORY_AZE},
        {"BA",     TERRITORY_BR_BA},
        {"BC",     TERRITORY_CA_BC},
        {"BCN",    TERRITORY_MX_BCN},
        {"BCS",    TERRITORY_MX_BCS},
        {"BDI",    TERRITORY_BDI},
        {"BE",     TERRITORY_RU_BE},
        {"BEL",    TERRITORY_BEL},
        {"BEN",    TERRITORY_BEN},
        {"BES",    TERRITORY_BES},
        {"BFA",    TERRITORY_BFA},
        {"BGD",    TERRITORY_BGD},
        {"BGR",    TERRITORY_BGR},
        {"BHR",    TERRITORY_BHR},
        {"BHS",    TERRITORY_BHS},
        {"BIH",    TERRITORY_BIH},
        {"BJ",     TERRITORY_CN_BJ},
        {"BLM",    TERRITORY_BLM},
        {"BLR",    TERRITORY_BLR},
        {"BLZ",    TERRITORY_BLZ},
        {"BMU",    TERRITORY_BMU},
        {"BOL",    TERRITORY_BOL},
        {"BR",     TERRITORY_IN_BR},
        {"BR-AC",  TERRITORY_BR_AC},
        {"BR-AL",  TERRITORY_BR_AL},
        {"BR-AM",  TERRITORY_BR_AM},
        {"BR-AP",  TERRITORY_BR_AP},
        {"BR-BA",  TERRITORY_BR_BA},
        {"BR-CE",  TERRITORY_BR_CE},
        {"BR-DF",  TERRITORY_BR_DF},
        {"BR-ES",  TERRITORY_BR_ES},
        {"BR-GO",  TERRITORY_BR_GO},
        {"BR-MA",  TERRITORY_BR_MA},
        {"BR-MG",  TERRITORY_BR_MG},
        {"BR-MS",  TERRITORY_BR_MS},
        {"BR-MT",  TERRITORY_BR_MT},
        {"BR-PA",  TERRITORY_BR_PA},
        {"BR-PB",  TERRITORY_BR_PB},
        {"BR-PE",  TERRITORY_BR_PE},
        {"BR-PI",  TERRITORY_BR_PI},
        {"BR-PR",  TERRITORY_BR_PR},
        {"BR-RJ",  TERRITORY_BR_RJ},
        {"BR-RN",  TERRITORY_BR_RN},
        {"BR-RO",  TERRITORY_BR_RO},
        {"BR-RR",  TERRITORY_BR_RR},
        {"BR-RS",  TERRITORY_BR_RS},
        {"BR-SC",  TERRITORY_BR_SC},
        {"BR-SE",  TERRITORY_BR_SE},
        {"BR-SP",  TERRITORY_BR_SP},
        {"BR-TO",  TERRITORY_BR_TO},
        {"BRA",    TERRITORY_BRA},
        {"BRB",    TERRITORY_BRB},
        {"BRN",    TERRITORY_BRN},
        {"BRY",    TERRITORY_RU_BRY},
        {"BS",     TERRITORY_MX_BCS},
        {"BTN",    TERRITORY_BTN},
        {"BU",     TERRITORY_RU_BU},
        {"BVT",    TERRITORY_BVT},
        {"BWA",    TERRITORY_BWA},
        {"CA",     TERRITORY_US_CA},
        {"CA-AB",  TERRITORY_CA_AB},
        {"CA-BC",  TERRITORY_CA_BC},
        {"CA-MB",  TERRITORY_CA_MB},
        {"CA-NB",  TERRITORY_CA_NB},
        {"CA-NL",  TERRITORY_CA_NL},
        {"CA-NS",  TERRITORY_CA_NS},
        {"CA-NT",  TERRITORY_CA_NT},
        {"CA-NU",  TERRITORY_CA_NU},
        {"CA-ON",  TERRITORY_CA_ON},
        {"CA-PE",  TERRITORY_CA_PE},
        {"CA-QC",  TERRITORY_CA_QC},
        {"CA-SK",  TERRITORY_CA_SK},
        {"CA-YT",  TERRITORY_CA_YT},
        {"CAF",    TERRITORY_CAF},
        {"CAM",    TERRITORY_MX_CAM},
        {"CAN",    TERRITORY_CAN},
        {"CC",     TERRITORY_CCK},
        {"CCK",    TERRITORY_CCK},
        {"CE",     TERRITORY_BR_CE},
        {"CG",     TERRITORY_IN_CT},
        {"CH",     TERRITORY_IN_CH},
        {"CHE",    TERRITORY_CHE},
        {"CHH",    TERRITORY_MX_CHH},
        {"CHL",    TERRITORY_CHL},
        {"CHN",    TERRITORY_CHN},
        {"CHP",    TERRITORY_MX_CHP},
        {"CHU",    TERRITORY_RU_CHU},
        {"CIV",    TERRITORY_CIV},
        {"CL",     TERRITORY_MX_CL},
        {"CM",     TERRITORY_MX_CAM},
        {"CMR",    TERRITORY_CMR},
        {"CN",     TERRITORY_CHN},
        {"CN-11",  TERRITORY_CN_BJ},
        {"CN-12",  TERRITORY_CN_TJ},
        {"CN-13",  TERRITORY_CN_HE},
        {"CN-14",  TERRITORY_CN_SX},
        {"CN-15",  TERRITORY_CN_NM},
        {"CN-21",  TERRITORY_CN_LN},
        {"CN-22",  TERRITORY_CN_JL},
        {"CN-23",  TERRITORY_CN_HL},
        {"CN-31",  TERRITORY_CN_SH},
        {"CN-32",  TERRITORY_CN_JS},
        {"CN-33",  TERRITORY_CN_ZJ},
        {"CN-34",  TERRITORY_CN_AH},
        {"CN-35",  TERRITORY_CN_FJ},
        {"CN-36",  TERRITORY_CN_JX},
        {"CN-37",  TERRITORY_CN_SD},
        {"CN-41",  TERRITORY_CN_HA},
        {"CN-42",  TERRITORY_CN_HB},
        {"CN-43",  TERRITORY_CN_HN},
        {"CN-44",  TERRITORY_CN_GD},
        {"CN-45",  TERRITORY_CN_GX},
        {"CN-46",  TERRITORY_CN_HI},
        {"CN-50",  TERRITORY_CN_CQ},
        {"CN-51",  TERRITORY_CN_SC},
        {"CN-52",  TERRITORY_CN_GZ},
        {"CN-53",  TERRITORY_CN_YN},
        {"CN-54",  TERRITORY_CN_XZ},
        {"CN-61",  TERRITORY_CN_SN},
        {"CN-62",  TERRITORY_CN_GS},
        {"CN-63",  TERRITORY_CN_QH},
        {"CN-64",  TERRITORY_CN_NX},
        {"CN-65",  TERRITORY_CN_XJ},
        {"CN-71",  TERRITORY_TWN},
        {"CN-91",  TERRITORY_HKG},
        {"CN-92",  TERRITORY_MAC},
        {"CN-AH",  TERRITORY_CN_AH},
        {"CN-BJ",  TERRITORY_CN_BJ},
        {"CN-CQ",  TERRITORY_CN_CQ},
        {"CN-FJ",  TERRITORY_CN_FJ},
        {"CN-GD",  TERRITORY_CN_GD},
        {"CN-GS",  TERRITORY_CN_GS},
        {"CN-GX",  TERRITORY_CN_GX},
        {"CN-GZ",  TERRITORY_CN_GZ},
        {"CN-HA",  TERRITORY_CN_HA},
        {"CN-HB",  TERRITORY_CN_HB},
        {"CN-HE",  TERRITORY_CN_HE},
        {"CN-HI",  TERRITORY_CN_HI},
        {"CN-HK",  TERRITORY_HKG},
        {"CN-HL",  TERRITORY_CN_HL},
        {"CN-HN",  TERRITORY_CN_HN},
        {"CN-JL",  TERRITORY_CN_JL},
        {"CN-JS",  TERRITORY_CN_JS},
        {"CN-JX",  TERRITORY_CN_JX},
        {"CN-LN",  TERRITORY_CN_LN},
        {"CN-MC",  TERRITORY_MAC},
        {"CN-NM",  TERRITORY_CN_NM},
        {"CN-NX",  TERRITORY_CN_NX},
        {"CN-QH",  TERRITORY_CN_QH},
        {"CN-SC",  TERRITORY_CN_SC},
        {"CN-SD",  TERRITORY_CN_SD},
        {"CN-SH",  TERRITORY_CN_SH},
        {"CN-SN",  TERRITORY_CN_SN},
        {"CN-SX",  TERRITORY_CN_SX},
        {"CN-TJ",  TERRITORY_CN_TJ},
        {"CN-TW",  TERRITORY_TWN},
        {"CN-XJ",  TERRITORY_CN_XJ},
        {"CN-XZ",  TERRITORY_CN_XZ},
        {"CN-YN",  TERRITORY_CN_YN},
        {"CN-ZJ",  TERRITORY_CN_ZJ},
        {"CO",     TERRITORY_US_CO},
        {"COA",    TERRITORY_MX_COA},
        {"COD",    TERRITORY_COD},
        {"COG",    TERRITORY_COG},
        {"COK",    TERRITORY_COK},
        {"COL",    TERRITORY_COL},
        {"COM",    TERRITORY_COM},
        {"CPT",    TERRITORY_CPT},
        {"CPV",    TERRITORY_CPV},
        {"CQ",     TERRITORY_CN_CQ},
        {"CRI",    TERRITORY_CRI},
        {"CS",     TERRITORY_MX_CHP},
        {"CT",     TERRITORY_IN_CT},
        {"CU",     TERRITORY_RU_CU},
        {"CUB",    TERRITORY_CUB},
        {"CUW",    TERRITORY_CUW},
        {"CX",     TERRITORY_CXR},
        {"CXR",    TERRITORY_CXR},
        {"CYM",    TERRITORY_CYM},
        {"CYP",    TERRITORY_CYP},
        {"CZE",    TERRITORY_CZE},
        {"DA",     TERRITORY_RU_DA},
        {"DC",     TERRITORY_US_DC},
        {"DD",     TERRITORY_IN_DD},
        {"DE",     TERRITORY_US_DE},
        {"DEU",    TERRITORY_DEU},
        {"DF",     TERRITORY_BR_DF},
        {"DG",     TERRITORY_MX_DUR},
        {"DGA",    TERRITORY_IOT},
        {"DIF",    TERRITORY_MX_DIF},
        {"DJI",    TERRITORY_DJI},
        {"DL",     TERRITORY_IN_DL},
        {"DMA",    TERRITORY_DMA},
        {"DN",     TERRITORY_IN_DN},
        {"DNK",    TERRITORY_DNK},
        {"DOM",    TERRITORY_DOM},
        {"DUR",    TERRITORY_MX_DUR},
        {"DZA",    TERRITORY_DZA},
        {"ECU",    TERRITORY_ECU},
        {"EGY",    TERRITORY_EGY},
        {"ERI",    TERRITORY_ERI},
        {"ES",     TERRITORY_BR_ES},
        {"ESH",    TERRITORY_ESH},
        {"ESP",    TERRITORY_ESP},
        {"EST",    TERRITORY_EST},
        {"ETH",    TERRITORY_ETH},
        {"FIN",    TERRITORY_FIN},
        {"FJ",     TERRITORY_CN_FJ},
        {"FJI",    TERRITORY_FJI},
        {"FL",     TERRITORY_US_FL},
        {"FLK",    TERRITORY_FLK},
        {"FRA",    TERRITORY_FRA},
        {"FRO",    TERRITORY_FRO},
        {"FSM",    TERRITORY_FSM},
        {"GA",     TERRITORY_IN_GA},
        {"GAB",    TERRITORY_GAB},
        {"GBR",    TERRITORY_GBR},
        {"GD",     TERRITORY_CN_GD},
        {"GEO",    TERRITORY_GEO},
        {"GGY",    TERRITORY_GGY},
        {"GHA",    TERRITORY_GHA},
        {"GIB",    TERRITORY_GIB},
        {"GIN",    TERRITORY_GIN},
        {"GJ",     TERRITORY_IN_GJ},
        {"GLP",    TERRITORY_GLP},
        {"GMB",    TERRITORY_GMB},
        {"GNB",    TERRITORY_GNB},
        {"GNQ",    TERRITORY_GNQ},
        {"GO",     TERRITORY_BR_GO},
        {"GR",     TERRITORY_MX_GRO},
        {"GRC",    TERRITORY_GRC},
        {"GRD",    TERRITORY_GRD},
        {"GRL",    TERRITORY_GRL},
        {"GRO",    TERRITORY_MX_GRO},
        {"GS",     TERRITORY_CN_GS},
        {"GT",     TERRITORY_MX_GUA},
        {"GTM",    TERRITORY_GTM},
        {"GU",     TERRITORY_GUM},
        {"GUA",    TERRITORY_MX_GUA},
        {"GUF",    TERRITORY_GUF},
        {"GUM",    TERRITORY_GUM},
        {"GUY",    TERRITORY_GUY},
        {"GX",     TERRITORY_CN_GX},
        {"GZ",     TERRITORY_CN_GZ},
        {"HA",     TERRITORY_CN_HA},
        {"HB",     TERRITORY_CN_HB},
        {"HE",     TERRITORY_CN_HE},
        {"HG",     TERRITORY_MX_HID},
        {"HI",     TERRITORY_US_HI},
        {"HID",    TERRITORY_MX_HID},
        {"HK",     TERRITORY_HKG},
        {"HKG",    TERRITORY_HKG},
        {"HL",     TERRITORY_CN_HL},
        {"HM",     TERRITORY_HMD},
        {"HMD",    TERRITORY_HMD},
        {"HN",     TERRITORY_CN_HN},
        {"HND",    TERRITORY_HND},
        {"HP",     TERRITORY_IN_HP},
        {"HR",     TERRITORY_IN_HR},
        {"HRV",    TERRITORY_HRV},
        {"HTI",    TERRITORY_HTI},
        {"HUN",    TERRITORY_HUN},
        {"IA",     TERRITORY_US_IA},
        {"ID",     TERRITORY_US_ID},
        {"IDN",    TERRITORY_IDN},
        {"IL",     TERRITORY_US_IL},
        {"IMN",    TERRITORY_IMN},
        {"IN",     TERRITORY_US_IN},
        {"IN-AN",  TERRITORY_IN_AN},
        {"IN-AP",  TERRITORY_IN_AP},
        {"IN-AR",  TERRITORY_IN_AR},
        {"IN-AS",  TERRITORY_IN_AS},
        {"IN-BR",  TERRITORY_IN_BR},
        {"IN-CG",  TERRITORY_IN_CT},
        {"IN-CH",  TERRITORY_IN_CH},
        {"IN-CT",  TERRITORY_IN_CT},
        {"IN-DD",  TERRITORY_IN_DD},
        {"IN-DL",  TERRITORY_IN_DL},
        {"IN-DN",  TERRITORY_IN_DN},
        {"IN-GA",  TERRITORY_IN_GA},
        {"IN-GJ",  TERRITORY_IN_GJ},
        {"IN-HP",  TERRITORY_IN_HP},
        {"IN-HR",  TERRITORY_IN_HR},
        {"IN-JH",  TERRITORY_IN_JH},
        {"IN-JK",  TERRITORY_IN_JK},
        {"IN-KA",  TERRITORY_IN_KA},
        {"IN-KL",  TERRITORY_IN_KL},
        {"IN-LD",  TERRITORY_IN_LD},
        {"IN-MH",  TERRITORY_IN_MH},
        {"IN-ML",  TERRITORY_IN_ML},
        {"IN-MN",  TERRITORY_IN_MN},
        {"IN-MP",  TERRITORY_IN_MP},
        {"IN-MZ",  TERRITORY_IN_MZ},
        {"IN-NL",  TERRITORY_IN_NL},
        {"IN-OD",  TERRITORY_IN_OR},
        {"IN-OR",  TERRITORY_IN_OR},
        {"IN-PB",  TERRITORY_IN_PB},
        {"IN-PY",  TERRITORY_IN_PY},
        {"IN-RJ",  TERRITORY_IN_RJ},
        {"IN-SK",  TERRITORY_IN_SK},
        {"IN-TG",  TERRITORY_IN_TG},
        {"IN-TN",  TERRITORY_IN_TN},
        {"IN-TR",  TERRITORY_IN_TR},
        {"IN-UK",  TERRITORY_IN_UT},
        {"IN-UP",  TERRITORY_IN_UP},
        {"IN-UT",  TERRITORY_IN_UT},
        {"IN-WB",  TERRITORY_IN_WB},
        {"IND",    TERRITORY_IND},
        {"IOT",    TERRITORY_IOT},
        {"IRK",    TERRITORY_RU_IRK},
        {"IRL",    TERRITORY_IRL},
        {"IRN",    TERRITORY_IRN},
        {"IRQ",    TERRITORY_IRQ},
        {"ISL",    TERRITORY_ISL},
        {"ISR",    TERRITORY_ISR},
        {"ITA",    TERRITORY_ITA},
        {"IVA",    TERRITORY_RU_IVA},
        {"JA",     TERRITORY_MX_JAL},
        {"JAL",    TERRITORY_MX_JAL},
        {"JAM",    TERRITORY_JAM},
        {"JBT",    TERRITORY_AU_JBT},
        {"JEY",    TERRITORY_JEY},
        {"JH",     TERRITORY_IN_JH},
        {"JK",     TERRITORY_IN_JK},
        {"JL",     TERRITORY_CN_JL},
        {"JOR",    TERRITORY_JOR},
        {"JPN",    TERRITORY_JPN},
        {"JS",     TERRITORY_CN_JS},
        {"JTN",    TERRITORY_UMI},
        {"JX",     TERRITORY_CN_JX},
        {"KA",     TERRITORY_IN_KA},
        {"KAM",    TERRITORY_RU_KAM},
        {"KAZ",    TERRITORY_KAZ},
        {"KB",     TERRITORY_RU_KB},
        {"KC",     TERRITORY_RU_KC},
        {"KDA",    TERRITORY_RU_KDA},
        {"KEM",    TERRITORY_RU_KEM},
        {"KEN",    TERRITORY_KEN},
        {"KGD",    TERRITORY_RU_KGD},
        {"KGN",    TERRITORY_RU_KGN},
        {"KGZ",    TERRITORY_KGZ},
        {"KHA",    TERRITORY_RU_KHA},
        {"KHM",    TERRITORY_KHM},
        {"KI",     TERRITORY_RU_KI},
        {"KIR",    TERRITORY_KIR},
        {"KK",     TERRITORY_RU_KK},
        {"KL",     TERRITORY_IN_KL},
        {"KLU",    TERRITORY_RU_KLU},
        {"KM",     TERRITORY_RU_KM},
        {"KNA",    TERRITORY_KNA},
        {"KO",     TERRITORY_RU_KO},
        {"KOR",    TERRITORY_KOR},
        {"KOS",    TERRITORY_RU_KOS},
        {"KR",     TERRITORY_RU_KR},
        {"KRS",    TERRITORY_RU_KRS},
        {"KS",     TERRITORY_US_KS},
        {"KWT",    TERRITORY_KWT},
        {"KY",     TERRITORY_US_KY},
        {"KYA",    TERRITORY_RU_KYA},
        {"LA",     TERRITORY_US_LA},
        {"LAO",    TERRITORY_LAO},
        {"LBN",    TERRITORY_LBN},
        {"LBR",    TERRITORY_LBR},
        {"LBY",    TERRITORY_LBY},
        {"LCA",    TERRITORY_LCA},
        {"LD",     TERRITORY_IN_LD},
        {"LEN",    TERRITORY_RU_LEN},
        {"LIE",    TERRITORY_LIE},
        {"LIP",    TERRITORY_RU_LIP},
        {"LKA",    TERRITORY_LKA},
        {"LN",     TERRITORY_CN_LN},
        {"LSO",    TERRITORY_LSO},
        {"LTU",    TERRITORY_LTU},
        {"LUX",    TERRITORY_LUX},
        {"LVA",    TERRITORY_LVA},
        {"MA",     TERRITORY_BR_MA},
        {"MAC",    TERRITORY_MAC},
        {"MAF",    TERRITORY_MAF},
        {"MAG",    TERRITORY_RU_MAG},
        {"MAR",    TERRITORY_MAR},
        {"MB",     TERRITORY_CA_MB},
        {"MC",     TERRITORY_MAC},
        {"MCO",    TERRITORY_MCO},
        {"MD",     TERRITORY_US_MD},
        {"MDA",    TERRITORY_MDA},
        {"MDG",    TERRITORY_MDG},
        {"MDV",    TERRITORY_MDV},
        {"ME",     TERRITORY_US_ME},
        {"MEX",    TERRITORY_MEX},
        {"MG",     TERRITORY_BR_MG},
        {"MH",     TERRITORY_IN_MH},
        {"MHL",    TERRITORY_MHL},
        {"MI",     TERRITORY_US_MI},
        {"MIC",    TERRITORY_MX_MIC},
        {"MID",    TERRITORY_US_HI},
        {"MKD",    TERRITORY_MKD},
        {"ML",     TERRITORY_IN_ML},
        {"MLI",    TERRITORY_MLI},
        {"MLT",    TERRITORY_MLT},
        {"MMR",    TERRITORY_MMR},
        {"MN",     TERRITORY_IN_MN},
        {"MNE",    TERRITORY_MNE},
        {"MNG",    TERRITORY_MNG},
        {"MNP",    TERRITORY_MNP},
        {"MO",     TERRITORY_US_MO},
        {"MOR",    TERRITORY_MX_MOR},
        {"MOS",    TERRITORY_RU_MOS},
        {"MOW",    TERRITORY_RU_MOW},
        {"MOZ",    TERRITORY_MOZ},
        {"MP",     TERRITORY_IN_MP},
        {"MRT",    TERRITORY_MRT},
        {"MS",     TERRITORY_BR_MS},
        {"MSR",    TERRITORY_MSR},
        {"MT",     TERRITORY_BR_MT},
        {"MTQ",    TERRITORY_MTQ},
        {"MUR",    TERRITORY_RU_MUR},
        {"MUS",    TERRITORY_MUS},
        {"MWI",    TERRITORY_MWI},
        {"MX",     TERRITORY_MX_MX},
        {"MX-AG",  TERRITORY_MX_AGU},
        {"MX-AGU", TERRITORY_MX_AGU},
        {"MX-BC",  TERRITORY_MX_BCN},
        {"MX-BCN", TERRITORY_MX_BCN},
        {"MX-BCS", TERRITORY_MX_BCS},
        {"MX-BS",  TERRITORY_MX_BCS},
        {"MX-CAM", TERRITORY_MX_CAM},
        {"MX-CH",  TERRITORY_MX_CHH},
        {"MX-CHH", TERRITORY_MX_CHH},
        {"MX-CHP", TERRITORY_MX_CHP},
        {"MX-CL",  TERRITORY_MX_CL},
        {"MX-CM",  TERRITORY_MX_CAM},
        {"MX-CO",  TERRITORY_MX_COA},
        {"MX-COA", TERRITORY_MX_COA},
        {"MX-COL", TERRITORY_MX_CL},
        {"MX-CS",  TERRITORY_MX_CHP},
        {"MX-DF",  TERRITORY_MX_DIF},
        {"MX-DG",  TERRITORY_MX_DUR},
        {"MX-DIF", TERRITORY_MX_DIF},
        {"MX-DUR", TERRITORY_MX_DUR},
        {"MX-GR",  TERRITORY_MX_GRO},
        {"MX-GRO", TERRITORY_MX_GRO},
        {"MX-GT",  TERRITORY_MX_GUA},
        {"MX-GUA", TERRITORY_MX_GUA},
        {"MX-HG",  TERRITORY_MX_HID},
        {"MX-HID", TERRITORY_MX_HID},
        {"MX-JA",  TERRITORY_MX_JAL},
        {"MX-JAL", TERRITORY_MX_JAL},
        {"MX-ME",  TERRITORY_MX_MX},
        {"MX-MEX", TERRITORY_MX_MX},
        {"MX-MI",  TERRITORY_MX_MIC},
        {"MX-MIC", TERRITORY_MX_MIC},
        {"MX-MO",  TERRITORY_MX_MOR},
        {"MX-MOR", TERRITORY_MX_MOR},
        {"MX-MX",  TERRITORY_MX_MX},
        {"MX-NA",  TERRITORY_MX_NAY},
        {"MX-NAY", TERRITORY_MX_NAY},
        {"MX-NL",  TERRITORY_MX_NLE},
        {"MX-NLE", TERRITORY_MX_NLE},
        {"MX-OA",  TERRITORY_MX_OAX},
        {"MX-OAX", TERRITORY_MX_OAX},
        {"MX-PB",  TERRITORY_MX_PUE},
        {"MX-PUE", TERRITORY_MX_PUE},
        {"MX-QE",  TERRITORY_MX_QUE},
        {"MX-QR",  TERRITORY_MX_ROO},
        {"MX-QUE", TERRITORY_MX_QUE},
        {"MX-ROO", TERRITORY_MX_ROO},
        {"MX-SI",  TERRITORY_MX_SIN},
        {"MX-SIN", TERRITORY_MX_SIN},
        {"MX-SL",  TERRITORY_MX_SLP},
        {"MX-SLP", TERRITORY_MX_SLP},
        {"MX-SO",  TERRITORY_MX_SON},
        {"MX-SON", TERRITORY_MX_SON},
        {"MX-TAB", TERRITORY_MX_TAB},
        {"MX-TAM", TERRITORY_MX_TAM},
        {"MX-TB",  TERRITORY_MX_TAB},
        {"MX-TL",  TERRITORY_MX_TLA},
        {"MX-TLA", TERRITORY_MX_TLA},
        {"MX-TM",  TERRITORY_MX_TAM},
        {"MX-VE",  TERRITORY_MX_VER},
        {"MX-VER", TERRITORY_MX_VER},
        {"MX-YU",  TERRITORY_MX_YUC},
        {"MX-YUC", TERRITORY_MX_YUC},
        {"MX-ZA",  TERRITORY_MX_ZAC},
        {"MX-ZAC", TERRITORY_MX_ZAC},
        {"MYS",    TERRITORY_MYS},
        {"MYT",    TERRITORY_MYT},
        {"MZ",     TERRITORY_IN_MZ},
        {"NA",     TERRITORY_MX_NAY},
        {"NAM",    TERRITORY_NAM},
        {"NAY",    TERRITORY_MX_NAY},
        {"NB",     TERRITORY_CA_NB},
        {"NC",     TERRITORY_US_NC},
        {"NCL",    TERRITORY_NCL},
        {"ND",     TERRITORY_US_ND},
        {"NE",     TERRITORY_US_NE},
        {"NEN",    TERRITORY_RU_NEN},
        {"NER",    TERRITORY_NER},
        {"NF",     TERRITORY_NFK},
        {"NFK",    TERRITORY_NFK},
        {"NGA",    TERRITORY_NGA},
        {"NGR",    TERRITORY_RU_NGR},
        {"NH",     TERRITORY_US_NH},
        {"NIC",    TERRITORY_NIC},
        {"NIU",    TERRITORY_NIU},
        {"NIZ",    TERRITORY_RU_NIZ},
        {"NJ",     TERRITORY_US_NJ},
        {"NL",     TERRITORY_IN_NL},
        {"NLD",    TERRITORY_NLD},
        {"NLE",    TERRITORY_MX_NLE},
        {"NM",     TERRITORY_US_NM},
        {"NOR",    TERRITORY_NOR},
        {"NPL",    TERRITORY_NPL},
        {"NRU",    TERRITORY_NRU},
        {"NS",     TERRITORY_CA_NS},
        {"NSW",    TERRITORY_AU_NSW},
        {"NT",     TERRITORY_AU_NT},
        {"NU",     TERRITORY_CA_NU},
        {"NV",     TERRITORY_US_NV},
        {"NVS",    TERRITORY_RU_NVS},
        {"NX",     TERRITORY_CN_NX},
        {"NY",     TERRITORY_US_NY},
        {"NZL",    TERRITORY_NZL},
        {"OA",     TERRITORY_MX_OAX},
        {"OAX",    TERRITORY_MX_OAX},
        {"OD",     TERRITORY_IN_OR},
        {"OH",     TERRITORY_US_OH},
        {"OK",     TERRITORY_US_OK},
        {"OMN",    TERRITORY_OMN},
        {"OMS",    TERRITORY_RU_OMS},
        {"ON",     TERRITORY_CA_ON},
        {"OR",     TERRITORY_IN_OR},
        {"ORE",    TERRITORY_RU_ORE},
        {"ORL",    TERRITORY_RU_ORL},
        {"PA",     TERRITORY_BR_PA},
        {"PAK",    TERRITORY_PAK},
        {"PAN",    TERRITORY_PAN},
        {"PB",     TERRITORY_IN_PB},
        {"PCN",    TERRITORY_PCN},
        {"PE",     TERRITORY_BR_PE},
        {"PER",    TERRITORY_PER},
        {"PHL",    TERRITORY_PHL},
        {"PI",     TERRITORY_BR_PI},
        {"PLW",    TERRITORY_PLW},
        {"PM",     TERRITORY_RU_PM},
        {"PNG",    TERRITORY_PNG},
        {"PNZ",    TERRITORY_RU_PNZ},
        {"PO",     TERRITORY_RU_PO},
        {"POL",    TERRITORY_POL},
        {"PR",     TERRITORY_BR_PR},
        {"PRI",    TERRITORY_PRI},
        {"PRK",    TERRITORY_PRK},
        {"PRT",    TERRITORY_PRT},
        {"PRY",    TERRITORY_PRY},
        {"PSE",    TERRITORY_PSE},
        {"PSK",    TERRITORY_RU_PSK},
        {"PUE",    TERRITORY_MX_PUE},
        {"PY",     TERRITORY_IN_PY},
        {"PYF",    TERRITORY_PYF},
        {"QAT",    TERRITORY_QAT},
        {"QC",     TERRITORY_CA_QC},
        {"QE",     TERRITORY_MX_QUE},
        {"QH",     TERRITORY_CN_QH},
        {"QLD",    TERRITORY_AU_QLD},
        {"QR",     TERRITORY_MX_ROO},
        {"QUE",    TERRITORY_MX_QUE},
        {"REU",    TERRITORY_REU},
        {"RI",     TERRITORY_US_RI},
        {"RJ",     TERRITORY_IN_RJ},
        {"RN",     TERRITORY_BR_RN},
        {"RO",     TERRITORY_BR_RO},
        {"ROO",    TERRITORY_MX_ROO},
        {"ROS",    TERRITORY_RU_ROS},
        {"ROU",    TERRITORY_ROU},
        {"RR",     TERRITORY_BR_RR},
        {"RS",     TERRITORY_BR_RS},
        {"RU",     TERRITORY_RUS},
        {"RU-AD",  TERRITORY_RU_AD},
        {"RU-AL",  TERRITORY_RU_AL},
        {"RU-ALT", TERRITORY_RU_ALT},
        {"RU-AMU", TERRITORY_RU_AMU},
        {"RU-ARK", TERRITORY_RU_ARK},
        {"RU-AST", TERRITORY_RU_AST},
        {"RU-BA",  TERRITORY_RU_BA},
        {"RU-BE",  TERRITORY_RU_BE},
        {"RU-BEL", TERRITORY_RU_BE},
        {"RU-BRY", TERRITORY_RU_BRY},
        {"RU-BU",  TERRITORY_RU_BU},
        {"RU-CE",  TERRITORY_RU_CE},
        {"RU-CH",  TERRITORY_RU_CH},
        {"RU-CHE", TERRITORY_RU_CH},
        {"RU-CHU", TERRITORY_RU_CHU},
        {"RU-CU",  TERRITORY_RU_CU},
        {"RU-DA",  TERRITORY_RU_DA},
        {"RU-IN",  TERRITORY_RU_IN},
        {"RU-IRK", TERRITORY_RU_IRK},
        {"RU-IVA", TERRITORY_RU_IVA},
        {"RU-KAM", TERRITORY_RU_KAM},
        {"RU-KB",  TERRITORY_RU_KB},
        {"RU-KC",  TERRITORY_RU_KC},
        {"RU-KDA", TERRITORY_RU_KDA},
        {"RU-KEM", TERRITORY_RU_KEM},
        {"RU-KGD", TERRITORY_RU_KGD},
        {"RU-KGN", TERRITORY_RU_KGN},
        {"RU-KHA", TERRITORY_RU_KHA},
        {"RU-KHM", TERRITORY_RU_KM},
        {"RU-KI",  TERRITORY_RU_KI},
        {"RU-KIR", TERRITORY_RU_KI},
        {"RU-KK",  TERRITORY_RU_KK},
        {"RU-KL",  TERRITORY_RU_KL},
        {"RU-KLU", TERRITORY_RU_KLU},
        {"RU-KM",  TERRITORY_RU_KM},
        {"RU-KO",  TERRITORY_RU_KO},
        {"RU-KOS", TERRITORY_RU_KOS},
        {"RU-KR",  TERRITORY_RU_KR},
        {"RU-KRS", TERRITORY_RU_KRS},
        {"RU-KYA", TERRITORY_RU_KYA},
        {"RU-LEN", TERRITORY_RU_LEN},
        {"RU-LIP", TERRITORY_RU_LIP},
        {"RU-MAG", TERRITORY_RU_MAG},
        {"RU-ME",  TERRITORY_RU_ME},
        {"RU-MO",  TERRITORY_RU_MO},
        {"RU-MOS", TERRITORY_RU_MOS},
        {"RU-MOW", TERRITORY_RU_MOW},
        {"RU-MUR", TERRITORY_RU_MUR},
        {"RU-NEN", TERRITORY_RU_NEN},
        {"RU-NGR", TERRITORY_RU_NGR},
        {"RU-NIZ", TERRITORY_RU_NIZ},
        {"RU-NVS", TERRITORY_RU_NVS},
        {"RU-OMS", TERRITORY_RU_OMS},
        {"RU-ORE", TERRITORY_RU_ORE},
        {"RU-ORL", TERRITORY_RU_ORL},
        {"RU-PER", TERRITORY_RU_PM},
        {"RU-PM",  TERRITORY_RU_PM},
        {"RU-PNZ", TERRITORY_RU_PNZ},
        {"RU-PO",  TERRITORY_RU_PO},
        {"RU-PRI", TERRITORY_RU_PO},
        {"RU-PSK", TERRITORY_RU_PSK},
        {"RU-ROS", TERRITORY_RU_ROS},
        {"RU-RYA", TERRITORY_RU_RYA},
        {"RU-SA",  TERRITORY_RU_SA},
        {"RU-SAK", TERRITORY_RU_SAK},
        {"RU-SAM", TERRITORY_RU_SAM},
        {"RU-SAR", TERRITORY_RU_SAR},
        {"RU-SE",  TERRITORY_RU_SE},
        {"RU-SMO", TERRITORY_RU_SMO},
        {"RU-SPE", TERRITORY_RU_SPE},
        {"RU-STA", TERRITORY_RU_STA},
        {"RU-SVE", TERRITORY_RU_SVE},
        {"RU-TA",  TERRITORY_RU_TA},
        {"RU-TAM", TERRITORY_RU_TT},
        {"RU-TOM", TERRITORY_RU_TOM},
        {"RU-TT",  TERRITORY_RU_TT},
        {"RU-TUL", TERRITORY_RU_TUL},
        {"RU-TVE", TERRITORY_RU_TVE},
        {"RU-TY",  TERRITORY_RU_TY},
        {"RU-TYU", TERRITORY_RU_TYU},
        {"RU-UD",  TERRITORY_RU_UD},
        {"RU-ULY", TERRITORY_RU_ULY},
        {"RU-VGG", TERRITORY_RU_VGG},
        {"RU-VLA", TERRITORY_RU_VLA},
        {"RU-VLG", TERRITORY_RU_VLG},
        {"RU-VOR", TERRITORY_RU_VOR},
        {"RU-YAN", TERRITORY_RU_YAN},
        {"RU-YAR", TERRITORY_RU_YAR},
        {"RU-YEV", TERRITORY_RU_YEV},
        {"RU-ZAB", TERRITORY_RU_ZAB},
        {"RUS",    TERRITORY_RUS},
        {"RWA",    TERRITORY_RWA},
        {"RYA",    TERRITORY_RU_RYA},
        {"SA",     TERRITORY_AU_SA},
        {"SAK",    TERRITORY_RU_SAK},
        {"SAM",    TERRITORY_RU_SAM},
        {"SAR",    TERRITORY_RU_SAR},
        {"SAU",    TERRITORY_SAU},
        {"SC",     TERRITORY_BR_SC},
        {"SD",     TERRITORY_US_SD},
        {"SDN",    TERRITORY_SDN},
        {"SE",     TERRITORY_BR_SE},
        {"SEN",    TERRITORY_SEN},
        {"SGP",    TERRITORY_SGP},
        {"SGS",    TERRITORY_SGS},
        {"SH",     TERRITORY_CN_SH},
        {"SHN",    TERRITORY_SHN},
        {"SI",     TERRITORY_MX_SIN},
        {"SIN",    TERRITORY_MX_SIN},
        {"SJM",    TERRITORY_SJM},
        {"SK",     TERRITORY_IN_SK},
        {"SL",     TERRITORY_MX_SLP},
        {"SLB",    TERRITORY_SLB},
        {"SLE",    TERRITORY_SLE},
        {"SLP",    TERRITORY_MX_SLP},
        {"SLV",    TERRITORY_SLV},
        {"SMO",    TERRITORY_RU_SMO},
        {"SMR",    TERRITORY_SMR},
        {"SN",     TERRITORY_CN_SN},
        {"SO",     TERRITORY_MX_SON},
        {"SOM",    TERRITORY_SOM},
        {"SON",    TERRITORY_MX_SON},
        {"SP",     TERRITORY_BR_SP},
        {"SPE",    TERRITORY_RU_SPE},
        {"SPM",    TERRITORY_SPM},
        {"SRB",    TERRITORY_SRB},
        {"SSD",    TERRITORY_SSD},
        {"STA",    TERRITORY_RU_STA},
        {"STP",    TERRITORY_STP},
        {"SUR",    TERRITORY_SUR},
        {"SVE",    TERRITORY_RU_SVE},
        {"SVK",    TERRITORY_SVK},
        {"SVN",    TERRITORY_SVN},
        {"SWE",    TERRITORY_SWE},
        {"SWZ",    TERRITORY_SWZ},
        {"SX",     TERRITORY_CN_SX},
        {"SXM",    TERRITORY_SXM},
        {"SYC",    TERRITORY_SYC},
        {"SYR",    TERRITORY_SYR},
        {"TA",     TERRITORY_RU_TA},
        {"TAA",    TERRITORY_SHN},
        {"TAB",    TERRITORY_MX_TAB},
        {"TAM",    TERRITORY_MX_TAM},
        {"TAS",    TERRITORY_AU_TAS},
        {"TB",     TERRITORY_MX_TAB},
        {"TCA",    TERRITORY_TCA},
        {"TCD",    TERRITORY_TCD},
        {"TG",     TERRITORY_IN_TG},
        {"TGO",    TERRITORY_TGO},
        {"THA",    TERRITORY_THA},
        {"TJ",     TERRITORY_CN_TJ},
        {"TJK",    TERRITORY_TJK},
        {"TKL",    TERRITORY_TKL},
        {"TKM",    TERRITORY_TKM},
        {"TL",     TERRITORY_MX_TLA},
        {"TLA",    TERRITORY_MX_TLA},
        {"TLS",    TERRITORY_TLS},
        {"TM",     TERRITORY_MX_TAM},
        {"TN",     TERRITORY_IN_TN},
        {"TO",     TERRITORY_BR_TO},
        {"TOM",    TERRITORY_RU_TOM},
        {"TON",    TERRITORY_TON},
        {"TR",     TERRITORY_IN_TR},
        {"TT",     TERRITORY_RU_TT},
        {"TTO",    TERRITORY_TTO},
        {"TUL",    TERRITORY_RU_TUL},
        {"TUN",    TERRITORY_TUN},
        {"TUR",    TERRITORY_TUR},
        {"TUV",    TERRITORY_TUV},
        {"TVE",    TERRITORY_RU_TVE},
        {"TW",     TERRITORY_TWN},
        {"TWN",    TERRITORY_TWN},
        {"TX",     TERRITORY_US_TX},
        {"TY",     TERRITORY_RU_TY},
        {"TYU",    TERRITORY_RU_TYU},
        {"TZA",    TERRITORY_TZA},
        {"UD",     TERRITORY_RU_UD},
        {"UGA",    TERRITORY_UGA},
        {"UK",     TERRITORY_IN_UT},
        {"UKR",    TERRITORY_UKR},
        {"ULY",    TERRITORY_RU_ULY},
        {"UM",     TERRITORY_UMI},
        {"UMI",    TERRITORY_UMI},
        {"UP",     TERRITORY_IN_UP},
        {"URY",    TERRITORY_URY},
        {"US",     TERRITORY_USA},
        {"US-AK",  TERRITORY_US_AK},
        {"US-AL",  TERRITORY_US_AL},
        {"US-AR",  TERRITORY_US_AR},
        {"US-AS",  TERRITORY_ASM},
        {"US-AZ",  TERRITORY_US_AZ},
        {"US-CA",  TERRITORY_US_CA},
        {"US-CO",  TERRITORY_US_CO},
        {"US-CT",  TERRITORY_US_CT},
        {"US-DC",  TERRITORY_US_DC},
        {"US-DE",  TERRITORY_US_DE},
        {"US-FL",  TERRITORY_US_FL},
        {"US-GA",  TERRITORY_US_GA},
        {"US-GU",  TERRITORY_GUM},
        {"US-HI",  TERRITORY_US_HI},
        {"US-IA",  TERRITORY_US_IA},
        {"US-ID",  TERRITORY_US_ID},
        {"US-IL",  TERRITORY_US_IL},
        {"US-IN",  TERRITORY_US_IN},
        {"US-KS",  TERRITORY_US_KS},
        {"US-KY",  TERRITORY_US_KY},
        {"US-LA",  TERRITORY_US_LA},
        {"US-MA",  TERRITORY_US_MA},
        {"US-MD",  TERRITORY_US_MD},
        {"US-ME",  TERRITORY_US_ME},
        {"US-MI",  TERRITORY_US_MI},
        {"US-MID", TERRITORY_US_HI},
        {"US-MN",  TERRITORY_US_MN},
        {"US-MO",  TERRITORY_US_MO},
        {"US-MP",  TERRITORY_MNP},
        {"US-MS",  TERRITORY_US_MS},
        {"US-MT",  TERRITORY_US_MT},
        {"US-NC",  TERRITORY_US_NC},
        {"US-ND",  TERRITORY_US_ND},
        {"US-NE",  TERRITORY_US_NE},
        {"US-NH",  TERRITORY_US_NH},
        {"US-NJ",  TERRITORY_US_NJ},
        {"US-NM",  TERRITORY_US_NM},
        {"US-NV",  TERRITORY_US_NV},
        {"US-NY",  TERRITORY_US_NY},
        {"US-OH",  TERRITORY_US_OH},
        {"US-OK",  TERRITORY_US_OK},
        {"US-OR",  TERRITORY_US_OR},
        {"US-PA",  TERRITORY_US_PA},
        {"US-PR",  TERRITORY_PRI},
        {"US-RI",  TERRITORY_US_RI},
        {"US-SC",  TERRITORY_US_SC},
        {"US-SD",  TERRITORY_US_SD},
        {"US-TN",  TERRITORY_US_TN},
        {"US-TX",  TERRITORY_US_TX},
        {"US-UM",  TERRITORY_UMI},
        {"US-UT",  TERRITORY_US_UT},
        {"US-VA",  TERRITORY_US_VA},
        {"US-VI",  TERRITORY_VIR},
        {"US-VT",  TERRITORY_US_VT},
        {"US-WA",  TERRITORY_US_WA},
        {"US-WI",  TERRITORY_US_WI},
        {"US-WV",  TERRITORY_US_WV},
        {"US-WY",  TERRITORY_US_WY},
        {"USA",    TERRITORY_USA},
        {"UT",     TERRITORY_IN_UT},
        {"UZB",    TERRITORY_UZB},
        {"VA",     TERRITORY_US_VA},
        {"VAT",    TERRITORY_VAT},
        {"VCT",    TERRITORY_VCT},
        {"VE",     TERRITORY_MX_VER},
        {"VEN",    TERRITORY_VEN},
        {"VER",    TERRITORY_MX_VER},
        {"VGB",    TERRITORY_VGB},
        {"VGG",    TERRITORY_RU_VGG},
        {"VI",     TERRITORY_VIR},
        {"VIC",    TERRITORY_AU_VIC},
        {"VIR",    TERRITORY_VIR},
        {"VLA",    TERRITORY_RU_VLA},
        {"VLG",    TERRITORY_RU_VLG},
        {"VNM",    TERRITORY_VNM},
        {"VOR",    TERRITORY_RU_VOR},
        {"VT",     TERRITORY_US_VT},
        {"VUT",    TERRITORY_VUT},
        {"WA",     TERRITORY_AU_WA},
        {"WAK",    TERRITORY_MHL},
        {"WB",     TERRITORY_IN_WB},
        {"WI",     TERRITORY_US_WI},
        {"WLF",    TERRITORY_WLF},
        {"WSM",    TERRITORY_WSM},
        {"WV",     TERRITORY_US_WV},
        {"WY",     TERRITORY_US_WY},
        {"XJ",     TERRITORY_CN_XJ},
        {"XZ",     TERRITORY_CN_XZ},
        {"YAN",    TERRITORY_RU_YAN},
        {"YAR",    TERRITORY_RU_YAR},
        {"YEM",    TERRITORY_YEM},
        {"YEV",    TERRITORY_RU_YEV},
        {"YN",     TERRITORY_CN_YN},
        {"YT",     TERRITORY_CA_YT},
        {"YU",     TERRITORY_MX_YUC},
        {"YUC",    TERRITORY_MX_YUC},
        {"ZA",     TERRITORY_MX_ZAC},
        {"ZAB",    TERRITORY_RU_ZAB},
        {"ZAC",    TERRITORY_MX_ZAC},
        {"ZAF",    TERRITORY_ZAF},
        {"ZJ",     TERRITORY_CN_ZJ},
        {"ZMB",    TERRITORY_ZMB},
        {"ZWE",    TERRITORY_ZWE}
};

// produced by dividemaps.cpp : fast_territories.cpp
#ifdef __cplusplus
}
#endif

#endif // __INTERNAL_ISO3166_DATA_H__
