*
* $Id: fxvhar.F,v 1.1.1.3 1996/11/15 17:32:49 cernlib Exp $
*
* $Log: fxvhar.F,v $
* Revision 1.1.1.3  1996/11/15 17:32:49  cernlib
* Import version 7.06
*
* Revision 1.2  1996/11/15 15:07:15  pdflib
* Version 7.06: tabs removed and bug fixed in grsgalo
*
* Revision 1.1.1.1  1996/04/12 15:29:20  plothow
* Version 7.01
*
*
#include "pdf/pilot.h"
C
C------------------------------------------------------------
C------------- Subroutine to compute a point in x and q**2 --
C------------- for the following parton distributions :    --
C------------- UP Valence, DOWN Valence , GLUON , QBAR ,   --
C------------- UBAR , Strange , Charm , Bottom , Top .     --
C------------- Range of validity :                         --
C-------------                     5.E-05 < x < .95        --
C-------------                     1      <Log10 Q**2 < 8  --
C------------------------------------------------------------
C-------------        Authors :    M. Diemoz
C-------------                     F. Ferroni
C-------------                     E. Longo
C-------------                     G. Martinelli
C------------------------------------------------------------
      SUBROUTINE  FXVHAR(X,QSTAR2,STRFUN,FUNC)
C------------------------------------------------------------
C-------------   X is x and QSTAR2 is Q square  -------------
      CHARACTER*(*) STRFUN
C------------------------------------------------------------
C------------ STRFUN specifies the desired function----------
C------------------------------------------------------------
C------------------------------------------------------------
C        IFUN =  1     UP valence      'UPVAL'
C                2     DOWN valence    'DOVAL'
C                3     Gluon           'GLUON'
C                4     Q bar           'QBAR '
C                5     UP bar          'UBAR '
C                6     Strange         'SBAR '
C                7     Charm           'CBAR '
C                8     Bottom          'BBAR '
C                9     Top             'TBAR '
C------------------------------------------------------------
C-------------  FUNC is the output (parton density value)----
C------------------------------------------------------------
      PARAMETER (IX=104,IQ=9,NARG=2,KFUN=9)
C------------------------------------------------------------
C-----------Input tables are given as 104 x points at 9 Q**2
C-----------positions (log spaced in Q**2 and x up to .6
C-----------(90 points). The remaining 14 x points are ------
C----------linearly spaced)----------------------------------
C------------------------------------------------------------
      DIMENSION ARG(NARG),NENT(NARG),ENT(IX+IQ)
      DIMENSION XQDUM(IX,IQ,KFUN)
      DIMENSION Q2(IQ),XCO(IX)
C------------------------------------------------------------
C----------- Next the 9 Q**2 of the input tables are defined
C------------------------------------------------------------
      DATA Q2 /10.,30.,100.,1000.,10000.,100000.,1000000,
     +         10000000.,100000000./
C----------------------------------------------------------------
C----------- And now the 104 x positions ------------------------
C----------------------------------------------------------------
      DATA XCO   /
     +0.5000E-04,0.5545E-04,0.6150E-04,0.6820E-04,0.7564E-04,0.8389E-04,
     +0.9303E-04,0.1032E-03,0.1144E-03,0.1269E-03,0.1407E-03,0.1561E-03,
     +0.1731E-03,0.1920E-03,0.2129E-03,0.2361E-03,0.2619E-03,0.2904E-03,
     +0.3221E-03,0.3572E-03,0.3961E-03,0.4393E-03,0.4872E-03,0.5404E-03,
     +0.5993E-03,0.6646E-03,0.7371E-03,0.8174E-03,0.9066E-03,0.1005E-02,
     +0.1115E-02,0.1237E-02,0.1371E-02,0.1521E-02,0.1687E-02,0.1871E-02,
     +0.2075E-02,0.2301E-02,0.2552E-02,0.2830E-02,0.3139E-02,0.3481E-02,
     +0.3860E-02,0.4281E-02,0.4748E-02,0.5266E-02,0.5840E-02,0.6476E-02,
     +0.7182E-02,0.7966E-02,0.8834E-02,0.9797E-02,0.1087E-01,0.1205E-01,
     +0.1336E-01,0.1482E-01,0.1644E-01,0.1823E-01,0.2022E-01,0.2242E-01,
     +0.2487E-01,0.2758E-01,0.3058E-01,0.3392E-01,0.3762E-01,0.4172E-01,
     +0.4627E-01,0.5131E-01,0.5690E-01,0.6311E-01,0.6999E-01,0.7762E-01,
     +0.8608E-01,0.9547E-01,0.1059E+00,0.1174E+00,0.1302E+00,0.1444E+00,
     +0.1602E+00,0.1776E+00,0.1970E+00,0.2185E+00,0.2423E+00,0.2687E+00,
     +0.2980E+00,0.3305E+00,0.3666E+00,0.4065E+00,0.4508E+00,0.5000E+00,
     +0.5321E+00,0.5643E+00,0.5964E+00,0.6286E+00,0.6607E+00,0.6929E+00,
     +0.7250E+00,0.7571E+00,0.7893E+00,0.8214E+00,0.8536E+00,0.8857E+00,
     +0.9179E+00,0.9500E+00/
      DATA (XQDUM (I,1,1),I=1,104) /
     +0.2361E-01,0.2455E-01,0.2554E-01,0.2656E-01,0.2763E-01,0.2874E-01,
     +0.2989E-01,0.3109E-01,0.3234E-01,0.3364E-01,0.3499E-01,0.3639E-01,
     +0.3785E-01,0.3937E-01,0.4095E-01,0.4259E-01,0.4430E-01,0.4608E-01,
     +0.4793E-01,0.4986E-01,0.5186E-01,0.5395E-01,0.5611E-01,0.5837E-01,
     +0.6072E-01,0.6316E-01,0.6570E-01,0.6834E-01,0.7109E-01,0.7395E-01,
     +0.7693E-01,0.8003E-01,0.8326E-01,0.8662E-01,0.9011E-01,0.9375E-01,
     +0.9754E-01,0.1015E+00,0.1056E+00,0.1099E+00,0.1143E+00,0.1190E+00,
     +0.1238E+00,0.1289E+00,0.1341E+00,0.1396E+00,0.1453E+00,0.1513E+00,
     +0.1575E+00,0.1640E+00,0.1707E+00,0.1778E+00,0.1852E+00,0.1929E+00,
     +0.2010E+00,0.2094E+00,0.2182E+00,0.2274E+00,0.2370E+00,0.2470E+00,
     +0.2575E+00,0.2685E+00,0.2800E+00,0.2920E+00,0.3045E+00,0.3175E+00,
     +0.3311E+00,0.3451E+00,0.3597E+00,0.3747E+00,0.3901E+00,0.4058E+00,
     +0.4217E+00,0.4376E+00,0.4533E+00,0.4685E+00,0.4830E+00,0.4961E+00,
     +0.5075E+00,0.5165E+00,0.5222E+00,0.5240E+00,0.5207E+00,0.5114E+00,
     +0.4951E+00,0.4708E+00,0.4378E+00,0.3959E+00,0.3453E+00,0.2872E+00,
     +0.2497E+00,0.2134E+00,0.1789E+00,0.1469E+00,0.1177E+00,0.9176E-01,
     +0.6917E-01,0.5006E-01,0.3444E-01,0.2217E-01,0.1304E-01,0.6726E-02,
     +0.2806E-02,0.7765E-03/
      DATA (XQDUM (I,1,2),I=1,104) /
     +0.1355E-01,0.1409E-01,0.1466E-01,0.1525E-01,0.1586E-01,0.1649E-01,
     +0.1716E-01,0.1784E-01,0.1856E-01,0.1930E-01,0.2008E-01,0.2088E-01,
     +0.2172E-01,0.2259E-01,0.2350E-01,0.2444E-01,0.2542E-01,0.2644E-01,
     +0.2751E-01,0.2861E-01,0.2976E-01,0.3095E-01,0.3219E-01,0.3349E-01,
     +0.3483E-01,0.3623E-01,0.3768E-01,0.3920E-01,0.4077E-01,0.4241E-01,
     +0.4411E-01,0.4588E-01,0.4772E-01,0.4964E-01,0.5164E-01,0.5371E-01,
     +0.5587E-01,0.5812E-01,0.6046E-01,0.6289E-01,0.6542E-01,0.6806E-01,
     +0.7080E-01,0.7365E-01,0.7662E-01,0.7971E-01,0.8292E-01,0.8627E-01,
     +0.8975E-01,0.9337E-01,0.9714E-01,0.1011E+00,0.1051E+00,0.1094E+00,
     +0.1138E+00,0.1184E+00,0.1232E+00,0.1281E+00,0.1333E+00,0.1386E+00,
     +0.1442E+00,0.1499E+00,0.1558E+00,0.1619E+00,0.1682E+00,0.1747E+00,
     +0.1812E+00,0.1879E+00,0.1947E+00,0.2015E+00,0.2082E+00,0.2148E+00,
     +0.2212E+00,0.2272E+00,0.2326E+00,0.2374E+00,0.2411E+00,0.2437E+00,
     +0.2447E+00,0.2438E+00,0.2407E+00,0.2350E+00,0.2265E+00,0.2147E+00,
     +0.1995E+00,0.1809E+00,0.1592E+00,0.1349E+00,0.1088E+00,0.8244E-01,
     +0.6706E-01,0.5337E-01,0.4145E-01,0.3132E-01,0.2293E-01,0.1618E-01,
     +0.1092E-01,0.6979E-02,0.4165E-02,0.2273E-02,0.1096E-02,0.4412E-03,
     +0.1323E-03,0.2229E-04/
      DATA (XQDUM (I,1,3),I=1,104) /
     +0.7804E+01,0.7693E+01,0.7584E+01,0.7477E+01,0.7371E+01,0.7267E+01,
     +0.7165E+01,0.7064E+01,0.6966E+01,0.6869E+01,0.6773E+01,0.6680E+01,
     +0.6588E+01,0.6498E+01,0.6410E+01,0.6323E+01,0.6238E+01,0.6154E+01,
     +0.6073E+01,0.5993E+01,0.5915E+01,0.5838E+01,0.5763E+01,0.5690E+01,
     +0.5618E+01,0.5549E+01,0.5481E+01,0.5414E+01,0.5350E+01,0.5287E+01,
     +0.5226E+01,0.5166E+01,0.5108E+01,0.5052E+01,0.4997E+01,0.4944E+01,
     +0.4893E+01,0.4843E+01,0.4794E+01,0.4747E+01,0.4701E+01,0.4656E+01,
     +0.4612E+01,0.4569E+01,0.4526E+01,0.4484E+01,0.4443E+01,0.4401E+01,
     +0.4360E+01,0.4317E+01,0.4274E+01,0.4230E+01,0.4184E+01,0.4136E+01,
     +0.4085E+01,0.4032E+01,0.3975E+01,0.3914E+01,0.3848E+01,0.3778E+01,
     +0.3702E+01,0.3619E+01,0.3530E+01,0.3434E+01,0.3330E+01,0.3218E+01,
     +0.3098E+01,0.2970E+01,0.2833E+01,0.2688E+01,0.2536E+01,0.2376E+01,
     +0.2210E+01,0.2038E+01,0.1863E+01,0.1685E+01,0.1506E+01,0.1329E+01,
     +0.1155E+01,0.9871E+00,0.8276E+00,0.6786E+00,0.5424E+00,0.4207E+00,
     +0.3151E+00,0.2262E+00,0.1544E+00,0.9896E-01,0.5864E-01,0.3139E-01,
     +0.2024E-01,0.1269E-01,0.7695E-02,0.4490E-02,0.2502E-02,0.1318E-02,
     +0.6487E-03,0.2929E-03,0.1183E-03,0.4116E-04,0.1161E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,1,4),I=1,104) /
     +0.6995E+00,0.6995E+00,0.6994E+00,0.6994E+00,0.6992E+00,0.6993E+00,
     +0.6991E+00,0.6991E+00,0.6989E+00,0.6989E+00,0.6987E+00,0.6986E+00,
     +0.6985E+00,0.6983E+00,0.6981E+00,0.6979E+00,0.6976E+00,0.6974E+00,
     +0.6971E+00,0.6968E+00,0.6965E+00,0.6961E+00,0.6957E+00,0.6952E+00,
     +0.6947E+00,0.6941E+00,0.6935E+00,0.6928E+00,0.6920E+00,0.6911E+00,
     +0.6902E+00,0.6891E+00,0.6879E+00,0.6866E+00,0.6852E+00,0.6836E+00,
     +0.6818E+00,0.6799E+00,0.6777E+00,0.6754E+00,0.6727E+00,0.6698E+00,
     +0.6666E+00,0.6631E+00,0.6592E+00,0.6549E+00,0.6502E+00,0.6450E+00,
     +0.6393E+00,0.6331E+00,0.6262E+00,0.6187E+00,0.6105E+00,0.6015E+00,
     +0.5917E+00,0.5811E+00,0.5695E+00,0.5570E+00,0.5435E+00,0.5290E+00,
     +0.5133E+00,0.4966E+00,0.4788E+00,0.4599E+00,0.4400E+00,0.4190E+00,
     +0.3971E+00,0.3744E+00,0.3510E+00,0.3271E+00,0.3028E+00,0.2785E+00,
     +0.2543E+00,0.2305E+00,0.2073E+00,0.1850E+00,0.1638E+00,0.1438E+00,
     +0.1252E+00,0.1079E+00,0.9189E-01,0.7717E-01,0.6363E-01,0.5119E-01,
     +0.3985E-01,0.2967E-01,0.2082E-01,0.1351E-01,0.7892E-02,0.4007E-02,
     +0.2439E-02,0.1414E-02,0.7767E-03,0.4008E-03,0.1924E-03,0.8480E-04,
     +0.3373E-04,0.1182E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,1,5),I=1,104) /
     +0.2915E+00,0.2915E+00,0.2914E+00,0.2914E+00,0.2914E+00,0.2914E+00,
     +0.2913E+00,0.2913E+00,0.2912E+00,0.2912E+00,0.2911E+00,0.2911E+00,
     +0.2910E+00,0.2909E+00,0.2909E+00,0.2908E+00,0.2907E+00,0.2906E+00,
     +0.2905E+00,0.2903E+00,0.2902E+00,0.2900E+00,0.2899E+00,0.2897E+00,
     +0.2895E+00,0.2892E+00,0.2889E+00,0.2887E+00,0.2883E+00,0.2880E+00,
     +0.2876E+00,0.2871E+00,0.2866E+00,0.2861E+00,0.2855E+00,0.2848E+00,
     +0.2841E+00,0.2833E+00,0.2824E+00,0.2814E+00,0.2803E+00,0.2791E+00,
     +0.2778E+00,0.2763E+00,0.2747E+00,0.2729E+00,0.2709E+00,0.2688E+00,
     +0.2664E+00,0.2638E+00,0.2609E+00,0.2578E+00,0.2544E+00,0.2506E+00,
     +0.2465E+00,0.2421E+00,0.2373E+00,0.2321E+00,0.2265E+00,0.2204E+00,
     +0.2139E+00,0.2069E+00,0.1995E+00,0.1916E+00,0.1833E+00,0.1746E+00,
     +0.1655E+00,0.1560E+00,0.1462E+00,0.1363E+00,0.1262E+00,0.1160E+00,
     +0.1060E+00,0.9604E-01,0.8639E-01,0.7710E-01,0.6826E-01,0.5993E-01,
     +0.5215E-01,0.4494E-01,0.3829E-01,0.3216E-01,0.2651E-01,0.2133E-01,
     +0.1660E-01,0.1236E-01,0.8676E-02,0.5628E-02,0.3288E-02,0.1670E-02,
     +0.1016E-02,0.5893E-03,0.3236E-03,0.1670E-03,0.8016E-04,0.3533E-04,
     +0.1405E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,1,6),I=1,104) /
     +0.1166E+00,0.1166E+00,0.1166E+00,0.1166E+00,0.1165E+00,0.1165E+00,
     +0.1165E+00,0.1165E+00,0.1165E+00,0.1165E+00,0.1165E+00,0.1164E+00,
     +0.1164E+00,0.1164E+00,0.1164E+00,0.1163E+00,0.1163E+00,0.1162E+00,
     +0.1162E+00,0.1161E+00,0.1161E+00,0.1160E+00,0.1159E+00,0.1159E+00,
     +0.1158E+00,0.1157E+00,0.1156E+00,0.1155E+00,0.1153E+00,0.1152E+00,
     +0.1150E+00,0.1149E+00,0.1147E+00,0.1144E+00,0.1142E+00,0.1139E+00,
     +0.1136E+00,0.1133E+00,0.1130E+00,0.1126E+00,0.1121E+00,0.1116E+00,
     +0.1111E+00,0.1105E+00,0.1099E+00,0.1092E+00,0.1084E+00,0.1075E+00,
     +0.1066E+00,0.1055E+00,0.1044E+00,0.1031E+00,0.1017E+00,0.1002E+00,
     +0.9862E-01,0.9685E-01,0.9492E-01,0.9284E-01,0.9059E-01,0.8816E-01,
     +0.8556E-01,0.8277E-01,0.7980E-01,0.7665E-01,0.7333E-01,0.6983E-01,
     +0.6618E-01,0.6240E-01,0.5850E-01,0.5451E-01,0.5047E-01,0.4642E-01,
     +0.4238E-01,0.3842E-01,0.3456E-01,0.3084E-01,0.2730E-01,0.2397E-01,
     +0.2086E-01,0.1798E-01,0.1531E-01,0.1286E-01,0.1061E-01,0.8532E-02,
     +0.6641E-02,0.4945E-02,0.3470E-02,0.2251E-02,0.1315E-02,0.6679E-03,
     +0.4064E-03,0.2357E-03,0.1294E-03,0.6679E-04,0.3207E-04,0.1413E-04,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,1,7),I=1,104) /
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,1,8),I=1,104) /
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,1,9),I=1,104) /
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,1),I=1,104) /
     +0.2509E-01,0.2610E-01,0.2715E-01,0.2823E-01,0.2937E-01,0.3054E-01,
     +0.3177E-01,0.3304E-01,0.3437E-01,0.3574E-01,0.3718E-01,0.3867E-01,
     +0.4022E-01,0.4183E-01,0.4351E-01,0.4525E-01,0.4707E-01,0.4896E-01,
     +0.5092E-01,0.5296E-01,0.5508E-01,0.5729E-01,0.5959E-01,0.6198E-01,
     +0.6447E-01,0.6706E-01,0.6975E-01,0.7254E-01,0.7546E-01,0.7848E-01,
     +0.8164E-01,0.8491E-01,0.8833E-01,0.9187E-01,0.9557E-01,0.9941E-01,
     +0.1034E+00,0.1076E+00,0.1119E+00,0.1164E+00,0.1211E+00,0.1260E+00,
     +0.1311E+00,0.1364E+00,0.1419E+00,0.1476E+00,0.1536E+00,0.1598E+00,
     +0.1663E+00,0.1731E+00,0.1801E+00,0.1874E+00,0.1951E+00,0.2031E+00,
     +0.2114E+00,0.2200E+00,0.2290E+00,0.2384E+00,0.2482E+00,0.2584E+00,
     +0.2691E+00,0.2801E+00,0.2916E+00,0.3035E+00,0.3159E+00,0.3286E+00,
     +0.3418E+00,0.3554E+00,0.3693E+00,0.3835E+00,0.3979E+00,0.4124E+00,
     +0.4267E+00,0.4408E+00,0.4544E+00,0.4672E+00,0.4788E+00,0.4888E+00,
     +0.4965E+00,0.5016E+00,0.5031E+00,0.5004E+00,0.4926E+00,0.4788E+00,
     +0.4584E+00,0.4306E+00,0.3952E+00,0.3521E+00,0.3021E+00,0.2467E+00,
     +0.2118E+00,0.1788E+00,0.1480E+00,0.1199E+00,0.9471E-01,0.7271E-01,
     +0.5394E-01,0.3837E-01,0.2589E-01,0.1632E-01,0.9361E-02,0.4685E-02,
     +0.1881E-02,0.4920E-03/
      DATA (XQDUM (I,2,2),I=1,104) /
     +0.1440E-01,0.1498E-01,0.1558E-01,0.1620E-01,0.1685E-01,0.1752E-01,
     +0.1823E-01,0.1896E-01,0.1972E-01,0.2051E-01,0.2133E-01,0.2218E-01,
     +0.2307E-01,0.2399E-01,0.2495E-01,0.2595E-01,0.2699E-01,0.2807E-01,
     +0.2919E-01,0.3036E-01,0.3158E-01,0.3284E-01,0.3415E-01,0.3552E-01,
     +0.3694E-01,0.3842E-01,0.3995E-01,0.4155E-01,0.4321E-01,0.4494E-01,
     +0.4673E-01,0.4860E-01,0.5054E-01,0.5255E-01,0.5465E-01,0.5683E-01,
     +0.5909E-01,0.6145E-01,0.6390E-01,0.6644E-01,0.6909E-01,0.7184E-01,
     +0.7469E-01,0.7766E-01,0.8075E-01,0.8396E-01,0.8729E-01,0.9075E-01,
     +0.9434E-01,0.9807E-01,0.1019E+00,0.1060E+00,0.1101E+00,0.1145E+00,
     +0.1190E+00,0.1236E+00,0.1284E+00,0.1334E+00,0.1385E+00,0.1438E+00,
     +0.1493E+00,0.1550E+00,0.1607E+00,0.1667E+00,0.1727E+00,0.1788E+00,
     +0.1851E+00,0.1913E+00,0.1975E+00,0.2036E+00,0.2096E+00,0.2153E+00,
     +0.2207E+00,0.2255E+00,0.2296E+00,0.2329E+00,0.2351E+00,0.2359E+00,
     +0.2351E+00,0.2324E+00,0.2275E+00,0.2201E+00,0.2099E+00,0.1968E+00,
     +0.1808E+00,0.1619E+00,0.1404E+00,0.1172E+00,0.9296E-01,0.6908E-01,
     +0.5548E-01,0.4358E-01,0.3340E-01,0.2489E-01,0.1796E-01,0.1248E-01,
     +0.8284E-02,0.5202E-02,0.3045E-02,0.1625E-02,0.7642E-03,0.2983E-03,
     +0.8599E-04,0.1369E-04/
      DATA (XQDUM (I,2,3),I=1,104) /
     +0.1961E+02,0.1919E+02,0.1878E+02,0.1838E+02,0.1798E+02,0.1759E+02,
     +0.1721E+02,0.1684E+02,0.1647E+02,0.1610E+02,0.1575E+02,0.1540E+02,
     +0.1506E+02,0.1472E+02,0.1439E+02,0.1406E+02,0.1374E+02,0.1343E+02,
     +0.1312E+02,0.1282E+02,0.1253E+02,0.1224E+02,0.1195E+02,0.1167E+02,
     +0.1140E+02,0.1113E+02,0.1087E+02,0.1061E+02,0.1036E+02,0.1011E+02,
     +0.9867E+01,0.9629E+01,0.9396E+01,0.9167E+01,0.8944E+01,0.8724E+01,
     +0.8510E+01,0.8299E+01,0.8093E+01,0.7892E+01,0.7694E+01,0.7500E+01,
     +0.7309E+01,0.7123E+01,0.6939E+01,0.6759E+01,0.6582E+01,0.6407E+01,
     +0.6235E+01,0.6065E+01,0.5897E+01,0.5731E+01,0.5565E+01,0.5401E+01,
     +0.5237E+01,0.5074E+01,0.4910E+01,0.4745E+01,0.4580E+01,0.4413E+01,
     +0.4244E+01,0.4074E+01,0.3901E+01,0.3726E+01,0.3548E+01,0.3367E+01,
     +0.3184E+01,0.2997E+01,0.2809E+01,0.2618E+01,0.2426E+01,0.2234E+01,
     +0.2041E+01,0.1850E+01,0.1661E+01,0.1476E+01,0.1297E+01,0.1124E+01,
     +0.9598E+00,0.8058E+00,0.6635E+00,0.5343E+00,0.4194E+00,0.3195E+00,
     +0.2350E+00,0.1659E+00,0.1114E+00,0.7037E-01,0.4125E-01,0.2200E-01,
     +0.1423E-01,0.9004E-02,0.5555E-02,0.3331E-02,0.1933E-02,0.1081E-02,
     +0.5785E-03,0.2943E-03,0.1407E-03,0.6216E-04,0.2467E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,4),I=1,104) /
     +0.1409E+01,0.1396E+01,0.1383E+01,0.1369E+01,0.1357E+01,0.1344E+01,
     +0.1331E+01,0.1319E+01,0.1307E+01,0.1295E+01,0.1283E+01,0.1272E+01,
     +0.1261E+01,0.1249E+01,0.1238E+01,0.1228E+01,0.1217E+01,0.1206E+01,
     +0.1196E+01,0.1186E+01,0.1176E+01,0.1166E+01,0.1156E+01,0.1146E+01,
     +0.1136E+01,0.1127E+01,0.1117E+01,0.1107E+01,0.1098E+01,0.1088E+01,
     +0.1079E+01,0.1070E+01,0.1060E+01,0.1051E+01,0.1041E+01,0.1031E+01,
     +0.1021E+01,0.1011E+01,0.1001E+01,0.9907E+00,0.9801E+00,0.9691E+00,
     +0.9579E+00,0.9463E+00,0.9343E+00,0.9218E+00,0.9089E+00,0.8954E+00,
     +0.8813E+00,0.8666E+00,0.8512E+00,0.8350E+00,0.8181E+00,0.8002E+00,
     +0.7815E+00,0.7619E+00,0.7412E+00,0.7196E+00,0.6969E+00,0.6731E+00,
     +0.6482E+00,0.6223E+00,0.5953E+00,0.5673E+00,0.5384E+00,0.5086E+00,
     +0.4782E+00,0.4472E+00,0.4157E+00,0.3842E+00,0.3527E+00,0.3215E+00,
     +0.2909E+00,0.2611E+00,0.2325E+00,0.2052E+00,0.1796E+00,0.1556E+00,
     +0.1335E+00,0.1132E+00,0.9472E-01,0.7802E-01,0.6298E-01,0.4953E-01,
     +0.3765E-01,0.2735E-01,0.1872E-01,0.1184E-01,0.6740E-02,0.3335E-02,
     +0.1998E-02,0.1142E-02,0.6190E-03,0.3156E-03,0.1499E-03,0.6556E-04,
     +0.2599E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,5),I=1,104) /
     +0.4515E+00,0.4485E+00,0.4455E+00,0.4426E+00,0.4397E+00,0.4369E+00,
     +0.4340E+00,0.4313E+00,0.4285E+00,0.4259E+00,0.4232E+00,0.4206E+00,
     +0.4181E+00,0.4155E+00,0.4130E+00,0.4106E+00,0.4081E+00,0.4057E+00,
     +0.4033E+00,0.4009E+00,0.3986E+00,0.3962E+00,0.3939E+00,0.3916E+00,
     +0.3893E+00,0.3870E+00,0.3847E+00,0.3824E+00,0.3801E+00,0.3778E+00,
     +0.3754E+00,0.3731E+00,0.3707E+00,0.3682E+00,0.3657E+00,0.3632E+00,
     +0.3605E+00,0.3578E+00,0.3551E+00,0.3522E+00,0.3492E+00,0.3461E+00,
     +0.3428E+00,0.3394E+00,0.3359E+00,0.3321E+00,0.3282E+00,0.3240E+00,
     +0.3196E+00,0.3149E+00,0.3100E+00,0.3047E+00,0.2992E+00,0.2933E+00,
     +0.2870E+00,0.2803E+00,0.2733E+00,0.2658E+00,0.2580E+00,0.2496E+00,
     +0.2409E+00,0.2317E+00,0.2221E+00,0.2120E+00,0.2016E+00,0.1908E+00,
     +0.1797E+00,0.1684E+00,0.1569E+00,0.1452E+00,0.1336E+00,0.1220E+00,
     +0.1106E+00,0.9954E-01,0.8885E-01,0.7866E-01,0.6903E-01,0.6003E-01,
     +0.5169E-01,0.4402E-01,0.3702E-01,0.3064E-01,0.2486E-01,0.1965E-01,
     +0.1501E-01,0.1096E-01,0.7528E-02,0.4777E-02,0.2727E-02,0.1352E-02,
     +0.8103E-03,0.4631E-03,0.2508E-03,0.1277E-03,0.6050E-04,0.2635E-04,
     +0.1038E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,6),I=1,104) /
     +0.2767E+00,0.2737E+00,0.2707E+00,0.2678E+00,0.2649E+00,0.2621E+00,
     +0.2593E+00,0.2566E+00,0.2539E+00,0.2513E+00,0.2487E+00,0.2461E+00,
     +0.2436E+00,0.2411E+00,0.2387E+00,0.2363E+00,0.2339E+00,0.2316E+00,
     +0.2293E+00,0.2270E+00,0.2248E+00,0.2226E+00,0.2204E+00,0.2182E+00,
     +0.2161E+00,0.2140E+00,0.2119E+00,0.2098E+00,0.2078E+00,0.2057E+00,
     +0.2037E+00,0.2016E+00,0.1996E+00,0.1975E+00,0.1955E+00,0.1934E+00,
     +0.1913E+00,0.1892E+00,0.1871E+00,0.1849E+00,0.1827E+00,0.1804E+00,
     +0.1781E+00,0.1758E+00,0.1733E+00,0.1708E+00,0.1682E+00,0.1655E+00,
     +0.1627E+00,0.1598E+00,0.1568E+00,0.1536E+00,0.1503E+00,0.1468E+00,
     +0.1432E+00,0.1395E+00,0.1355E+00,0.1314E+00,0.1271E+00,0.1226E+00,
     +0.1179E+00,0.1131E+00,0.1080E+00,0.1028E+00,0.9747E-01,0.9198E-01,
     +0.8636E-01,0.8066E-01,0.7491E-01,0.6913E-01,0.6337E-01,0.5769E-01,
     +0.5212E-01,0.4671E-01,0.4152E-01,0.3658E-01,0.3193E-01,0.2760E-01,
     +0.2360E-01,0.1995E-01,0.1664E-01,0.1365E-01,0.1098E-01,0.8599E-02,
     +0.6510E-02,0.4712E-02,0.3214E-02,0.2027E-02,0.1152E-02,0.5690E-03,
     +0.3408E-03,0.1948E-03,0.1056E-03,0.5389E-04,0.2565E-04,0.1125E-04,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,7),I=1,104) /
     +0.1602E+00,0.1572E+00,0.1542E+00,0.1513E+00,0.1485E+00,0.1457E+00,
     +0.1429E+00,0.1402E+00,0.1375E+00,0.1349E+00,0.1323E+00,0.1298E+00,
     +0.1273E+00,0.1249E+00,0.1225E+00,0.1201E+00,0.1178E+00,0.1155E+00,
     +0.1133E+00,0.1111E+00,0.1089E+00,0.1068E+00,0.1047E+00,0.1027E+00,
     +0.1007E+00,0.9866E-01,0.9671E-01,0.9478E-01,0.9288E-01,0.9101E-01,
     +0.8916E-01,0.8734E-01,0.8554E-01,0.8376E-01,0.8200E-01,0.8025E-01,
     +0.7852E-01,0.7681E-01,0.7510E-01,0.7340E-01,0.7171E-01,0.7002E-01,
     +0.6834E-01,0.6665E-01,0.6496E-01,0.6326E-01,0.6156E-01,0.5984E-01,
     +0.5811E-01,0.5637E-01,0.5461E-01,0.5284E-01,0.5104E-01,0.4923E-01,
     +0.4739E-01,0.4553E-01,0.4366E-01,0.4176E-01,0.3984E-01,0.3790E-01,
     +0.3595E-01,0.3398E-01,0.3201E-01,0.3003E-01,0.2805E-01,0.2608E-01,
     +0.2412E-01,0.2218E-01,0.2027E-01,0.1840E-01,0.1658E-01,0.1481E-01,
     +0.1312E-01,0.1150E-01,0.9963E-02,0.8528E-02,0.7198E-02,0.5980E-02,
     +0.4882E-02,0.3906E-02,0.3055E-02,0.2328E-02,0.1721E-02,0.1228E-02,
     +0.8411E-03,0.5485E-03,0.3373E-03,0.1929E-03,0.1009E-03,0.4705E-04,
     +0.2772E-04,0.1589E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,8),I=1,104) /
     +0.6941E-01,0.6796E-01,0.6653E-01,0.6513E-01,0.6375E-01,0.6240E-01,
     +0.6107E-01,0.5976E-01,0.5847E-01,0.5722E-01,0.5597E-01,0.5476E-01,
     +0.5356E-01,0.5239E-01,0.5124E-01,0.5010E-01,0.4900E-01,0.4790E-01,
     +0.4683E-01,0.4577E-01,0.4474E-01,0.4372E-01,0.4273E-01,0.4175E-01,
     +0.4078E-01,0.3983E-01,0.3890E-01,0.3799E-01,0.3709E-01,0.3620E-01,
     +0.3533E-01,0.3447E-01,0.3363E-01,0.3280E-01,0.3197E-01,0.3117E-01,
     +0.3037E-01,0.2958E-01,0.2880E-01,0.2802E-01,0.2726E-01,0.2650E-01,
     +0.2575E-01,0.2500E-01,0.2426E-01,0.2352E-01,0.2279E-01,0.2205E-01,
     +0.2132E-01,0.2059E-01,0.1986E-01,0.1913E-01,0.1840E-01,0.1767E-01,
     +0.1694E-01,0.1621E-01,0.1547E-01,0.1474E-01,0.1400E-01,0.1327E-01,
     +0.1253E-01,0.1180E-01,0.1107E-01,0.1035E-01,0.9627E-02,0.8917E-02,
     +0.8217E-02,0.7529E-02,0.6857E-02,0.6203E-02,0.5569E-02,0.4959E-02,
     +0.4376E-02,0.3823E-02,0.3303E-02,0.2818E-02,0.2371E-02,0.1964E-02,
     +0.1599E-02,0.1276E-02,0.9951E-03,0.7563E-03,0.5579E-03,0.3974E-03,
     +0.2718E-03,0.1772E-03,0.1090E-03,0.6245E-04,0.3281E-04,0.1543E-04,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,9),I=1,104) /
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,1),I=1,104) /
     +0.2655E-01,0.2762E-01,0.2872E-01,0.2987E-01,0.3107E-01,0.3232E-01,
     +0.3361E-01,0.3496E-01,0.3636E-01,0.3781E-01,0.3933E-01,0.4090E-01,
     +0.4254E-01,0.4424E-01,0.4601E-01,0.4786E-01,0.4977E-01,0.5176E-01,
     +0.5384E-01,0.5599E-01,0.5823E-01,0.6056E-01,0.6298E-01,0.6550E-01,
     +0.6812E-01,0.7085E-01,0.7368E-01,0.7663E-01,0.7969E-01,0.8288E-01,
     +0.8619E-01,0.8964E-01,0.9322E-01,0.9695E-01,0.1008E+00,0.1049E+00,
     +0.1090E+00,0.1134E+00,0.1179E+00,0.1227E+00,0.1276E+00,0.1327E+00,
     +0.1380E+00,0.1435E+00,0.1492E+00,0.1552E+00,0.1614E+00,0.1679E+00,
     +0.1746E+00,0.1816E+00,0.1888E+00,0.1964E+00,0.2042E+00,0.2124E+00,
     +0.2209E+00,0.2297E+00,0.2389E+00,0.2484E+00,0.2583E+00,0.2686E+00,
     +0.2792E+00,0.2902E+00,0.3016E+00,0.3134E+00,0.3255E+00,0.3379E+00,
     +0.3506E+00,0.3636E+00,0.3768E+00,0.3901E+00,0.4034E+00,0.4165E+00,
     +0.4293E+00,0.4416E+00,0.4531E+00,0.4635E+00,0.4724E+00,0.4794E+00,
     +0.4840E+00,0.4855E+00,0.4834E+00,0.4769E+00,0.4654E+00,0.4481E+00,
     +0.4246E+00,0.3944E+00,0.3575E+00,0.3142E+00,0.2656E+00,0.2133E+00,
     +0.1810E+00,0.1510E+00,0.1235E+00,0.9879E-01,0.7705E-01,0.5834E-01,
     +0.4264E-01,0.2985E-01,0.1979E-01,0.1222E-01,0.6853E-02,0.3336E-02,
     +0.1292E-02,0.3207E-03/
      DATA (XQDUM (I,3,2),I=1,104) /
     +0.1523E-01,0.1584E-01,0.1648E-01,0.1713E-01,0.1782E-01,0.1853E-01,
     +0.1927E-01,0.2004E-01,0.2085E-01,0.2168E-01,0.2255E-01,0.2345E-01,
     +0.2438E-01,0.2536E-01,0.2637E-01,0.2742E-01,0.2852E-01,0.2966E-01,
     +0.3084E-01,0.3207E-01,0.3335E-01,0.3468E-01,0.3606E-01,0.3749E-01,
     +0.3899E-01,0.4054E-01,0.4215E-01,0.4382E-01,0.4556E-01,0.4737E-01,
     +0.4925E-01,0.5121E-01,0.5324E-01,0.5534E-01,0.5753E-01,0.5981E-01,
     +0.6217E-01,0.6462E-01,0.6717E-01,0.6982E-01,0.7256E-01,0.7541E-01,
     +0.7837E-01,0.8144E-01,0.8463E-01,0.8793E-01,0.9136E-01,0.9491E-01,
     +0.9859E-01,0.1024E+00,0.1064E+00,0.1104E+00,0.1147E+00,0.1191E+00,
     +0.1236E+00,0.1283E+00,0.1331E+00,0.1380E+00,0.1431E+00,0.1484E+00,
     +0.1537E+00,0.1592E+00,0.1648E+00,0.1705E+00,0.1763E+00,0.1821E+00,
     +0.1879E+00,0.1936E+00,0.1993E+00,0.2047E+00,0.2099E+00,0.2148E+00,
     +0.2191E+00,0.2228E+00,0.2258E+00,0.2277E+00,0.2285E+00,0.2278E+00,
     +0.2255E+00,0.2213E+00,0.2149E+00,0.2061E+00,0.1947E+00,0.1808E+00,
     +0.1642E+00,0.1453E+00,0.1245E+00,0.1024E+00,0.7998E-01,0.5840E-01,
     +0.4636E-01,0.3598E-01,0.2724E-01,0.2004E-01,0.1427E-01,0.9771E-02,
     +0.6389E-02,0.3947E-02,0.2268E-02,0.1186E-02,0.5448E-03,0.2067E-03,
     +0.5743E-04,0.0000E+00/
      DATA (XQDUM (I,3,3),I=1,104) /
     +0.3544E+02,0.3450E+02,0.3357E+02,0.3267E+02,0.3178E+02,0.3091E+02,
     +0.3007E+02,0.2924E+02,0.2843E+02,0.2764E+02,0.2686E+02,0.2611E+02,
     +0.2536E+02,0.2464E+02,0.2393E+02,0.2324E+02,0.2257E+02,0.2191E+02,
     +0.2127E+02,0.2064E+02,0.2002E+02,0.1942E+02,0.1884E+02,0.1826E+02,
     +0.1770E+02,0.1716E+02,0.1663E+02,0.1611E+02,0.1560E+02,0.1511E+02,
     +0.1463E+02,0.1416E+02,0.1370E+02,0.1325E+02,0.1282E+02,0.1239E+02,
     +0.1198E+02,0.1157E+02,0.1118E+02,0.1080E+02,0.1042E+02,0.1006E+02,
     +0.9705E+01,0.9359E+01,0.9022E+01,0.8693E+01,0.8372E+01,0.8059E+01,
     +0.7754E+01,0.7455E+01,0.7163E+01,0.6878E+01,0.6599E+01,0.6325E+01,
     +0.6057E+01,0.5793E+01,0.5534E+01,0.5280E+01,0.5029E+01,0.4782E+01,
     +0.4538E+01,0.4297E+01,0.4059E+01,0.3824E+01,0.3592E+01,0.3362E+01,
     +0.3134E+01,0.2910E+01,0.2689E+01,0.2471E+01,0.2258E+01,0.2049E+01,
     +0.1846E+01,0.1649E+01,0.1460E+01,0.1278E+01,0.1107E+01,0.9453E+00,
     +0.7954E+00,0.6580E+00,0.5339E+00,0.4237E+00,0.3277E+00,0.2461E+00,
     +0.1786E+00,0.1244E+00,0.8260E-01,0.5174E-01,0.3019E-01,0.1613E-01,
     +0.1049E-01,0.6706E-02,0.4199E-02,0.2569E-02,0.1530E-02,0.8826E-03,
     +0.4902E-03,0.2598E-03,0.1295E-03,0.5954E-04,0.2437E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,4),I=1,104) /
     +0.2829E+01,0.2779E+01,0.2730E+01,0.2682E+01,0.2635E+01,0.2589E+01,
     +0.2544E+01,0.2500E+01,0.2457E+01,0.2414E+01,0.2372E+01,0.2331E+01,
     +0.2291E+01,0.2252E+01,0.2213E+01,0.2175E+01,0.2138E+01,0.2102E+01,
     +0.2066E+01,0.2031E+01,0.1996E+01,0.1963E+01,0.1929E+01,0.1897E+01,
     +0.1865E+01,0.1833E+01,0.1802E+01,0.1772E+01,0.1742E+01,0.1712E+01,
     +0.1683E+01,0.1654E+01,0.1626E+01,0.1597E+01,0.1569E+01,0.1542E+01,
     +0.1514E+01,0.1487E+01,0.1460E+01,0.1433E+01,0.1406E+01,0.1379E+01,
     +0.1351E+01,0.1324E+01,0.1297E+01,0.1269E+01,0.1241E+01,0.1213E+01,
     +0.1184E+01,0.1155E+01,0.1125E+01,0.1095E+01,0.1064E+01,0.1032E+01,
     +0.1000E+01,0.9672E+00,0.9334E+00,0.8989E+00,0.8635E+00,0.8273E+00,
     +0.7904E+00,0.7526E+00,0.7142E+00,0.6751E+00,0.6356E+00,0.5956E+00,
     +0.5554E+00,0.5151E+00,0.4750E+00,0.4353E+00,0.3962E+00,0.3581E+00,
     +0.3211E+00,0.2856E+00,0.2519E+00,0.2202E+00,0.1905E+00,0.1632E+00,
     +0.1383E+00,0.1156E+00,0.9534E-01,0.7725E-01,0.6127E-01,0.4729E-01,
     +0.3524E-01,0.2508E-01,0.1680E-01,0.1040E-01,0.5794E-02,0.2806E-02,
     +0.1660E-02,0.9384E-03,0.5036E-03,0.2548E-03,0.1205E-03,0.5271E-04,
     +0.2106E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,5),I=1,104) /
     +0.7350E+00,0.7248E+00,0.7147E+00,0.7048E+00,0.6951E+00,0.6856E+00,
     +0.6762E+00,0.6671E+00,0.6580E+00,0.6492E+00,0.6406E+00,0.6321E+00,
     +0.6237E+00,0.6155E+00,0.6075E+00,0.5996E+00,0.5919E+00,0.5843E+00,
     +0.5768E+00,0.5694E+00,0.5622E+00,0.5551E+00,0.5481E+00,0.5412E+00,
     +0.5344E+00,0.5277E+00,0.5210E+00,0.5145E+00,0.5080E+00,0.5016E+00,
     +0.4953E+00,0.4890E+00,0.4827E+00,0.4765E+00,0.4703E+00,0.4640E+00,
     +0.4578E+00,0.4516E+00,0.4453E+00,0.4390E+00,0.4326E+00,0.4262E+00,
     +0.4196E+00,0.4129E+00,0.4062E+00,0.3992E+00,0.3921E+00,0.3848E+00,
     +0.3774E+00,0.3696E+00,0.3617E+00,0.3535E+00,0.3450E+00,0.3361E+00,
     +0.3270E+00,0.3175E+00,0.3077E+00,0.2975E+00,0.2870E+00,0.2760E+00,
     +0.2648E+00,0.2531E+00,0.2411E+00,0.2288E+00,0.2162E+00,0.2034E+00,
     +0.1903E+00,0.1772E+00,0.1640E+00,0.1509E+00,0.1379E+00,0.1251E+00,
     +0.1127E+00,0.1007E+00,0.8922E-01,0.7839E-01,0.6825E-01,0.5884E-01,
     +0.5020E-01,0.4232E-01,0.3519E-01,0.2877E-01,0.2303E-01,0.1794E-01,
     +0.1349E-01,0.9676E-02,0.6530E-02,0.4065E-02,0.2275E-02,0.1104E-02,
     +0.6535E-03,0.3689E-03,0.1974E-03,0.9943E-04,0.4668E-04,0.2019E-04,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,6),I=1,104) /
     +0.5603E+00,0.5501E+00,0.5400E+00,0.5301E+00,0.5205E+00,0.5110E+00,
     +0.5017E+00,0.4925E+00,0.4836E+00,0.4748E+00,0.4662E+00,0.4578E+00,
     +0.4495E+00,0.4414E+00,0.4334E+00,0.4256E+00,0.4180E+00,0.4105E+00,
     +0.4031E+00,0.3959E+00,0.3888E+00,0.3818E+00,0.3750E+00,0.3683E+00,
     +0.3617E+00,0.3552E+00,0.3488E+00,0.3426E+00,0.3364E+00,0.3303E+00,
     +0.3243E+00,0.3184E+00,0.3126E+00,0.3068E+00,0.3011E+00,0.2955E+00,
     +0.2899E+00,0.2844E+00,0.2788E+00,0.2733E+00,0.2678E+00,0.2624E+00,
     +0.2569E+00,0.2514E+00,0.2459E+00,0.2403E+00,0.2347E+00,0.2291E+00,
     +0.2234E+00,0.2176E+00,0.2117E+00,0.2058E+00,0.1997E+00,0.1935E+00,
     +0.1872E+00,0.1808E+00,0.1743E+00,0.1676E+00,0.1608E+00,0.1539E+00,
     +0.1468E+00,0.1396E+00,0.1323E+00,0.1249E+00,0.1174E+00,0.1099E+00,
     +0.1023E+00,0.9475E-01,0.8725E-01,0.7983E-01,0.7256E-01,0.6546E-01,
     +0.5861E-01,0.5204E-01,0.4580E-01,0.3993E-01,0.3447E-01,0.2944E-01,
     +0.2485E-01,0.2071E-01,0.1700E-01,0.1372E-01,0.1083E-01,0.8317E-02,
     +0.6168E-02,0.4370E-02,0.2916E-02,0.1799E-02,0.9997E-03,0.4834E-03,
     +0.2859E-03,0.1617E-03,0.8687E-04,0.4405E-04,0.2090E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,7),I=1,104) /
     +0.4438E+00,0.4336E+00,0.4235E+00,0.4137E+00,0.4040E+00,0.3946E+00,
     +0.3853E+00,0.3762E+00,0.3673E+00,0.3585E+00,0.3500E+00,0.3416E+00,
     +0.3333E+00,0.3253E+00,0.3174E+00,0.3096E+00,0.3020E+00,0.2946E+00,
     +0.2873E+00,0.2802E+00,0.2732E+00,0.2663E+00,0.2596E+00,0.2530E+00,
     +0.2466E+00,0.2402E+00,0.2340E+00,0.2279E+00,0.2220E+00,0.2161E+00,
     +0.2104E+00,0.2047E+00,0.1992E+00,0.1938E+00,0.1884E+00,0.1831E+00,
     +0.1780E+00,0.1729E+00,0.1678E+00,0.1629E+00,0.1580E+00,0.1532E+00,
     +0.1484E+00,0.1437E+00,0.1390E+00,0.1344E+00,0.1298E+00,0.1252E+00,
     +0.1207E+00,0.1162E+00,0.1118E+00,0.1073E+00,0.1029E+00,0.9847E-01,
     +0.9408E-01,0.8970E-01,0.8535E-01,0.8101E-01,0.7669E-01,0.7240E-01,
     +0.6814E-01,0.6392E-01,0.5974E-01,0.5560E-01,0.5153E-01,0.4753E-01,
     +0.4361E-01,0.3978E-01,0.3607E-01,0.3247E-01,0.2901E-01,0.2571E-01,
     +0.2257E-01,0.1961E-01,0.1684E-01,0.1429E-01,0.1195E-01,0.9836E-02,
     +0.7953E-02,0.6301E-02,0.4879E-02,0.3680E-02,0.2692E-02,0.1902E-02,
     +0.1289E-02,0.8322E-03,0.5067E-03,0.2873E-03,0.1492E-03,0.6936E-04,
     +0.4091E-04,0.2354E-04,0.1316E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,8),I=1,104) /
     +0.3546E+00,0.3459E+00,0.3373E+00,0.3289E+00,0.3207E+00,0.3127E+00,
     +0.3048E+00,0.2971E+00,0.2896E+00,0.2821E+00,0.2749E+00,0.2678E+00,
     +0.2608E+00,0.2540E+00,0.2473E+00,0.2408E+00,0.2344E+00,0.2281E+00,
     +0.2220E+00,0.2160E+00,0.2101E+00,0.2043E+00,0.1987E+00,0.1932E+00,
     +0.1878E+00,0.1825E+00,0.1773E+00,0.1722E+00,0.1672E+00,0.1623E+00,
     +0.1576E+00,0.1529E+00,0.1483E+00,0.1438E+00,0.1394E+00,0.1351E+00,
     +0.1308E+00,0.1267E+00,0.1226E+00,0.1185E+00,0.1146E+00,0.1107E+00,
     +0.1069E+00,0.1031E+00,0.9940E-01,0.9574E-01,0.9213E-01,0.8858E-01,
     +0.8506E-01,0.8159E-01,0.7816E-01,0.7477E-01,0.7142E-01,0.6810E-01,
     +0.6482E-01,0.6158E-01,0.5837E-01,0.5520E-01,0.5207E-01,0.4897E-01,
     +0.4592E-01,0.4292E-01,0.3997E-01,0.3707E-01,0.3424E-01,0.3147E-01,
     +0.2878E-01,0.2616E-01,0.2364E-01,0.2121E-01,0.1889E-01,0.1668E-01,
     +0.1460E-01,0.1264E-01,0.1083E-01,0.9158E-02,0.7636E-02,0.6268E-02,
     +0.5054E-02,0.3994E-02,0.3085E-02,0.2321E-02,0.1695E-02,0.1195E-02,
     +0.8094E-03,0.5224E-03,0.3184E-03,0.1810E-03,0.9454E-04,0.4434E-04,
     +0.2638E-04,0.1534E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,9),I=1,104) /
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,1),I=1,104) /
     +0.2900E-01,0.3016E-01,0.3136E-01,0.3262E-01,0.3392E-01,0.3528E-01,
     +0.3669E-01,0.3815E-01,0.3968E-01,0.4126E-01,0.4291E-01,0.4463E-01,
     +0.4641E-01,0.4826E-01,0.5018E-01,0.5219E-01,0.5427E-01,0.5643E-01,
     +0.5868E-01,0.6102E-01,0.6345E-01,0.6597E-01,0.6860E-01,0.7132E-01,
     +0.7416E-01,0.7711E-01,0.8017E-01,0.8335E-01,0.8666E-01,0.9010E-01,
     +0.9367E-01,0.9738E-01,0.1012E+00,0.1052E+00,0.1094E+00,0.1137E+00,
     +0.1182E+00,0.1229E+00,0.1277E+00,0.1327E+00,0.1380E+00,0.1434E+00,
     +0.1490E+00,0.1549E+00,0.1609E+00,0.1672E+00,0.1738E+00,0.1805E+00,
     +0.1876E+00,0.1949E+00,0.2024E+00,0.2102E+00,0.2184E+00,0.2268E+00,
     +0.2355E+00,0.2445E+00,0.2538E+00,0.2634E+00,0.2733E+00,0.2835E+00,
     +0.2940E+00,0.3047E+00,0.3158E+00,0.3270E+00,0.3385E+00,0.3502E+00,
     +0.3619E+00,0.3737E+00,0.3855E+00,0.3971E+00,0.4084E+00,0.4192E+00,
     +0.4294E+00,0.4387E+00,0.4469E+00,0.4535E+00,0.4583E+00,0.4608E+00,
     +0.4605E+00,0.4570E+00,0.4498E+00,0.4382E+00,0.4219E+00,0.4003E+00,
     +0.3733E+00,0.3408E+00,0.3031E+00,0.2608E+00,0.2154E+00,0.1684E+00,
     +0.1405E+00,0.1151E+00,0.9239E-01,0.7249E-01,0.5539E-01,0.4105E-01,
     +0.2932E-01,0.2001E-01,0.1291E-01,0.7727E-02,0.4179E-02,0.1947E-02,
     +0.7131E-03,0.1631E-03/
      DATA (XQDUM (I,4,2),I=1,104) /
     +0.1662E-01,0.1729E-01,0.1798E-01,0.1869E-01,0.1944E-01,0.2021E-01,
     +0.2102E-01,0.2186E-01,0.2273E-01,0.2363E-01,0.2457E-01,0.2555E-01,
     +0.2657E-01,0.2762E-01,0.2872E-01,0.2986E-01,0.3105E-01,0.3228E-01,
     +0.3356E-01,0.3488E-01,0.3627E-01,0.3770E-01,0.3919E-01,0.4074E-01,
     +0.4234E-01,0.4401E-01,0.4574E-01,0.4754E-01,0.4941E-01,0.5135E-01,
     +0.5336E-01,0.5545E-01,0.5761E-01,0.5986E-01,0.6219E-01,0.6461E-01,
     +0.6711E-01,0.6971E-01,0.7241E-01,0.7520E-01,0.7809E-01,0.8108E-01,
     +0.8418E-01,0.8739E-01,0.9071E-01,0.9415E-01,0.9770E-01,0.1014E+00,
     +0.1052E+00,0.1091E+00,0.1131E+00,0.1173E+00,0.1215E+00,0.1259E+00,
     +0.1305E+00,0.1351E+00,0.1399E+00,0.1447E+00,0.1497E+00,0.1547E+00,
     +0.1599E+00,0.1650E+00,0.1703E+00,0.1755E+00,0.1807E+00,0.1858E+00,
     +0.1909E+00,0.1958E+00,0.2004E+00,0.2047E+00,0.2087E+00,0.2121E+00,
     +0.2149E+00,0.2169E+00,0.2180E+00,0.2180E+00,0.2167E+00,0.2139E+00,
     +0.2094E+00,0.2032E+00,0.1948E+00,0.1844E+00,0.1718E+00,0.1570E+00,
     +0.1403E+00,0.1219E+00,0.1023E+00,0.8235E-01,0.6278E-01,0.4461E-01,
     +0.3477E-01,0.2649E-01,0.1967E-01,0.1419E-01,0.9890E-02,0.6626E-02,
     +0.4231E-02,0.2547E-02,0.1423E-02,0.7210E-03,0.3191E-03,0.1158E-03,
     +0.3038E-04,0.0000E+00/
      DATA (XQDUM (I,4,3),I=1,104) /
     +0.7063E+02,0.6825E+02,0.6593E+02,0.6367E+02,0.6148E+02,0.5935E+02,
     +0.5729E+02,0.5528E+02,0.5333E+02,0.5144E+02,0.4961E+02,0.4782E+02,
     +0.4610E+02,0.4442E+02,0.4279E+02,0.4121E+02,0.3968E+02,0.3819E+02,
     +0.3676E+02,0.3536E+02,0.3401E+02,0.3270E+02,0.3143E+02,0.3020E+02,
     +0.2900E+02,0.2785E+02,0.2673E+02,0.2565E+02,0.2461E+02,0.2359E+02,
     +0.2261E+02,0.2167E+02,0.2075E+02,0.1986E+02,0.1901E+02,0.1818E+02,
     +0.1738E+02,0.1661E+02,0.1586E+02,0.1514E+02,0.1445E+02,0.1378E+02,
     +0.1313E+02,0.1251E+02,0.1190E+02,0.1132E+02,0.1076E+02,0.1022E+02,
     +0.9699E+01,0.9196E+01,0.8711E+01,0.8244E+01,0.7793E+01,0.7358E+01,
     +0.6939E+01,0.6534E+01,0.6144E+01,0.5767E+01,0.5404E+01,0.5053E+01,
     +0.4715E+01,0.4389E+01,0.4074E+01,0.3771E+01,0.3479E+01,0.3198E+01,
     +0.2928E+01,0.2668E+01,0.2420E+01,0.2183E+01,0.1956E+01,0.1742E+01,
     +0.1539E+01,0.1348E+01,0.1170E+01,0.1005E+01,0.8528E+00,0.7142E+00,
     +0.5892E+00,0.4779E+00,0.3803E+00,0.2961E+00,0.2249E+00,0.1660E+00,
     +0.1185E+00,0.8142E-01,0.5346E-01,0.3326E-01,0.1939E-01,0.1043E-01,
     +0.6853E-02,0.4436E-02,0.2821E-02,0.1757E-02,0.1067E-02,0.6274E-03,
     +0.3546E-03,0.1905E-03,0.9566E-04,0.4386E-04,0.1768E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,4),I=1,104) /
     +0.6783E+01,0.6605E+01,0.6430E+01,0.6260E+01,0.6095E+01,0.5933E+01,
     +0.5775E+01,0.5621E+01,0.5471E+01,0.5325E+01,0.5183E+01,0.5044E+01,
     +0.4908E+01,0.4776E+01,0.4648E+01,0.4522E+01,0.4400E+01,0.4281E+01,
     +0.4165E+01,0.4051E+01,0.3941E+01,0.3834E+01,0.3729E+01,0.3627E+01,
     +0.3527E+01,0.3430E+01,0.3335E+01,0.3243E+01,0.3153E+01,0.3065E+01,
     +0.2979E+01,0.2895E+01,0.2814E+01,0.2734E+01,0.2656E+01,0.2579E+01,
     +0.2504E+01,0.2431E+01,0.2359E+01,0.2289E+01,0.2220E+01,0.2152E+01,
     +0.2085E+01,0.2019E+01,0.1954E+01,0.1890E+01,0.1827E+01,0.1765E+01,
     +0.1703E+01,0.1642E+01,0.1581E+01,0.1520E+01,0.1460E+01,0.1401E+01,
     +0.1341E+01,0.1282E+01,0.1223E+01,0.1164E+01,0.1105E+01,0.1046E+01,
     +0.9878E+00,0.9296E+00,0.8718E+00,0.8145E+00,0.7577E+00,0.7017E+00,
     +0.6466E+00,0.5925E+00,0.5399E+00,0.4887E+00,0.4394E+00,0.3922E+00,
     +0.3473E+00,0.3049E+00,0.2653E+00,0.2286E+00,0.1950E+00,0.1644E+00,
     +0.1370E+00,0.1125E+00,0.9096E-01,0.7216E-01,0.5594E-01,0.4214E-01,
     +0.3059E-01,0.2118E-01,0.1380E-01,0.8292E-02,0.4486E-02,0.2110E-02,
     +0.1227E-02,0.6836E-03,0.3625E-03,0.1819E-03,0.8582E-04,0.3775E-04,
     +0.1535E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,5),I=1,104) /
     +0.1525E+01,0.1489E+01,0.1454E+01,0.1420E+01,0.1386E+01,0.1354E+01,
     +0.1322E+01,0.1291E+01,0.1260E+01,0.1231E+01,0.1202E+01,0.1174E+01,
     +0.1146E+01,0.1120E+01,0.1094E+01,0.1068E+01,0.1043E+01,0.1019E+01,
     +0.9956E+00,0.9726E+00,0.9502E+00,0.9283E+00,0.9069E+00,0.8860E+00,
     +0.8657E+00,0.8458E+00,0.8264E+00,0.8074E+00,0.7888E+00,0.7707E+00,
     +0.7529E+00,0.7356E+00,0.7185E+00,0.7018E+00,0.6854E+00,0.6693E+00,
     +0.6535E+00,0.6379E+00,0.6226E+00,0.6075E+00,0.5925E+00,0.5777E+00,
     +0.5631E+00,0.5485E+00,0.5341E+00,0.5197E+00,0.5053E+00,0.4910E+00,
     +0.4766E+00,0.4623E+00,0.4478E+00,0.4334E+00,0.4188E+00,0.4041E+00,
     +0.3892E+00,0.3743E+00,0.3591E+00,0.3439E+00,0.3284E+00,0.3128E+00,
     +0.2971E+00,0.2813E+00,0.2653E+00,0.2493E+00,0.2333E+00,0.2172E+00,
     +0.2013E+00,0.1856E+00,0.1700E+00,0.1549E+00,0.1401E+00,0.1258E+00,
     +0.1121E+00,0.9911E-01,0.8688E-01,0.7546E-01,0.6491E-01,0.5526E-01,
     +0.4651E-01,0.3863E-01,0.3161E-01,0.2539E-01,0.1994E-01,0.1521E-01,
     +0.1118E-01,0.7829E-02,0.5148E-02,0.3118E-02,0.1695E-02,0.7985E-03,
     +0.4637E-03,0.2572E-03,0.1354E-03,0.6724E-04,0.3121E-04,0.1341E-04,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,6),I=1,104) /
     +0.1351E+01,0.1315E+01,0.1280E+01,0.1245E+01,0.1212E+01,0.1179E+01,
     +0.1147E+01,0.1116E+01,0.1086E+01,0.1057E+01,0.1028E+01,0.9999E+00,
     +0.9726E+00,0.9460E+00,0.9200E+00,0.8947E+00,0.8700E+00,0.8460E+00,
     +0.8225E+00,0.7997E+00,0.7775E+00,0.7558E+00,0.7346E+00,0.7140E+00,
     +0.6939E+00,0.6744E+00,0.6553E+00,0.6366E+00,0.6185E+00,0.6008E+00,
     +0.5835E+00,0.5666E+00,0.5501E+00,0.5340E+00,0.5183E+00,0.5029E+00,
     +0.4879E+00,0.4732E+00,0.4587E+00,0.4446E+00,0.4307E+00,0.4171E+00,
     +0.4037E+00,0.3906E+00,0.3776E+00,0.3648E+00,0.3522E+00,0.3398E+00,
     +0.3275E+00,0.3153E+00,0.3033E+00,0.2913E+00,0.2794E+00,0.2676E+00,
     +0.2559E+00,0.2443E+00,0.2327E+00,0.2212E+00,0.2097E+00,0.1983E+00,
     +0.1869E+00,0.1757E+00,0.1645E+00,0.1535E+00,0.1426E+00,0.1318E+00,
     +0.1213E+00,0.1110E+00,0.1010E+00,0.9125E-01,0.8190E-01,0.7297E-01,
     +0.6448E-01,0.5650E-01,0.4905E-01,0.4215E-01,0.3584E-01,0.3013E-01,
     +0.2500E-01,0.2045E-01,0.1646E-01,0.1300E-01,0.1002E-01,0.7510E-02,
     +0.5424E-02,0.3738E-02,0.2424E-02,0.1452E-02,0.7834E-03,0.3680E-03,
     +0.2142E-03,0.1195E-03,0.6350E-04,0.3200E-04,0.1518E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,7),I=1,104) /
     +0.1234E+01,0.1198E+01,0.1163E+01,0.1129E+01,0.1096E+01,0.1063E+01,
     +0.1031E+01,0.1000E+01,0.9700E+00,0.9406E+00,0.9119E+00,0.8839E+00,
     +0.8567E+00,0.8301E+00,0.8042E+00,0.7790E+00,0.7544E+00,0.7305E+00,
     +0.7072E+00,0.6844E+00,0.6623E+00,0.6408E+00,0.6198E+00,0.5994E+00,
     +0.5794E+00,0.5601E+00,0.5412E+00,0.5228E+00,0.5049E+00,0.4875E+00,
     +0.4705E+00,0.4540E+00,0.4379E+00,0.4222E+00,0.4069E+00,0.3920E+00,
     +0.3775E+00,0.3633E+00,0.3495E+00,0.3360E+00,0.3229E+00,0.3100E+00,
     +0.2975E+00,0.2853E+00,0.2733E+00,0.2616E+00,0.2502E+00,0.2390E+00,
     +0.2281E+00,0.2173E+00,0.2069E+00,0.1966E+00,0.1865E+00,0.1767E+00,
     +0.1671E+00,0.1576E+00,0.1484E+00,0.1394E+00,0.1305E+00,0.1219E+00,
     +0.1135E+00,0.1053E+00,0.9734E-01,0.8961E-01,0.8212E-01,0.7490E-01,
     +0.6794E-01,0.6127E-01,0.5490E-01,0.4885E-01,0.4313E-01,0.3775E-01,
     +0.3273E-01,0.2809E-01,0.2382E-01,0.1995E-01,0.1646E-01,0.1337E-01,
     +0.1066E-01,0.8333E-02,0.6361E-02,0.4729E-02,0.3410E-02,0.2374E-02,
     +0.1586E-02,0.1010E-02,0.6070E-03,0.3403E-03,0.1752E-03,0.8106E-04,
     +0.4784E-04,0.2762E-04,0.1555E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,8),I=1,104) /
     +0.1147E+01,0.1113E+01,0.1079E+01,0.1046E+01,0.1014E+01,0.9833E+00,
     +0.9529E+00,0.9232E+00,0.8944E+00,0.8662E+00,0.8388E+00,0.8121E+00,
     +0.7861E+00,0.7607E+00,0.7360E+00,0.7120E+00,0.6886E+00,0.6658E+00,
     +0.6436E+00,0.6220E+00,0.6010E+00,0.5805E+00,0.5606E+00,0.5412E+00,
     +0.5223E+00,0.5039E+00,0.4861E+00,0.4687E+00,0.4518E+00,0.4353E+00,
     +0.4193E+00,0.4037E+00,0.3886E+00,0.3738E+00,0.3595E+00,0.3455E+00,
     +0.3319E+00,0.3187E+00,0.3058E+00,0.2933E+00,0.2811E+00,0.2692E+00,
     +0.2576E+00,0.2464E+00,0.2354E+00,0.2247E+00,0.2143E+00,0.2041E+00,
     +0.1942E+00,0.1845E+00,0.1751E+00,0.1659E+00,0.1569E+00,0.1482E+00,
     +0.1397E+00,0.1314E+00,0.1233E+00,0.1154E+00,0.1077E+00,0.1003E+00,
     +0.9309E-01,0.8610E-01,0.7933E-01,0.7280E-01,0.6651E-01,0.6046E-01,
     +0.5468E-01,0.4915E-01,0.4391E-01,0.3895E-01,0.3428E-01,0.2992E-01,
     +0.2586E-01,0.2213E-01,0.1871E-01,0.1562E-01,0.1286E-01,0.1042E-01,
     +0.8286E-02,0.6459E-02,0.4920E-02,0.3650E-02,0.2628E-02,0.1828E-02,
     +0.1221E-02,0.7775E-03,0.4681E-03,0.2634E-03,0.1365E-03,0.6378E-04,
     +0.3796E-04,0.2214E-04,0.1261E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,9),I=1,104) /
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,1),I=1,104) /
     +0.3111E-01,0.3236E-01,0.3365E-01,0.3499E-01,0.3639E-01,0.3784E-01,
     +0.3935E-01,0.4091E-01,0.4254E-01,0.4424E-01,0.4600E-01,0.4783E-01,
     +0.4973E-01,0.5171E-01,0.5377E-01,0.5590E-01,0.5812E-01,0.6043E-01,
     +0.6282E-01,0.6531E-01,0.6790E-01,0.7059E-01,0.7338E-01,0.7628E-01,
     +0.7929E-01,0.8242E-01,0.8567E-01,0.8905E-01,0.9255E-01,0.9619E-01,
     +0.9997E-01,0.1039E+00,0.1080E+00,0.1122E+00,0.1166E+00,0.1211E+00,
     +0.1258E+00,0.1307E+00,0.1358E+00,0.1411E+00,0.1466E+00,0.1522E+00,
     +0.1581E+00,0.1642E+00,0.1705E+00,0.1770E+00,0.1837E+00,0.1907E+00,
     +0.1980E+00,0.2055E+00,0.2132E+00,0.2212E+00,0.2294E+00,0.2379E+00,
     +0.2467E+00,0.2557E+00,0.2650E+00,0.2745E+00,0.2843E+00,0.2943E+00,
     +0.3046E+00,0.3150E+00,0.3256E+00,0.3363E+00,0.3471E+00,0.3580E+00,
     +0.3687E+00,0.3794E+00,0.3898E+00,0.3999E+00,0.4094E+00,0.4182E+00,
     +0.4262E+00,0.4330E+00,0.4384E+00,0.4421E+00,0.4436E+00,0.4427E+00,
     +0.4390E+00,0.4319E+00,0.4211E+00,0.4062E+00,0.3868E+00,0.3628E+00,
     +0.3340E+00,0.3007E+00,0.2634E+00,0.2230E+00,0.1807E+00,0.1384E+00,
     +0.1138E+00,0.9190E-01,0.7268E-01,0.5615E-01,0.4221E-01,0.3075E-01,
     +0.2155E-01,0.1442E-01,0.9097E-02,0.5312E-02,0.2791E-02,0.1256E-02,
     +0.4394E-03,0.9408E-04/
      DATA (XQDUM (I,5,2),I=1,104) /
     +0.1782E-01,0.1853E-01,0.1927E-01,0.2004E-01,0.2083E-01,0.2166E-01,
     +0.2252E-01,0.2342E-01,0.2434E-01,0.2531E-01,0.2631E-01,0.2735E-01,
     +0.2844E-01,0.2956E-01,0.3073E-01,0.3194E-01,0.3320E-01,0.3451E-01,
     +0.3587E-01,0.3728E-01,0.3874E-01,0.4026E-01,0.4184E-01,0.4348E-01,
     +0.4518E-01,0.4694E-01,0.4877E-01,0.5067E-01,0.5263E-01,0.5467E-01,
     +0.5679E-01,0.5898E-01,0.6125E-01,0.6361E-01,0.6605E-01,0.6857E-01,
     +0.7119E-01,0.7389E-01,0.7669E-01,0.7959E-01,0.8258E-01,0.8568E-01,
     +0.8888E-01,0.9218E-01,0.9559E-01,0.9910E-01,0.1027E+00,0.1065E+00,
     +0.1103E+00,0.1143E+00,0.1183E+00,0.1225E+00,0.1268E+00,0.1311E+00,
     +0.1356E+00,0.1402E+00,0.1448E+00,0.1495E+00,0.1543E+00,0.1591E+00,
     +0.1640E+00,0.1688E+00,0.1737E+00,0.1784E+00,0.1831E+00,0.1877E+00,
     +0.1920E+00,0.1961E+00,0.1999E+00,0.2033E+00,0.2062E+00,0.2084E+00,
     +0.2100E+00,0.2107E+00,0.2103E+00,0.2089E+00,0.2061E+00,0.2018E+00,
     +0.1959E+00,0.1883E+00,0.1788E+00,0.1674E+00,0.1542E+00,0.1392E+00,
     +0.1227E+00,0.1051E+00,0.8685E-01,0.6868E-01,0.5136E-01,0.3571E-01,
     +0.2743E-01,0.2059E-01,0.1506E-01,0.1069E-01,0.7327E-02,0.4823E-02,
     +0.3022E-02,0.1782E-02,0.9735E-03,0.4807E-03,0.2066E-03,0.7232E-04,
     +0.1812E-04,0.0000E+00/
      DATA (XQDUM (I,5,3),I=1,104) /
     +0.1077E+03,0.1035E+03,0.9951E+02,0.9561E+02,0.9184E+02,0.8819E+02,
     +0.8467E+02,0.8127E+02,0.7798E+02,0.7480E+02,0.7174E+02,0.6878E+02,
     +0.6592E+02,0.6316E+02,0.6050E+02,0.5794E+02,0.5546E+02,0.5307E+02,
     +0.5077E+02,0.4855E+02,0.4641E+02,0.4435E+02,0.4237E+02,0.4046E+02,
     +0.3862E+02,0.3684E+02,0.3514E+02,0.3350E+02,0.3192E+02,0.3040E+02,
     +0.2894E+02,0.2754E+02,0.2619E+02,0.2490E+02,0.2366E+02,0.2246E+02,
     +0.2132E+02,0.2022E+02,0.1917E+02,0.1816E+02,0.1719E+02,0.1626E+02,
     +0.1537E+02,0.1452E+02,0.1370E+02,0.1292E+02,0.1218E+02,0.1146E+02,
     +0.1078E+02,0.1013E+02,0.9503E+01,0.8907E+01,0.8338E+01,0.7794E+01,
     +0.7275E+01,0.6781E+01,0.6309E+01,0.5858E+01,0.5429E+01,0.5021E+01,
     +0.4632E+01,0.4262E+01,0.3910E+01,0.3576E+01,0.3259E+01,0.2959E+01,
     +0.2675E+01,0.2407E+01,0.2155E+01,0.1919E+01,0.1698E+01,0.1491E+01,
     +0.1300E+01,0.1124E+01,0.9625E+00,0.8155E+00,0.6828E+00,0.5643E+00,
     +0.4594E+00,0.3679E+00,0.2891E+00,0.2225E+00,0.1671E+00,0.1221E+00,
     +0.8641E-01,0.5896E-01,0.3854E-01,0.2394E-01,0.1398E-01,0.7558E-02,
     +0.4986E-02,0.3243E-02,0.2072E-02,0.1295E-02,0.7880E-03,0.4634E-03,
     +0.2611E-03,0.1392E-03,0.6905E-04,0.3108E-04,0.1221E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,4),I=1,104) /
     +0.1237E+02,0.1197E+02,0.1158E+02,0.1121E+02,0.1085E+02,0.1050E+02,
     +0.1015E+02,0.9822E+01,0.9500E+01,0.9187E+01,0.8884E+01,0.8590E+01,
     +0.8305E+01,0.8028E+01,0.7760E+01,0.7499E+01,0.7247E+01,0.7002E+01,
     +0.6765E+01,0.6535E+01,0.6312E+01,0.6096E+01,0.5886E+01,0.5683E+01,
     +0.5486E+01,0.5295E+01,0.5110E+01,0.4931E+01,0.4758E+01,0.4589E+01,
     +0.4426E+01,0.4268E+01,0.4114E+01,0.3965E+01,0.3821E+01,0.3681E+01,
     +0.3545E+01,0.3413E+01,0.3284E+01,0.3160E+01,0.3039E+01,0.2921E+01,
     +0.2806E+01,0.2694E+01,0.2585E+01,0.2479E+01,0.2376E+01,0.2275E+01,
     +0.2176E+01,0.2079E+01,0.1985E+01,0.1892E+01,0.1801E+01,0.1712E+01,
     +0.1625E+01,0.1539E+01,0.1455E+01,0.1373E+01,0.1292E+01,0.1212E+01,
     +0.1134E+01,0.1058E+01,0.9831E+00,0.9102E+00,0.8391E+00,0.7700E+00,
     +0.7030E+00,0.6384E+00,0.5763E+00,0.5169E+00,0.4604E+00,0.4070E+00,
     +0.3569E+00,0.3103E+00,0.2673E+00,0.2279E+00,0.1922E+00,0.1603E+00,
     +0.1319E+00,0.1069E+00,0.8525E-01,0.6663E-01,0.5083E-01,0.3763E-01,
     +0.2682E-01,0.1822E-01,0.1163E-01,0.6844E-02,0.3625E-02,0.1670E-02,
     +0.9605E-03,0.5298E-03,0.2789E-03,0.1394E-03,0.6580E-04,0.2914E-04,
     +0.1203E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,5),I=1,104) /
     +0.2541E+01,0.2466E+01,0.2392E+01,0.2321E+01,0.2252E+01,0.2184E+01,
     +0.2119E+01,0.2055E+01,0.1994E+01,0.1934E+01,0.1876E+01,0.1819E+01,
     +0.1765E+01,0.1712E+01,0.1660E+01,0.1610E+01,0.1562E+01,0.1515E+01,
     +0.1469E+01,0.1424E+01,0.1381E+01,0.1340E+01,0.1299E+01,0.1260E+01,
     +0.1222E+01,0.1185E+01,0.1149E+01,0.1114E+01,0.1080E+01,0.1047E+01,
     +0.1015E+01,0.9842E+00,0.9540E+00,0.9246E+00,0.8960E+00,0.8682E+00,
     +0.8410E+00,0.8146E+00,0.7888E+00,0.7636E+00,0.7390E+00,0.7150E+00,
     +0.6914E+00,0.6683E+00,0.6456E+00,0.6233E+00,0.6014E+00,0.5798E+00,
     +0.5585E+00,0.5375E+00,0.5167E+00,0.4961E+00,0.4758E+00,0.4555E+00,
     +0.4354E+00,0.4155E+00,0.3956E+00,0.3759E+00,0.3563E+00,0.3368E+00,
     +0.3174E+00,0.2982E+00,0.2791E+00,0.2602E+00,0.2416E+00,0.2233E+00,
     +0.2053E+00,0.1878E+00,0.1708E+00,0.1543E+00,0.1385E+00,0.1234E+00,
     +0.1090E+00,0.9562E-01,0.8310E-01,0.7156E-01,0.6100E-01,0.5143E-01,
     +0.4285E-01,0.3520E-01,0.2846E-01,0.2257E-01,0.1748E-01,0.1313E-01,
     +0.9489E-02,0.6526E-02,0.4209E-02,0.2498E-02,0.1329E-02,0.6117E-03,
     +0.3504E-03,0.1918E-03,0.9982E-04,0.4906E-04,0.2260E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,6),I=1,104) /
     +0.2367E+01,0.2291E+01,0.2218E+01,0.2147E+01,0.2077E+01,0.2010E+01,
     +0.1945E+01,0.1881E+01,0.1820E+01,0.1760E+01,0.1702E+01,0.1646E+01,
     +0.1591E+01,0.1538E+01,0.1487E+01,0.1437E+01,0.1389E+01,0.1342E+01,
     +0.1296E+01,0.1252E+01,0.1209E+01,0.1168E+01,0.1128E+01,0.1089E+01,
     +0.1051E+01,0.1014E+01,0.9788E+00,0.9443E+00,0.9109E+00,0.8785E+00,
     +0.8471E+00,0.8167E+00,0.7871E+00,0.7585E+00,0.7307E+00,0.7037E+00,
     +0.6775E+00,0.6520E+00,0.6273E+00,0.6032E+00,0.5799E+00,0.5572E+00,
     +0.5350E+00,0.5135E+00,0.4925E+00,0.4720E+00,0.4520E+00,0.4325E+00,
     +0.4135E+00,0.3949E+00,0.3767E+00,0.3588E+00,0.3414E+00,0.3242E+00,
     +0.3075E+00,0.2910E+00,0.2749E+00,0.2591E+00,0.2435E+00,0.2283E+00,
     +0.2134E+00,0.1989E+00,0.1846E+00,0.1708E+00,0.1572E+00,0.1441E+00,
     +0.1314E+00,0.1192E+00,0.1075E+00,0.9627E-01,0.8562E-01,0.7557E-01,
     +0.6616E-01,0.5741E-01,0.4935E-01,0.4198E-01,0.3532E-01,0.2935E-01,
     +0.2407E-01,0.1944E-01,0.1544E-01,0.1201E-01,0.9118E-02,0.6718E-02,
     +0.4765E-02,0.3222E-02,0.2048E-02,0.1202E-02,0.6352E-03,0.2924E-03,
     +0.1683E-03,0.9298E-04,0.4909E-04,0.2465E-04,0.1170E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,7),I=1,104) /
     +0.2251E+01,0.2175E+01,0.2102E+01,0.2030E+01,0.1961E+01,0.1894E+01,
     +0.1829E+01,0.1765E+01,0.1704E+01,0.1644E+01,0.1586E+01,0.1530E+01,
     +0.1476E+01,0.1423E+01,0.1371E+01,0.1322E+01,0.1273E+01,0.1227E+01,
     +0.1181E+01,0.1137E+01,0.1095E+01,0.1053E+01,0.1013E+01,0.9746E+00,
     +0.9370E+00,0.9006E+00,0.8654E+00,0.8312E+00,0.7981E+00,0.7661E+00,
     +0.7351E+00,0.7050E+00,0.6759E+00,0.6477E+00,0.6204E+00,0.5940E+00,
     +0.5684E+00,0.5436E+00,0.5196E+00,0.4963E+00,0.4738E+00,0.4519E+00,
     +0.4308E+00,0.4103E+00,0.3904E+00,0.3711E+00,0.3525E+00,0.3344E+00,
     +0.3168E+00,0.2998E+00,0.2833E+00,0.2673E+00,0.2518E+00,0.2367E+00,
     +0.2222E+00,0.2080E+00,0.1944E+00,0.1812E+00,0.1684E+00,0.1560E+00,
     +0.1441E+00,0.1327E+00,0.1217E+00,0.1111E+00,0.1010E+00,0.9135E-01,
     +0.8218E-01,0.7349E-01,0.6529E-01,0.5759E-01,0.5040E-01,0.4372E-01,
     +0.3757E-01,0.3194E-01,0.2684E-01,0.2226E-01,0.1820E-01,0.1463E-01,
     +0.1155E-01,0.8936E-02,0.6753E-02,0.4968E-02,0.3546E-02,0.2443E-02,
     +0.1616E-02,0.1019E-02,0.6068E-03,0.3375E-03,0.1727E-03,0.7956E-04,
     +0.4691E-04,0.2710E-04,0.1527E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,8),I=1,104) /
     +0.2165E+01,0.2091E+01,0.2019E+01,0.1950E+01,0.1882E+01,0.1816E+01,
     +0.1752E+01,0.1690E+01,0.1630E+01,0.1571E+01,0.1515E+01,0.1460E+01,
     +0.1406E+01,0.1355E+01,0.1305E+01,0.1256E+01,0.1209E+01,0.1163E+01,
     +0.1119E+01,0.1076E+01,0.1035E+01,0.9945E+00,0.9555E+00,0.9178E+00,
     +0.8812E+00,0.8458E+00,0.8116E+00,0.7784E+00,0.7463E+00,0.7152E+00,
     +0.6852E+00,0.6561E+00,0.6279E+00,0.6007E+00,0.5743E+00,0.5488E+00,
     +0.5242E+00,0.5003E+00,0.4773E+00,0.4549E+00,0.4334E+00,0.4125E+00,
     +0.3923E+00,0.3728E+00,0.3539E+00,0.3356E+00,0.3180E+00,0.3009E+00,
     +0.2844E+00,0.2684E+00,0.2529E+00,0.2380E+00,0.2236E+00,0.2097E+00,
     +0.1962E+00,0.1832E+00,0.1707E+00,0.1586E+00,0.1470E+00,0.1359E+00,
     +0.1251E+00,0.1148E+00,0.1050E+00,0.9560E-01,0.8665E-01,0.7814E-01,
     +0.7009E-01,0.6249E-01,0.5536E-01,0.4868E-01,0.4248E-01,0.3675E-01,
     +0.3149E-01,0.2670E-01,0.2237E-01,0.1850E-01,0.1508E-01,0.1210E-01,
     +0.9532E-02,0.7357E-02,0.5548E-02,0.4075E-02,0.2905E-02,0.2000E-02,
     +0.1323E-02,0.8350E-03,0.4985E-03,0.2784E-03,0.1434E-03,0.6676E-04,
     +0.3969E-04,0.2314E-04,0.1318E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,9),I=1,104) /
     +0.4999E+00,0.4801E+00,0.4610E+00,0.4425E+00,0.4246E+00,0.4073E+00,
     +0.3906E+00,0.3745E+00,0.3589E+00,0.3439E+00,0.3294E+00,0.3154E+00,
     +0.3019E+00,0.2889E+00,0.2763E+00,0.2642E+00,0.2525E+00,0.2413E+00,
     +0.2305E+00,0.2200E+00,0.2100E+00,0.2003E+00,0.1909E+00,0.1820E+00,
     +0.1733E+00,0.1650E+00,0.1570E+00,0.1494E+00,0.1420E+00,0.1349E+00,
     +0.1281E+00,0.1216E+00,0.1153E+00,0.1093E+00,0.1035E+00,0.9793E-01,
     +0.9261E-01,0.8752E-01,0.8263E-01,0.7796E-01,0.7348E-01,0.6920E-01,
     +0.6510E-01,0.6118E-01,0.5743E-01,0.5385E-01,0.5043E-01,0.4716E-01,
     +0.4405E-01,0.4108E-01,0.3824E-01,0.3555E-01,0.3298E-01,0.3054E-01,
     +0.2822E-01,0.2602E-01,0.2393E-01,0.2196E-01,0.2009E-01,0.1832E-01,
     +0.1665E-01,0.1509E-01,0.1361E-01,0.1223E-01,0.1094E-01,0.9742E-02,
     +0.8625E-02,0.7592E-02,0.6640E-02,0.5767E-02,0.4970E-02,0.4247E-02,
     +0.3596E-02,0.3014E-02,0.2497E-02,0.2044E-02,0.1649E-02,0.1311E-02,
     +0.1024E-02,0.7847E-03,0.5884E-03,0.4305E-03,0.3064E-03,0.2112E-03,
     +0.1404E-03,0.8946E-04,0.5422E-04,0.3096E-04,0.1645E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,1),I=1,104) /
     +0.3301E-01,0.3433E-01,0.3569E-01,0.3711E-01,0.3859E-01,0.4013E-01,
     +0.4172E-01,0.4338E-01,0.4510E-01,0.4689E-01,0.4875E-01,0.5069E-01,
     +0.5270E-01,0.5478E-01,0.5695E-01,0.5921E-01,0.6155E-01,0.6398E-01,
     +0.6650E-01,0.6912E-01,0.7185E-01,0.7468E-01,0.7761E-01,0.8066E-01,
     +0.8382E-01,0.8711E-01,0.9052E-01,0.9406E-01,0.9773E-01,0.1015E+00,
     +0.1055E+00,0.1096E+00,0.1138E+00,0.1182E+00,0.1228E+00,0.1276E+00,
     +0.1325E+00,0.1376E+00,0.1428E+00,0.1483E+00,0.1539E+00,0.1598E+00,
     +0.1658E+00,0.1721E+00,0.1786E+00,0.1852E+00,0.1922E+00,0.1993E+00,
     +0.2067E+00,0.2143E+00,0.2221E+00,0.2302E+00,0.2385E+00,0.2470E+00,
     +0.2558E+00,0.2647E+00,0.2739E+00,0.2833E+00,0.2929E+00,0.3027E+00,
     +0.3126E+00,0.3226E+00,0.3327E+00,0.3429E+00,0.3530E+00,0.3630E+00,
     +0.3729E+00,0.3824E+00,0.3916E+00,0.4003E+00,0.4082E+00,0.4153E+00,
     +0.4213E+00,0.4260E+00,0.4291E+00,0.4303E+00,0.4293E+00,0.4258E+00,
     +0.4193E+00,0.4096E+00,0.3962E+00,0.3790E+00,0.3576E+00,0.3321E+00,
     +0.3026E+00,0.2693E+00,0.2329E+00,0.1943E+00,0.1550E+00,0.1167E+00,
     +0.9484E-01,0.7565E-01,0.5909E-01,0.4505E-01,0.3341E-01,0.2398E-01,
     +0.1655E-01,0.1089E-01,0.6741E-02,0.3854E-02,0.1976E-02,0.8629E-03,
     +0.2907E-03,0.5885E-04/
      DATA (XQDUM (I,6,2),I=1,104) /
     +0.1890E-01,0.1965E-01,0.2043E-01,0.2124E-01,0.2208E-01,0.2295E-01,
     +0.2386E-01,0.2480E-01,0.2578E-01,0.2680E-01,0.2786E-01,0.2896E-01,
     +0.3010E-01,0.3128E-01,0.3251E-01,0.3379E-01,0.3511E-01,0.3648E-01,
     +0.3791E-01,0.3939E-01,0.4093E-01,0.4252E-01,0.4417E-01,0.4589E-01,
     +0.4766E-01,0.4951E-01,0.5142E-01,0.5340E-01,0.5545E-01,0.5757E-01,
     +0.5977E-01,0.6205E-01,0.6441E-01,0.6685E-01,0.6937E-01,0.7198E-01,
     +0.7468E-01,0.7747E-01,0.8035E-01,0.8333E-01,0.8640E-01,0.8957E-01,
     +0.9284E-01,0.9620E-01,0.9967E-01,0.1032E+00,0.1069E+00,0.1107E+00,
     +0.1145E+00,0.1185E+00,0.1226E+00,0.1267E+00,0.1309E+00,0.1353E+00,
     +0.1396E+00,0.1441E+00,0.1486E+00,0.1532E+00,0.1577E+00,0.1623E+00,
     +0.1669E+00,0.1714E+00,0.1759E+00,0.1802E+00,0.1844E+00,0.1884E+00,
     +0.1922E+00,0.1956E+00,0.1986E+00,0.2012E+00,0.2031E+00,0.2044E+00,
     +0.2050E+00,0.2046E+00,0.2031E+00,0.2005E+00,0.1966E+00,0.1912E+00,
     +0.1843E+00,0.1757E+00,0.1655E+00,0.1536E+00,0.1401E+00,0.1252E+00,
     +0.1091E+00,0.9231E-01,0.7529E-01,0.5867E-01,0.4317E-01,0.2947E-01,
     +0.2237E-01,0.1658E-01,0.1197E-01,0.8382E-02,0.5666E-02,0.3674E-02,
     +0.2266E-02,0.1313E-02,0.7037E-03,0.3401E-03,0.1425E-03,0.4841E-04,
     +0.1167E-04,0.0000E+00/
      DATA (XQDUM (I,6,3),I=1,104) /
     +0.1443E+03,0.1381E+03,0.1322E+03,0.1265E+03,0.1210E+03,0.1157E+03,
     +0.1107E+03,0.1058E+03,0.1011E+03,0.9655E+02,0.9220E+02,0.8801E+02,
     +0.8399E+02,0.8013E+02,0.7642E+02,0.7285E+02,0.6942E+02,0.6614E+02,
     +0.6298E+02,0.5995E+02,0.5704E+02,0.5425E+02,0.5158E+02,0.4902E+02,
     +0.4656E+02,0.4421E+02,0.4195E+02,0.3980E+02,0.3773E+02,0.3575E+02,
     +0.3386E+02,0.3205E+02,0.3032E+02,0.2867E+02,0.2709E+02,0.2558E+02,
     +0.2414E+02,0.2277E+02,0.2146E+02,0.2020E+02,0.1901E+02,0.1788E+02,
     +0.1680E+02,0.1577E+02,0.1479E+02,0.1385E+02,0.1297E+02,0.1213E+02,
     +0.1133E+02,0.1057E+02,0.9846E+01,0.9162E+01,0.8513E+01,0.7899E+01,
     +0.7317E+01,0.6766E+01,0.6245E+01,0.5753E+01,0.5288E+01,0.4849E+01,
     +0.4435E+01,0.4045E+01,0.3679E+01,0.3334E+01,0.3011E+01,0.2708E+01,
     +0.2426E+01,0.2162E+01,0.1917E+01,0.1690E+01,0.1481E+01,0.1288E+01,
     +0.1112E+01,0.9518E+00,0.8069E+00,0.6770E+00,0.5614E+00,0.4595E+00,
     +0.3707E+00,0.2942E+00,0.2293E+00,0.1750E+00,0.1305E+00,0.9478E-01,
     +0.6675E-01,0.4538E-01,0.2960E-01,0.1838E-01,0.1074E-01,0.5818E-02,
     +0.3842E-02,0.2499E-02,0.1596E-02,0.9956E-03,0.6034E-03,0.3527E-03,
     +0.1970E-03,0.1038E-03,0.5076E-04,0.2242E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,4),I=1,104) /
     +0.1935E+02,0.1865E+02,0.1797E+02,0.1732E+02,0.1668E+02,0.1607E+02,
     +0.1548E+02,0.1490E+02,0.1435E+02,0.1381E+02,0.1329E+02,0.1279E+02,
     +0.1231E+02,0.1184E+02,0.1139E+02,0.1095E+02,0.1053E+02,0.1012E+02,
     +0.9730E+01,0.9351E+01,0.8985E+01,0.8631E+01,0.8290E+01,0.7961E+01,
     +0.7643E+01,0.7336E+01,0.7041E+01,0.6755E+01,0.6480E+01,0.6215E+01,
     +0.5959E+01,0.5712E+01,0.5473E+01,0.5243E+01,0.5022E+01,0.4808E+01,
     +0.4601E+01,0.4402E+01,0.4210E+01,0.4024E+01,0.3845E+01,0.3672E+01,
     +0.3504E+01,0.3343E+01,0.3186E+01,0.3035E+01,0.2889E+01,0.2747E+01,
     +0.2610E+01,0.2477E+01,0.2348E+01,0.2223E+01,0.2101E+01,0.1983E+01,
     +0.1869E+01,0.1758E+01,0.1650E+01,0.1545E+01,0.1444E+01,0.1345E+01,
     +0.1250E+01,0.1157E+01,0.1068E+01,0.9811E+00,0.8978E+00,0.8178E+00,
     +0.7412E+00,0.6680E+00,0.5985E+00,0.5328E+00,0.4709E+00,0.4131E+00,
     +0.3594E+00,0.3100E+00,0.2648E+00,0.2239E+00,0.1872E+00,0.1547E+00,
     +0.1260E+00,0.1012E+00,0.7978E-01,0.6163E-01,0.4643E-01,0.3391E-01,
     +0.2383E-01,0.1594E-01,0.1001E-01,0.5800E-02,0.3022E-02,0.1371E-02,
     +0.7814E-03,0.4280E-03,0.2242E-03,0.1118E-03,0.5285E-04,0.2353E-04,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,5),I=1,104) /
     +0.3696E+01,0.3570E+01,0.3448E+01,0.3330E+01,0.3216E+01,0.3105E+01,
     +0.2998E+01,0.2894E+01,0.2794E+01,0.2697E+01,0.2603E+01,0.2513E+01,
     +0.2425E+01,0.2340E+01,0.2258E+01,0.2179E+01,0.2102E+01,0.2028E+01,
     +0.1957E+01,0.1888E+01,0.1821E+01,0.1756E+01,0.1694E+01,0.1634E+01,
     +0.1576E+01,0.1519E+01,0.1465E+01,0.1413E+01,0.1362E+01,0.1313E+01,
     +0.1265E+01,0.1220E+01,0.1175E+01,0.1132E+01,0.1091E+01,0.1051E+01,
     +0.1012E+01,0.9742E+00,0.9377E+00,0.9024E+00,0.8680E+00,0.8347E+00,
     +0.8023E+00,0.7707E+00,0.7401E+00,0.7102E+00,0.6810E+00,0.6526E+00,
     +0.6248E+00,0.5976E+00,0.5710E+00,0.5449E+00,0.5193E+00,0.4942E+00,
     +0.4695E+00,0.4452E+00,0.4214E+00,0.3979E+00,0.3748E+00,0.3521E+00,
     +0.3298E+00,0.3079E+00,0.2865E+00,0.2655E+00,0.2449E+00,0.2250E+00,
     +0.2056E+00,0.1868E+00,0.1688E+00,0.1516E+00,0.1351E+00,0.1196E+00,
     +0.1051E+00,0.9151E-01,0.7900E-01,0.6755E-01,0.5716E-01,0.4783E-01,
     +0.3952E-01,0.3219E-01,0.2578E-01,0.2024E-01,0.1549E-01,0.1150E-01,
     +0.8200E-02,0.5559E-02,0.3530E-02,0.2060E-02,0.1077E-02,0.4868E-03,
     +0.2757E-03,0.1494E-03,0.7701E-04,0.3756E-04,0.1721E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,6),I=1,104) /
     +0.3522E+01,0.3396E+01,0.3274E+01,0.3156E+01,0.3042E+01,0.2931E+01,
     +0.2824E+01,0.2720E+01,0.2620E+01,0.2524E+01,0.2430E+01,0.2339E+01,
     +0.2252E+01,0.2167E+01,0.2085E+01,0.2006E+01,0.1930E+01,0.1856E+01,
     +0.1785E+01,0.1716E+01,0.1650E+01,0.1585E+01,0.1523E+01,0.1463E+01,
     +0.1406E+01,0.1350E+01,0.1296E+01,0.1244E+01,0.1194E+01,0.1145E+01,
     +0.1099E+01,0.1053E+01,0.1010E+01,0.9678E+00,0.9272E+00,0.8880E+00,
     +0.8502E+00,0.8136E+00,0.7783E+00,0.7442E+00,0.7112E+00,0.6794E+00,
     +0.6486E+00,0.6188E+00,0.5899E+00,0.5620E+00,0.5350E+00,0.5088E+00,
     +0.4834E+00,0.4587E+00,0.4349E+00,0.4117E+00,0.3892E+00,0.3673E+00,
     +0.3461E+00,0.3255E+00,0.3054E+00,0.2860E+00,0.2671E+00,0.2488E+00,
     +0.2310E+00,0.2138E+00,0.1972E+00,0.1812E+00,0.1657E+00,0.1508E+00,
     +0.1366E+00,0.1231E+00,0.1102E+00,0.9798E-01,0.8653E-01,0.7582E-01,
     +0.6589E-01,0.5675E-01,0.4840E-01,0.4085E-01,0.3409E-01,0.2809E-01,
     +0.2282E-01,0.1826E-01,0.1435E-01,0.1104E-01,0.8283E-02,0.6025E-02,
     +0.4216E-02,0.2809E-02,0.1758E-02,0.1016E-02,0.5282E-03,0.2394E-03,
     +0.1366E-03,0.7490E-04,0.3934E-04,0.1969E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,7),I=1,104) /
     +0.3406E+01,0.3280E+01,0.3158E+01,0.3040E+01,0.2926E+01,0.2815E+01,
     +0.2708E+01,0.2605E+01,0.2505E+01,0.2408E+01,0.2314E+01,0.2224E+01,
     +0.2136E+01,0.2052E+01,0.1970E+01,0.1891E+01,0.1815E+01,0.1741E+01,
     +0.1670E+01,0.1602E+01,0.1535E+01,0.1471E+01,0.1410E+01,0.1350E+01,
     +0.1292E+01,0.1237E+01,0.1183E+01,0.1132E+01,0.1082E+01,0.1034E+01,
     +0.9874E+00,0.9427E+00,0.8996E+00,0.8581E+00,0.8181E+00,0.7795E+00,
     +0.7424E+00,0.7066E+00,0.6720E+00,0.6388E+00,0.6067E+00,0.5759E+00,
     +0.5461E+00,0.5174E+00,0.4898E+00,0.4632E+00,0.4376E+00,0.4129E+00,
     +0.3891E+00,0.3662E+00,0.3441E+00,0.3229E+00,0.3024E+00,0.2827E+00,
     +0.2638E+00,0.2456E+00,0.2282E+00,0.2114E+00,0.1953E+00,0.1799E+00,
     +0.1652E+00,0.1511E+00,0.1377E+00,0.1250E+00,0.1129E+00,0.1014E+00,
     +0.9066E-01,0.8054E-01,0.7107E-01,0.6226E-01,0.5411E-01,0.4662E-01,
     +0.3977E-01,0.3357E-01,0.2800E-01,0.2305E-01,0.1870E-01,0.1492E-01,
     +0.1169E-01,0.8972E-02,0.6726E-02,0.4909E-02,0.3476E-02,0.2376E-02,
     +0.1559E-02,0.9757E-03,0.5770E-03,0.3189E-03,0.1622E-03,0.7444E-04,
     +0.4380E-04,0.2526E-04,0.1422E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,8),I=1,104) /
     +0.3322E+01,0.3198E+01,0.3077E+01,0.2960E+01,0.2848E+01,0.2738E+01,
     +0.2633E+01,0.2531E+01,0.2432E+01,0.2336E+01,0.2244E+01,0.2155E+01,
     +0.2069E+01,0.1985E+01,0.1905E+01,0.1827E+01,0.1752E+01,0.1679E+01,
     +0.1609E+01,0.1542E+01,0.1476E+01,0.1414E+01,0.1353E+01,0.1294E+01,
     +0.1238E+01,0.1183E+01,0.1131E+01,0.1080E+01,0.1031E+01,0.9839E+00,
     +0.9386E+00,0.8948E+00,0.8527E+00,0.8122E+00,0.7731E+00,0.7355E+00,
     +0.6993E+00,0.6644E+00,0.6308E+00,0.5985E+00,0.5675E+00,0.5375E+00,
     +0.5088E+00,0.4811E+00,0.4545E+00,0.4289E+00,0.4042E+00,0.3806E+00,
     +0.3578E+00,0.3360E+00,0.3150E+00,0.2948E+00,0.2755E+00,0.2569E+00,
     +0.2391E+00,0.2220E+00,0.2057E+00,0.1901E+00,0.1751E+00,0.1609E+00,
     +0.1473E+00,0.1344E+00,0.1221E+00,0.1105E+00,0.9955E-01,0.8921E-01,
     +0.7951E-01,0.7043E-01,0.6198E-01,0.5414E-01,0.4693E-01,0.4031E-01,
     +0.3430E-01,0.2888E-01,0.2402E-01,0.1972E-01,0.1596E-01,0.1271E-01,
     +0.9934E-02,0.7608E-02,0.5693E-02,0.4150E-02,0.2935E-02,0.2006E-02,
     +0.1317E-02,0.8252E-03,0.4894E-03,0.2717E-03,0.1392E-03,0.6454E-04,
     +0.3828E-04,0.2226E-04,0.1266E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,9),I=1,104) /
     +0.1710E+01,0.1638E+01,0.1569E+01,0.1502E+01,0.1438E+01,0.1376E+01,
     +0.1316E+01,0.1259E+01,0.1203E+01,0.1150E+01,0.1099E+01,0.1049E+01,
     +0.1002E+01,0.9558E+00,0.9118E+00,0.8694E+00,0.8287E+00,0.7896E+00,
     +0.7520E+00,0.7159E+00,0.6813E+00,0.6480E+00,0.6160E+00,0.5853E+00,
     +0.5559E+00,0.5277E+00,0.5006E+00,0.4747E+00,0.4499E+00,0.4260E+00,
     +0.4033E+00,0.3814E+00,0.3605E+00,0.3406E+00,0.3215E+00,0.3032E+00,
     +0.2858E+00,0.2691E+00,0.2532E+00,0.2380E+00,0.2235E+00,0.2097E+00,
     +0.1965E+00,0.1840E+00,0.1720E+00,0.1607E+00,0.1499E+00,0.1396E+00,
     +0.1298E+00,0.1205E+00,0.1117E+00,0.1034E+00,0.9552E-01,0.8805E-01,
     +0.8098E-01,0.7431E-01,0.6802E-01,0.6210E-01,0.5653E-01,0.5129E-01,
     +0.4639E-01,0.4180E-01,0.3751E-01,0.3353E-01,0.2982E-01,0.2640E-01,
     +0.2324E-01,0.2033E-01,0.1767E-01,0.1526E-01,0.1307E-01,0.1110E-01,
     +0.9335E-02,0.7772E-02,0.6398E-02,0.5202E-02,0.4170E-02,0.3292E-02,
     +0.2555E-02,0.1944E-02,0.1448E-02,0.1053E-02,0.7446E-03,0.5102E-03,
     +0.3372E-03,0.2137E-03,0.1288E-03,0.7320E-04,0.3867E-04,0.1864E-04,
     +0.1136E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,1),I=1,104) /
     +0.3474E-01,0.3612E-01,0.3756E-01,0.3905E-01,0.4060E-01,0.4221E-01,
     +0.4388E-01,0.4562E-01,0.4743E-01,0.4931E-01,0.5126E-01,0.5328E-01,
     +0.5539E-01,0.5757E-01,0.5984E-01,0.6220E-01,0.6464E-01,0.6719E-01,
     +0.6982E-01,0.7256E-01,0.7541E-01,0.7836E-01,0.8142E-01,0.8460E-01,
     +0.8789E-01,0.9131E-01,0.9486E-01,0.9854E-01,0.1024E+00,0.1063E+00,
     +0.1104E+00,0.1147E+00,0.1191E+00,0.1236E+00,0.1283E+00,0.1332E+00,
     +0.1383E+00,0.1435E+00,0.1490E+00,0.1546E+00,0.1604E+00,0.1664E+00,
     +0.1726E+00,0.1790E+00,0.1856E+00,0.1924E+00,0.1994E+00,0.2066E+00,
     +0.2141E+00,0.2218E+00,0.2296E+00,0.2377E+00,0.2460E+00,0.2545E+00,
     +0.2633E+00,0.2721E+00,0.2812E+00,0.2904E+00,0.2998E+00,0.3093E+00,
     +0.3188E+00,0.3285E+00,0.3381E+00,0.3476E+00,0.3570E+00,0.3663E+00,
     +0.3752E+00,0.3838E+00,0.3918E+00,0.3992E+00,0.4057E+00,0.4113E+00,
     +0.4156E+00,0.4185E+00,0.4197E+00,0.4189E+00,0.4158E+00,0.4101E+00,
     +0.4015E+00,0.3897E+00,0.3744E+00,0.3555E+00,0.3329E+00,0.3065E+00,
     +0.2767E+00,0.2438E+00,0.2085E+00,0.1719E+00,0.1353E+00,0.1003E+00,
     +0.8070E-01,0.6370E-01,0.4921E-01,0.3710E-01,0.2719E-01,0.1927E-01,
     +0.1312E-01,0.8507E-02,0.5181E-02,0.2909E-02,0.1460E-02,0.6213E-03,
     +0.2024E-03,0.3905E-04/
      DATA (XQDUM (I,7,2),I=1,104) /
     +0.1987E-01,0.2066E-01,0.2148E-01,0.2233E-01,0.2321E-01,0.2412E-01,
     +0.2507E-01,0.2606E-01,0.2709E-01,0.2815E-01,0.2926E-01,0.3041E-01,
     +0.3160E-01,0.3283E-01,0.3412E-01,0.3545E-01,0.3683E-01,0.3826E-01,
     +0.3975E-01,0.4129E-01,0.4289E-01,0.4454E-01,0.4626E-01,0.4804E-01,
     +0.4988E-01,0.5179E-01,0.5377E-01,0.5582E-01,0.5794E-01,0.6014E-01,
     +0.6241E-01,0.6476E-01,0.6719E-01,0.6970E-01,0.7229E-01,0.7497E-01,
     +0.7774E-01,0.8060E-01,0.8354E-01,0.8658E-01,0.8971E-01,0.9293E-01,
     +0.9624E-01,0.9965E-01,0.1032E+00,0.1068E+00,0.1104E+00,0.1142E+00,
     +0.1181E+00,0.1220E+00,0.1261E+00,0.1302E+00,0.1344E+00,0.1386E+00,
     +0.1429E+00,0.1472E+00,0.1516E+00,0.1560E+00,0.1603E+00,0.1647E+00,
     +0.1690E+00,0.1732E+00,0.1773E+00,0.1812E+00,0.1850E+00,0.1885E+00,
     +0.1917E+00,0.1945E+00,0.1968E+00,0.1987E+00,0.1999E+00,0.2003E+00,
     +0.2000E+00,0.1987E+00,0.1964E+00,0.1928E+00,0.1880E+00,0.1818E+00,
     +0.1741E+00,0.1650E+00,0.1542E+00,0.1420E+00,0.1285E+00,0.1138E+00,
     +0.9823E-01,0.8223E-01,0.6630E-01,0.5102E-01,0.3702E-01,0.2488E-01,
     +0.1868E-01,0.1370E-01,0.9780E-02,0.6770E-02,0.4521E-02,0.2894E-02,
     +0.1760E-02,0.1005E-02,0.5297E-03,0.2512E-03,0.1030E-03,0.3409E-04,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,3),I=1,104) /
     +0.1800E+03,0.1717E+03,0.1638E+03,0.1563E+03,0.1490E+03,0.1420E+03,
     +0.1353E+03,0.1289E+03,0.1228E+03,0.1169E+03,0.1112E+03,0.1058E+03,
     +0.1006E+03,0.9564E+02,0.9088E+02,0.8633E+02,0.8197E+02,0.7780E+02,
     +0.7381E+02,0.7000E+02,0.6635E+02,0.6287E+02,0.5954E+02,0.5636E+02,
     +0.5333E+02,0.5043E+02,0.4767E+02,0.4503E+02,0.4252E+02,0.4013E+02,
     +0.3784E+02,0.3567E+02,0.3360E+02,0.3163E+02,0.2976E+02,0.2797E+02,
     +0.2628E+02,0.2467E+02,0.2314E+02,0.2169E+02,0.2031E+02,0.1901E+02,
     +0.1777E+02,0.1660E+02,0.1549E+02,0.1444E+02,0.1344E+02,0.1250E+02,
     +0.1161E+02,0.1077E+02,0.9981E+01,0.9235E+01,0.8531E+01,0.7868E+01,
     +0.7244E+01,0.6657E+01,0.6106E+01,0.5588E+01,0.5103E+01,0.4648E+01,
     +0.4223E+01,0.3825E+01,0.3454E+01,0.3108E+01,0.2787E+01,0.2488E+01,
     +0.2212E+01,0.1957E+01,0.1722E+01,0.1507E+01,0.1310E+01,0.1131E+01,
     +0.9688E+00,0.8229E+00,0.6924E+00,0.5766E+00,0.4747E+00,0.3858E+00,
     +0.3091E+00,0.2438E+00,0.1888E+00,0.1434E+00,0.1064E+00,0.7698E-01,
     +0.5405E-01,0.3667E-01,0.2388E-01,0.1482E-01,0.8655E-02,0.4684E-02,
     +0.3089E-02,0.2005E-02,0.1276E-02,0.7924E-03,0.4773E-03,0.2768E-03,
     +0.1532E-03,0.7978E-04,0.3843E-04,0.1668E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,4),I=1,104) /
     +0.2683E+02,0.2577E+02,0.2476E+02,0.2377E+02,0.2283E+02,0.2191E+02,
     +0.2103E+02,0.2019E+02,0.1937E+02,0.1858E+02,0.1782E+02,0.1709E+02,
     +0.1638E+02,0.1570E+02,0.1505E+02,0.1442E+02,0.1381E+02,0.1323E+02,
     +0.1266E+02,0.1212E+02,0.1160E+02,0.1110E+02,0.1062E+02,0.1016E+02,
     +0.9713E+01,0.9285E+01,0.8873E+01,0.8478E+01,0.8098E+01,0.7732E+01,
     +0.7381E+01,0.7044E+01,0.6720E+01,0.6409E+01,0.6110E+01,0.5822E+01,
     +0.5546E+01,0.5281E+01,0.5027E+01,0.4782E+01,0.4546E+01,0.4320E+01,
     +0.4103E+01,0.3894E+01,0.3693E+01,0.3500E+01,0.3314E+01,0.3135E+01,
     +0.2963E+01,0.2797E+01,0.2637E+01,0.2483E+01,0.2335E+01,0.2192E+01,
     +0.2054E+01,0.1921E+01,0.1794E+01,0.1670E+01,0.1552E+01,0.1438E+01,
     +0.1328E+01,0.1222E+01,0.1121E+01,0.1025E+01,0.9322E+00,0.8442E+00,
     +0.7606E+00,0.6814E+00,0.6069E+00,0.5369E+00,0.4717E+00,0.4112E+00,
     +0.3556E+00,0.3047E+00,0.2586E+00,0.2172E+00,0.1803E+00,0.1479E+00,
     +0.1196E+00,0.9521E-01,0.7444E-01,0.5697E-01,0.4249E-01,0.3071E-01,
     +0.2133E-01,0.1410E-01,0.8743E-02,0.4997E-02,0.2569E-02,0.1150E-02,
     +0.6510E-03,0.3545E-03,0.1849E-03,0.9204E-04,0.4351E-04,0.1944E-04,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,5),I=1,104) /
     +0.4934E+01,0.4749E+01,0.4571E+01,0.4399E+01,0.4232E+01,0.4072E+01,
     +0.3917E+01,0.3768E+01,0.3624E+01,0.3485E+01,0.3351E+01,0.3222E+01,
     +0.3098E+01,0.2978E+01,0.2862E+01,0.2751E+01,0.2643E+01,0.2540E+01,
     +0.2440E+01,0.2345E+01,0.2252E+01,0.2163E+01,0.2078E+01,0.1995E+01,
     +0.1916E+01,0.1839E+01,0.1766E+01,0.1695E+01,0.1627E+01,0.1561E+01,
     +0.1498E+01,0.1437E+01,0.1378E+01,0.1322E+01,0.1268E+01,0.1215E+01,
     +0.1165E+01,0.1116E+01,0.1069E+01,0.1024E+01,0.9802E+00,0.9379E+00,
     +0.8971E+00,0.8577E+00,0.8195E+00,0.7825E+00,0.7467E+00,0.7120E+00,
     +0.6783E+00,0.6455E+00,0.6137E+00,0.5827E+00,0.5526E+00,0.5232E+00,
     +0.4946E+00,0.4667E+00,0.4395E+00,0.4129E+00,0.3870E+00,0.3617E+00,
     +0.3371E+00,0.3131E+00,0.2898E+00,0.2672E+00,0.2453E+00,0.2241E+00,
     +0.2037E+00,0.1842E+00,0.1656E+00,0.1479E+00,0.1311E+00,0.1155E+00,
     +0.1009E+00,0.8737E-01,0.7499E-01,0.6375E-01,0.5362E-01,0.4458E-01,
     +0.3659E-01,0.2959E-01,0.2351E-01,0.1830E-01,0.1388E-01,0.1020E-01,
     +0.7191E-02,0.4817E-02,0.3019E-02,0.1738E-02,0.8950E-03,0.3984E-03,
     +0.2235E-03,0.1200E-03,0.6142E-04,0.2976E-04,0.1357E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,6),I=1,104) /
     +0.4760E+01,0.4575E+01,0.4397E+01,0.4225E+01,0.4058E+01,0.3898E+01,
     +0.3744E+01,0.3594E+01,0.3450E+01,0.3312E+01,0.3178E+01,0.3049E+01,
     +0.2925E+01,0.2805E+01,0.2690E+01,0.2579E+01,0.2471E+01,0.2368E+01,
     +0.2269E+01,0.2173E+01,0.2081E+01,0.1993E+01,0.1908E+01,0.1826E+01,
     +0.1747E+01,0.1671E+01,0.1598E+01,0.1527E+01,0.1460E+01,0.1395E+01,
     +0.1332E+01,0.1272E+01,0.1214E+01,0.1159E+01,0.1106E+01,0.1054E+01,
     +0.1005E+01,0.9574E+00,0.9117E+00,0.8678E+00,0.8256E+00,0.7850E+00,
     +0.7459E+00,0.7083E+00,0.6721E+00,0.6372E+00,0.6036E+00,0.5713E+00,
     +0.5401E+00,0.5101E+00,0.4811E+00,0.4532E+00,0.4263E+00,0.4003E+00,
     +0.3752E+00,0.3511E+00,0.3278E+00,0.3053E+00,0.2836E+00,0.2628E+00,
     +0.2427E+00,0.2235E+00,0.2050E+00,0.1873E+00,0.1703E+00,0.1542E+00,
     +0.1389E+00,0.1244E+00,0.1107E+00,0.9793E-01,0.8598E-01,0.7490E-01,
     +0.6470E-01,0.5538E-01,0.4694E-01,0.3936E-01,0.3263E-01,0.2670E-01,
     +0.2154E-01,0.1710E-01,0.1332E-01,0.1016E-01,0.7551E-02,0.5436E-02,
     +0.3762E-02,0.2477E-02,0.1532E-02,0.8731E-03,0.4482E-03,0.2005E-03,
     +0.1135E-03,0.6191E-04,0.3236E-04,0.1616E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,7),I=1,104) /
     +0.4644E+01,0.4459E+01,0.4281E+01,0.4109E+01,0.3943E+01,0.3782E+01,
     +0.3628E+01,0.3479E+01,0.3335E+01,0.3196E+01,0.3063E+01,0.2934E+01,
     +0.2810E+01,0.2690E+01,0.2575E+01,0.2464E+01,0.2357E+01,0.2254E+01,
     +0.2155E+01,0.2059E+01,0.1968E+01,0.1879E+01,0.1794E+01,0.1712E+01,
     +0.1634E+01,0.1558E+01,0.1486E+01,0.1416E+01,0.1348E+01,0.1284E+01,
     +0.1222E+01,0.1162E+01,0.1105E+01,0.1050E+01,0.9975E+00,0.9468E+00,
     +0.8982E+00,0.8515E+00,0.8068E+00,0.7638E+00,0.7226E+00,0.6830E+00,
     +0.6451E+00,0.6087E+00,0.5738E+00,0.5403E+00,0.5082E+00,0.4775E+00,
     +0.4480E+00,0.4198E+00,0.3927E+00,0.3668E+00,0.3420E+00,0.3183E+00,
     +0.2956E+00,0.2740E+00,0.2533E+00,0.2335E+00,0.2147E+00,0.1968E+00,
     +0.1798E+00,0.1637E+00,0.1484E+00,0.1340E+00,0.1204E+00,0.1076E+00,
     +0.9568E-01,0.8454E-01,0.7420E-01,0.6464E-01,0.5587E-01,0.4785E-01,
     +0.4059E-01,0.3406E-01,0.2824E-01,0.2311E-01,0.1863E-01,0.1477E-01,
     +0.1150E-01,0.8770E-02,0.6531E-02,0.4737E-02,0.3332E-02,0.2263E-02,
     +0.1476E-02,0.9178E-03,0.5396E-03,0.2966E-03,0.1501E-03,0.6858E-04,
     +0.4025E-04,0.2315E-04,0.1300E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,8),I=1,104) /
     +0.4562E+01,0.4378E+01,0.4201E+01,0.4031E+01,0.3866E+01,0.3707E+01,
     +0.3554E+01,0.3406E+01,0.3263E+01,0.3126E+01,0.2994E+01,0.2866E+01,
     +0.2743E+01,0.2624E+01,0.2510E+01,0.2401E+01,0.2295E+01,0.2193E+01,
     +0.2095E+01,0.2001E+01,0.1910E+01,0.1822E+01,0.1738E+01,0.1658E+01,
     +0.1580E+01,0.1505E+01,0.1434E+01,0.1365E+01,0.1299E+01,0.1235E+01,
     +0.1174E+01,0.1115E+01,0.1059E+01,0.1005E+01,0.9534E+00,0.9037E+00,
     +0.8561E+00,0.8104E+00,0.7665E+00,0.7245E+00,0.6843E+00,0.6457E+00,
     +0.6087E+00,0.5733E+00,0.5394E+00,0.5070E+00,0.4759E+00,0.4462E+00,
     +0.4178E+00,0.3906E+00,0.3646E+00,0.3398E+00,0.3161E+00,0.2935E+00,
     +0.2719E+00,0.2514E+00,0.2318E+00,0.2132E+00,0.1956E+00,0.1788E+00,
     +0.1629E+00,0.1479E+00,0.1338E+00,0.1204E+00,0.1079E+00,0.9621E-01,
     +0.8530E-01,0.7516E-01,0.6579E-01,0.5716E-01,0.4926E-01,0.4209E-01,
     +0.3560E-01,0.2980E-01,0.2465E-01,0.2012E-01,0.1618E-01,0.1280E-01,
     +0.9946E-02,0.7570E-02,0.5629E-02,0.4078E-02,0.2866E-02,0.1947E-02,
     +0.1270E-02,0.7915E-03,0.4668E-03,0.2578E-03,0.1315E-03,0.6065E-04,
     +0.3587E-04,0.2080E-04,0.1178E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,9),I=1,104) /
     +0.2994E+01,0.2862E+01,0.2735E+01,0.2613E+01,0.2496E+01,0.2383E+01,
     +0.2275E+01,0.2171E+01,0.2070E+01,0.1974E+01,0.1882E+01,0.1793E+01,
     +0.1708E+01,0.1626E+01,0.1547E+01,0.1472E+01,0.1400E+01,0.1331E+01,
     +0.1264E+01,0.1200E+01,0.1140E+01,0.1081E+01,0.1025E+01,0.9717E+00,
     +0.9205E+00,0.8715E+00,0.8247E+00,0.7799E+00,0.7371E+00,0.6962E+00,
     +0.6571E+00,0.6199E+00,0.5843E+00,0.5504E+00,0.5180E+00,0.4872E+00,
     +0.4578E+00,0.4298E+00,0.4032E+00,0.3778E+00,0.3537E+00,0.3308E+00,
     +0.3091E+00,0.2884E+00,0.2688E+00,0.2502E+00,0.2326E+00,0.2159E+00,
     +0.2001E+00,0.1851E+00,0.1710E+00,0.1577E+00,0.1451E+00,0.1332E+00,
     +0.1221E+00,0.1116E+00,0.1017E+00,0.9248E-01,0.8383E-01,0.7575E-01,
     +0.6821E-01,0.6120E-01,0.5468E-01,0.4865E-01,0.4308E-01,0.3795E-01,
     +0.3324E-01,0.2895E-01,0.2504E-01,0.2151E-01,0.1833E-01,0.1548E-01,
     +0.1296E-01,0.1073E-01,0.8788E-02,0.7106E-02,0.5667E-02,0.4449E-02,
     +0.3434E-02,0.2600E-02,0.1926E-02,0.1393E-02,0.9803E-03,0.6685E-03,
     +0.4397E-03,0.2773E-03,0.1664E-03,0.9411E-04,0.4946E-04,0.2369E-04,
     +0.1437E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,1),I=1,104) /
     +0.3633E-01,0.3778E-01,0.3927E-01,0.4083E-01,0.4245E-01,0.4413E-01,
     +0.4587E-01,0.4768E-01,0.4956E-01,0.5152E-01,0.5355E-01,0.5566E-01,
     +0.5785E-01,0.6012E-01,0.6248E-01,0.6493E-01,0.6748E-01,0.7012E-01,
     +0.7286E-01,0.7570E-01,0.7865E-01,0.8171E-01,0.8488E-01,0.8818E-01,
     +0.9159E-01,0.9513E-01,0.9880E-01,0.1026E+00,0.1065E+00,0.1106E+00,
     +0.1148E+00,0.1192E+00,0.1238E+00,0.1285E+00,0.1333E+00,0.1383E+00,
     +0.1435E+00,0.1489E+00,0.1544E+00,0.1602E+00,0.1661E+00,0.1722E+00,
     +0.1785E+00,0.1850E+00,0.1917E+00,0.1986E+00,0.2057E+00,0.2130E+00,
     +0.2205E+00,0.2282E+00,0.2361E+00,0.2442E+00,0.2525E+00,0.2609E+00,
     +0.2696E+00,0.2783E+00,0.2872E+00,0.2963E+00,0.3054E+00,0.3145E+00,
     +0.3237E+00,0.3329E+00,0.3420E+00,0.3510E+00,0.3598E+00,0.3683E+00,
     +0.3764E+00,0.3840E+00,0.3910E+00,0.3972E+00,0.4025E+00,0.4067E+00,
     +0.4095E+00,0.4109E+00,0.4104E+00,0.4078E+00,0.4030E+00,0.3955E+00,
     +0.3852E+00,0.3719E+00,0.3552E+00,0.3351E+00,0.3116E+00,0.2848E+00,
     +0.2550E+00,0.2227E+00,0.1886E+00,0.1539E+00,0.1197E+00,0.8753E-01,
     +0.6980E-01,0.5459E-01,0.4177E-01,0.3118E-01,0.2261E-01,0.1585E-01,
     +0.1067E-01,0.6825E-02,0.4098E-02,0.2263E-02,0.1115E-02,0.4638E-03,
     +0.1467E-03,0.2712E-04/
      DATA (XQDUM (I,8,2),I=1,104) /
     +0.2077E-01,0.2159E-01,0.2244E-01,0.2333E-01,0.2425E-01,0.2520E-01,
     +0.2619E-01,0.2722E-01,0.2828E-01,0.2939E-01,0.3054E-01,0.3173E-01,
     +0.3297E-01,0.3425E-01,0.3558E-01,0.3696E-01,0.3839E-01,0.3988E-01,
     +0.4142E-01,0.4301E-01,0.4466E-01,0.4638E-01,0.4815E-01,0.4999E-01,
     +0.5189E-01,0.5386E-01,0.5590E-01,0.5801E-01,0.6019E-01,0.6245E-01,
     +0.6478E-01,0.6719E-01,0.6968E-01,0.7225E-01,0.7490E-01,0.7763E-01,
     +0.8046E-01,0.8336E-01,0.8636E-01,0.8944E-01,0.9261E-01,0.9587E-01,
     +0.9922E-01,0.1027E+00,0.1062E+00,0.1098E+00,0.1135E+00,0.1173E+00,
     +0.1211E+00,0.1250E+00,0.1290E+00,0.1331E+00,0.1372E+00,0.1414E+00,
     +0.1455E+00,0.1498E+00,0.1540E+00,0.1582E+00,0.1623E+00,0.1664E+00,
     +0.1705E+00,0.1744E+00,0.1781E+00,0.1817E+00,0.1850E+00,0.1881E+00,
     +0.1908E+00,0.1930E+00,0.1948E+00,0.1960E+00,0.1965E+00,0.1963E+00,
     +0.1952E+00,0.1932E+00,0.1901E+00,0.1858E+00,0.1803E+00,0.1735E+00,
     +0.1652E+00,0.1556E+00,0.1446E+00,0.1322E+00,0.1187E+00,0.1043E+00,
     +0.8931E-01,0.7408E-01,0.5913E-01,0.4500E-01,0.3225E-01,0.2137E-01,
     +0.1590E-01,0.1155E-01,0.8166E-02,0.5595E-02,0.3697E-02,0.2340E-02,
     +0.1406E-02,0.7920E-03,0.4113E-03,0.1919E-03,0.7720E-04,0.2496E-04,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,3),I=1,104) /
     +0.2142E+03,0.2039E+03,0.1940E+03,0.1845E+03,0.1754E+03,0.1667E+03,
     +0.1584E+03,0.1505E+03,0.1429E+03,0.1356E+03,0.1287E+03,0.1221E+03,
     +0.1158E+03,0.1097E+03,0.1039E+03,0.9843E+02,0.9318E+02,0.8817E+02,
     +0.8339E+02,0.7883E+02,0.7449E+02,0.7035E+02,0.6642E+02,0.6267E+02,
     +0.5910E+02,0.5570E+02,0.5247E+02,0.4941E+02,0.4649E+02,0.4372E+02,
     +0.4109E+02,0.3859E+02,0.3622E+02,0.3397E+02,0.3184E+02,0.2982E+02,
     +0.2791E+02,0.2610E+02,0.2439E+02,0.2277E+02,0.2124E+02,0.1980E+02,
     +0.1843E+02,0.1714E+02,0.1593E+02,0.1478E+02,0.1370E+02,0.1269E+02,
     +0.1173E+02,0.1084E+02,0.9992E+01,0.9201E+01,0.8458E+01,0.7763E+01,
     +0.7111E+01,0.6502E+01,0.5933E+01,0.5401E+01,0.4905E+01,0.4444E+01,
     +0.4015E+01,0.3616E+01,0.3247E+01,0.2905E+01,0.2589E+01,0.2298E+01,
     +0.2031E+01,0.1786E+01,0.1562E+01,0.1358E+01,0.1173E+01,0.1007E+01,
     +0.8572E+00,0.7238E+00,0.6054E+00,0.5013E+00,0.4103E+00,0.3317E+00,
     +0.2645E+00,0.2076E+00,0.1601E+00,0.1211E+00,0.8959E-01,0.6462E-01,
     +0.4527E-01,0.3066E-01,0.1994E-01,0.1236E-01,0.7206E-02,0.3889E-02,
     +0.2557E-02,0.1654E-02,0.1048E-02,0.6471E-03,0.3872E-03,0.2227E-03,
     +0.1220E-03,0.6285E-04,0.2988E-04,0.1277E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,4),I=1,104) /
     +0.3457E+02,0.3312E+02,0.3173E+02,0.3039E+02,0.2910E+02,0.2786E+02,
     +0.2667E+02,0.2552E+02,0.2442E+02,0.2336E+02,0.2234E+02,0.2136E+02,
     +0.2042E+02,0.1952E+02,0.1865E+02,0.1781E+02,0.1701E+02,0.1624E+02,
     +0.1551E+02,0.1480E+02,0.1412E+02,0.1347E+02,0.1284E+02,0.1224E+02,
     +0.1167E+02,0.1112E+02,0.1059E+02,0.1008E+02,0.9598E+01,0.9133E+01,
     +0.8688E+01,0.8262E+01,0.7854E+01,0.7463E+01,0.7089E+01,0.6730E+01,
     +0.6387E+01,0.6059E+01,0.5745E+01,0.5444E+01,0.5156E+01,0.4880E+01,
     +0.4616E+01,0.4363E+01,0.4121E+01,0.3889E+01,0.3667E+01,0.3455E+01,
     +0.3251E+01,0.3056E+01,0.2869E+01,0.2690E+01,0.2518E+01,0.2354E+01,
     +0.2196E+01,0.2045E+01,0.1900E+01,0.1761E+01,0.1629E+01,0.1502E+01,
     +0.1381E+01,0.1265E+01,0.1155E+01,0.1051E+01,0.9512E+00,0.8572E+00,
     +0.7686E+00,0.6852E+00,0.6072E+00,0.5345E+00,0.4672E+00,0.4052E+00,
     +0.3486E+00,0.2971E+00,0.2508E+00,0.2095E+00,0.1729E+00,0.1409E+00,
     +0.1133E+00,0.8956E-01,0.6952E-01,0.5280E-01,0.3905E-01,0.2797E-01,
     +0.1925E-01,0.1259E-01,0.7726E-02,0.4366E-02,0.2220E-02,0.9828E-03,
     +0.5529E-03,0.2995E-03,0.1557E-03,0.7730E-04,0.3652E-04,0.1634E-04,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,5),I=1,104) /
     +0.6217E+01,0.5967E+01,0.5726E+01,0.5495E+01,0.5272E+01,0.5057E+01,
     +0.4850E+01,0.4652E+01,0.4460E+01,0.4276E+01,0.4099E+01,0.3929E+01,
     +0.3766E+01,0.3608E+01,0.3457E+01,0.3312E+01,0.3173E+01,0.3038E+01,
     +0.2910E+01,0.2786E+01,0.2667E+01,0.2553E+01,0.2443E+01,0.2338E+01,
     +0.2237E+01,0.2141E+01,0.2048E+01,0.1958E+01,0.1873E+01,0.1790E+01,
     +0.1712E+01,0.1636E+01,0.1563E+01,0.1494E+01,0.1427E+01,0.1362E+01,
     +0.1301E+01,0.1242E+01,0.1185E+01,0.1130E+01,0.1077E+01,0.1027E+01,
     +0.9783E+00,0.9315E+00,0.8864E+00,0.8429E+00,0.8011E+00,0.7607E+00,
     +0.7217E+00,0.6840E+00,0.6476E+00,0.6123E+00,0.5782E+00,0.5452E+00,
     +0.5132E+00,0.4822E+00,0.4522E+00,0.4230E+00,0.3948E+00,0.3674E+00,
     +0.3409E+00,0.3153E+00,0.2906E+00,0.2667E+00,0.2438E+00,0.2218E+00,
     +0.2007E+00,0.1807E+00,0.1617E+00,0.1438E+00,0.1269E+00,0.1113E+00,
     +0.9674E-01,0.8340E-01,0.7125E-01,0.6027E-01,0.5043E-01,0.4170E-01,
     +0.3403E-01,0.2735E-01,0.2159E-01,0.1668E-01,0.1255E-01,0.9139E-02,
     +0.6385E-02,0.4233E-02,0.2624E-02,0.1492E-02,0.7587E-03,0.3333E-03,
     +0.1855E-03,0.9887E-04,0.5024E-04,0.2421E-04,0.1099E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,6),I=1,104) /
     +0.6043E+01,0.5793E+01,0.5552E+01,0.5321E+01,0.5098E+01,0.4883E+01,
     +0.4677E+01,0.4478E+01,0.4287E+01,0.4103E+01,0.3927E+01,0.3757E+01,
     +0.3593E+01,0.3436E+01,0.3285E+01,0.3140E+01,0.3001E+01,0.2867E+01,
     +0.2739E+01,0.2615E+01,0.2497E+01,0.2383E+01,0.2274E+01,0.2169E+01,
     +0.2069E+01,0.1973E+01,0.1880E+01,0.1792E+01,0.1707E+01,0.1625E+01,
     +0.1547E+01,0.1472E+01,0.1401E+01,0.1332E+01,0.1266E+01,0.1203E+01,
     +0.1142E+01,0.1085E+01,0.1029E+01,0.9759E+00,0.9249E+00,0.8761E+00,
     +0.8293E+00,0.7844E+00,0.7414E+00,0.7002E+00,0.6607E+00,0.6228E+00,
     +0.5864E+00,0.5516E+00,0.5181E+00,0.4860E+00,0.4553E+00,0.4257E+00,
     +0.3974E+00,0.3702E+00,0.3441E+00,0.3192E+00,0.2952E+00,0.2723E+00,
     +0.2504E+00,0.2295E+00,0.2096E+00,0.1906E+00,0.1726E+00,0.1555E+00,
     +0.1394E+00,0.1243E+00,0.1101E+00,0.9691E-01,0.8467E-01,0.7339E-01,
     +0.6308E-01,0.5372E-01,0.4530E-01,0.3778E-01,0.3114E-01,0.2533E-01,
     +0.2031E-01,0.1602E-01,0.1240E-01,0.9387E-02,0.6920E-02,0.4939E-02,
     +0.3386E-02,0.2208E-02,0.1351E-02,0.7616E-03,0.3866E-03,0.1710E-03,
     +0.9627E-04,0.5221E-04,0.2718E-04,0.1353E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,7),I=1,104) /
     +0.5927E+01,0.5677E+01,0.5437E+01,0.5205E+01,0.4982E+01,0.4768E+01,
     +0.4561E+01,0.4363E+01,0.4172E+01,0.3988E+01,0.3811E+01,0.3642E+01,
     +0.3478E+01,0.3321E+01,0.3171E+01,0.3026E+01,0.2887E+01,0.2753E+01,
     +0.2625E+01,0.2502E+01,0.2383E+01,0.2270E+01,0.2161E+01,0.2057E+01,
     +0.1957E+01,0.1861E+01,0.1769E+01,0.1681E+01,0.1596E+01,0.1515E+01,
     +0.1438E+01,0.1363E+01,0.1292E+01,0.1224E+01,0.1159E+01,0.1097E+01,
     +0.1037E+01,0.9799E+00,0.9253E+00,0.8731E+00,0.8232E+00,0.7755E+00,
     +0.7299E+00,0.6864E+00,0.6448E+00,0.6050E+00,0.5671E+00,0.5309E+00,
     +0.4963E+00,0.4633E+00,0.4318E+00,0.4018E+00,0.3733E+00,0.3461E+00,
     +0.3202E+00,0.2955E+00,0.2721E+00,0.2499E+00,0.2289E+00,0.2089E+00,
     +0.1901E+00,0.1723E+00,0.1556E+00,0.1398E+00,0.1251E+00,0.1114E+00,
     +0.9855E-01,0.8668E-01,0.7573E-01,0.6567E-01,0.5648E-01,0.4815E-01,
     +0.4064E-01,0.3394E-01,0.2800E-01,0.2279E-01,0.1828E-01,0.1442E-01,
     +0.1117E-01,0.8469E-02,0.6274E-02,0.4525E-02,0.3166E-02,0.2139E-02,
     +0.1387E-02,0.8583E-03,0.5020E-03,0.2746E-03,0.1384E-03,0.6290E-04,
     +0.3680E-04,0.2110E-04,0.1181E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,8),I=1,104) /
     +0.5846E+01,0.5597E+01,0.5358E+01,0.5128E+01,0.4906E+01,0.4693E+01,
     +0.4488E+01,0.4291E+01,0.4101E+01,0.3919E+01,0.3743E+01,0.3575E+01,
     +0.3413E+01,0.3257E+01,0.3107E+01,0.2963E+01,0.2825E+01,0.2693E+01,
     +0.2566E+01,0.2444E+01,0.2326E+01,0.2214E+01,0.2106E+01,0.2003E+01,
     +0.1904E+01,0.1809E+01,0.1718E+01,0.1631E+01,0.1547E+01,0.1467E+01,
     +0.1391E+01,0.1317E+01,0.1247E+01,0.1180E+01,0.1116E+01,0.1054E+01,
     +0.9957E+00,0.9396E+00,0.8859E+00,0.8347E+00,0.7858E+00,0.7391E+00,
     +0.6945E+00,0.6519E+00,0.6113E+00,0.5726E+00,0.5357E+00,0.5005E+00,
     +0.4670E+00,0.4351E+00,0.4047E+00,0.3758E+00,0.3483E+00,0.3222E+00,
     +0.2974E+00,0.2739E+00,0.2516E+00,0.2305E+00,0.2105E+00,0.1917E+00,
     +0.1740E+00,0.1573E+00,0.1417E+00,0.1270E+00,0.1133E+00,0.1006E+00,
     +0.8881E-01,0.7791E-01,0.6788E-01,0.5871E-01,0.5037E-01,0.4283E-01,
     +0.3606E-01,0.3003E-01,0.2472E-01,0.2007E-01,0.1606E-01,0.1265E-01,
     +0.9774E-02,0.7400E-02,0.5474E-02,0.3945E-02,0.2758E-02,0.1864E-02,
     +0.1210E-02,0.7502E-03,0.4404E-03,0.2421E-03,0.1229E-03,0.5640E-04,
     +0.3324E-04,0.1921E-04,0.1084E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,9),I=1,104) /
     +0.4317E+01,0.4119E+01,0.3929E+01,0.3746E+01,0.3571E+01,0.3403E+01,
     +0.3242E+01,0.3087E+01,0.2939E+01,0.2797E+01,0.2660E+01,0.2530E+01,
     +0.2405E+01,0.2285E+01,0.2170E+01,0.2060E+01,0.1955E+01,0.1854E+01,
     +0.1758E+01,0.1666E+01,0.1578E+01,0.1494E+01,0.1413E+01,0.1337E+01,
     +0.1263E+01,0.1193E+01,0.1127E+01,0.1063E+01,0.1002E+01,0.9445E+00,
     +0.8894E+00,0.8370E+00,0.7870E+00,0.7395E+00,0.6943E+00,0.6513E+00,
     +0.6105E+00,0.5717E+00,0.5349E+00,0.5000E+00,0.4668E+00,0.4354E+00,
     +0.4056E+00,0.3775E+00,0.3508E+00,0.3256E+00,0.3018E+00,0.2793E+00,
     +0.2581E+00,0.2381E+00,0.2192E+00,0.2015E+00,0.1848E+00,0.1692E+00,
     +0.1545E+00,0.1408E+00,0.1279E+00,0.1159E+00,0.1047E+00,0.9424E-01,
     +0.8455E-01,0.7558E-01,0.6728E-01,0.5962E-01,0.5259E-01,0.4615E-01,
     +0.4027E-01,0.3492E-01,0.3008E-01,0.2573E-01,0.2183E-01,0.1836E-01,
     +0.1530E-01,0.1262E-01,0.1029E-01,0.8282E-02,0.6575E-02,0.5139E-02,
     +0.3949E-02,0.2977E-02,0.2196E-02,0.1581E-02,0.1108E-02,0.7524E-03,
     +0.4928E-03,0.3095E-03,0.1850E-03,0.1041E-03,0.5444E-04,0.2590E-04,
     +0.1564E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,1),I=1,104) /
     +0.3782E-01,0.3931E-01,0.4087E-01,0.4248E-01,0.4416E-01,0.4590E-01,
     +0.4771E-01,0.4959E-01,0.5154E-01,0.5357E-01,0.5567E-01,0.5786E-01,
     +0.6013E-01,0.6248E-01,0.6492E-01,0.6746E-01,0.7009E-01,0.7282E-01,
     +0.7565E-01,0.7859E-01,0.8163E-01,0.8479E-01,0.8806E-01,0.9146E-01,
     +0.9498E-01,0.9862E-01,0.1024E+00,0.1063E+00,0.1104E+00,0.1146E+00,
     +0.1189E+00,0.1234E+00,0.1280E+00,0.1328E+00,0.1378E+00,0.1429E+00,
     +0.1482E+00,0.1537E+00,0.1594E+00,0.1652E+00,0.1712E+00,0.1774E+00,
     +0.1838E+00,0.1904E+00,0.1972E+00,0.2041E+00,0.2113E+00,0.2186E+00,
     +0.2262E+00,0.2339E+00,0.2418E+00,0.2498E+00,0.2580E+00,0.2664E+00,
     +0.2749E+00,0.2835E+00,0.2923E+00,0.3011E+00,0.3099E+00,0.3188E+00,
     +0.3276E+00,0.3364E+00,0.3450E+00,0.3534E+00,0.3616E+00,0.3694E+00,
     +0.3767E+00,0.3834E+00,0.3895E+00,0.3946E+00,0.3988E+00,0.4018E+00,
     +0.4033E+00,0.4033E+00,0.4014E+00,0.3974E+00,0.3911E+00,0.3822E+00,
     +0.3705E+00,0.3558E+00,0.3381E+00,0.3171E+00,0.2931E+00,0.2661E+00,
     +0.2365E+00,0.2049E+00,0.1721E+00,0.1391E+00,0.1070E+00,0.7734E-01,
     +0.6118E-01,0.4746E-01,0.3601E-01,0.2664E-01,0.1914E-01,0.1328E-01,
     +0.8843E-02,0.5593E-02,0.3315E-02,0.1805E-02,0.8741E-03,0.3564E-03,
     +0.1098E-03,0.1953E-04/
      DATA (XQDUM (I,9,2),I=1,104) /
     +0.2161E-01,0.2246E-01,0.2334E-01,0.2425E-01,0.2521E-01,0.2619E-01,
     +0.2722E-01,0.2828E-01,0.2939E-01,0.3053E-01,0.3172E-01,0.3295E-01,
     +0.3423E-01,0.3555E-01,0.3693E-01,0.3835E-01,0.3983E-01,0.4136E-01,
     +0.4295E-01,0.4459E-01,0.4629E-01,0.4806E-01,0.4988E-01,0.5177E-01,
     +0.5372E-01,0.5574E-01,0.5784E-01,0.6000E-01,0.6223E-01,0.6454E-01,
     +0.6692E-01,0.6938E-01,0.7192E-01,0.7454E-01,0.7724E-01,0.8002E-01,
     +0.8289E-01,0.8584E-01,0.8887E-01,0.9199E-01,0.9520E-01,0.9848E-01,
     +0.1019E+00,0.1053E+00,0.1088E+00,0.1125E+00,0.1161E+00,0.1199E+00,
     +0.1237E+00,0.1276E+00,0.1316E+00,0.1356E+00,0.1396E+00,0.1437E+00,
     +0.1477E+00,0.1518E+00,0.1559E+00,0.1599E+00,0.1639E+00,0.1678E+00,
     +0.1715E+00,0.1752E+00,0.1786E+00,0.1818E+00,0.1848E+00,0.1874E+00,
     +0.1896E+00,0.1914E+00,0.1926E+00,0.1932E+00,0.1932E+00,0.1924E+00,
     +0.1907E+00,0.1880E+00,0.1843E+00,0.1794E+00,0.1733E+00,0.1660E+00,
     +0.1573E+00,0.1474E+00,0.1361E+00,0.1238E+00,0.1104E+00,0.9635E-01,
     +0.8186E-01,0.6734E-01,0.5327E-01,0.4015E-01,0.2845E-01,0.1863E-01,
     +0.1375E-01,0.9900E-02,0.6937E-02,0.4710E-02,0.3082E-02,0.1931E-02,
     +0.1147E-02,0.6390E-03,0.3275E-03,0.1506E-03,0.5954E-04,0.1885E-04,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,3),I=1,104) /
     +0.2467E+03,0.2343E+03,0.2224E+03,0.2110E+03,0.2002E+03,0.1898E+03,
     +0.1799E+03,0.1705E+03,0.1615E+03,0.1529E+03,0.1447E+03,0.1369E+03,
     +0.1295E+03,0.1224E+03,0.1157E+03,0.1093E+03,0.1032E+03,0.9737E+02,
     +0.9185E+02,0.8660E+02,0.8161E+02,0.7686E+02,0.7236E+02,0.6809E+02,
     +0.6403E+02,0.6018E+02,0.5653E+02,0.5307E+02,0.4979E+02,0.4668E+02,
     +0.4374E+02,0.4096E+02,0.3832E+02,0.3583E+02,0.3348E+02,0.3126E+02,
     +0.2916E+02,0.2718E+02,0.2532E+02,0.2356E+02,0.2190E+02,0.2034E+02,
     +0.1887E+02,0.1749E+02,0.1619E+02,0.1497E+02,0.1383E+02,0.1275E+02,
     +0.1175E+02,0.1081E+02,0.9928E+01,0.9104E+01,0.8335E+01,0.7618E+01,
     +0.6949E+01,0.6326E+01,0.5747E+01,0.5209E+01,0.4709E+01,0.4247E+01,
     +0.3819E+01,0.3423E+01,0.3059E+01,0.2723E+01,0.2415E+01,0.2133E+01,
     +0.1876E+01,0.1641E+01,0.1428E+01,0.1236E+01,0.1062E+01,0.9070E+00,
     +0.7685E+00,0.6457E+00,0.5376E+00,0.4431E+00,0.3611E+00,0.2907E+00,
     +0.2309E+00,0.1805E+00,0.1388E+00,0.1047E+00,0.7725E-01,0.5560E-01,
     +0.3888E-01,0.2629E-01,0.1707E-01,0.1056E-01,0.6141E-02,0.3301E-02,
     +0.2163E-02,0.1393E-02,0.8784E-03,0.5392E-03,0.3204E-03,0.1828E-03,
     +0.9926E-04,0.5058E-04,0.2376E-04,0.1001E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,4),I=1,104) /
     +0.4241E+02,0.4055E+02,0.3876E+02,0.3704E+02,0.3539E+02,0.3380E+02,
     +0.3228E+02,0.3082E+02,0.2942E+02,0.2808E+02,0.2679E+02,0.2555E+02,
     +0.2437E+02,0.2323E+02,0.2214E+02,0.2110E+02,0.2010E+02,0.1915E+02,
     +0.1823E+02,0.1735E+02,0.1651E+02,0.1571E+02,0.1494E+02,0.1420E+02,
     +0.1350E+02,0.1283E+02,0.1218E+02,0.1157E+02,0.1098E+02,0.1042E+02,
     +0.9882E+01,0.9370E+01,0.8881E+01,0.8413E+01,0.7967E+01,0.7541E+01,
     +0.7135E+01,0.6747E+01,0.6376E+01,0.6023E+01,0.5686E+01,0.5364E+01,
     +0.5057E+01,0.4764E+01,0.4484E+01,0.4218E+01,0.3963E+01,0.3720E+01,
     +0.3489E+01,0.3268E+01,0.3057E+01,0.2855E+01,0.2663E+01,0.2480E+01,
     +0.2305E+01,0.2138E+01,0.1980E+01,0.1828E+01,0.1684E+01,0.1547E+01,
     +0.1417E+01,0.1293E+01,0.1176E+01,0.1065E+01,0.9602E+00,0.8617E+00,
     +0.7694E+00,0.6831E+00,0.6028E+00,0.5284E+00,0.4599E+00,0.3971E+00,
     +0.3401E+00,0.2886E+00,0.2424E+00,0.2015E+00,0.1656E+00,0.1343E+00,
     +0.1073E+00,0.8437E-01,0.6509E-01,0.4910E-01,0.3607E-01,0.2564E-01,
     +0.1750E-01,0.1135E-01,0.6897E-02,0.3861E-02,0.1943E-02,0.8522E-03,
     +0.4768E-03,0.2572E-03,0.1332E-03,0.6598E-04,0.3114E-04,0.1394E-04,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,5),I=1,104) /
     +0.7518E+01,0.7199E+01,0.6892E+01,0.6597E+01,0.6314E+01,0.6042E+01,
     +0.5781E+01,0.5530E+01,0.5289E+01,0.5058E+01,0.4836E+01,0.4623E+01,
     +0.4419E+01,0.4223E+01,0.4036E+01,0.3856E+01,0.3683E+01,0.3518E+01,
     +0.3359E+01,0.3207E+01,0.3062E+01,0.2923E+01,0.2789E+01,0.2661E+01,
     +0.2539E+01,0.2422E+01,0.2310E+01,0.2202E+01,0.2099E+01,0.2001E+01,
     +0.1907E+01,0.1817E+01,0.1731E+01,0.1648E+01,0.1569E+01,0.1494E+01,
     +0.1422E+01,0.1352E+01,0.1286E+01,0.1223E+01,0.1162E+01,0.1104E+01,
     +0.1048E+01,0.9943E+00,0.9429E+00,0.8936E+00,0.8462E+00,0.8007E+00,
     +0.7570E+00,0.7150E+00,0.6745E+00,0.6355E+00,0.5980E+00,0.5618E+00,
     +0.5270E+00,0.4933E+00,0.4609E+00,0.4296E+00,0.3995E+00,0.3705E+00,
     +0.3425E+00,0.3156E+00,0.2898E+00,0.2650E+00,0.2413E+00,0.2187E+00,
     +0.1972E+00,0.1768E+00,0.1576E+00,0.1396E+00,0.1228E+00,0.1072E+00,
     +0.9282E-01,0.7970E-01,0.6780E-01,0.5710E-01,0.4757E-01,0.3915E-01,
     +0.3179E-01,0.2541E-01,0.1994E-01,0.1531E-01,0.1144E-01,0.8267E-02,
     +0.5728E-02,0.3763E-02,0.2310E-02,0.1300E-02,0.6535E-03,0.2837E-03,
     +0.1568E-03,0.8303E-04,0.4195E-04,0.2011E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,6),I=1,104) /
     +0.7344E+01,0.7025E+01,0.6718E+01,0.6424E+01,0.6140E+01,0.5868E+01,
     +0.5607E+01,0.5357E+01,0.5116E+01,0.4885E+01,0.4664E+01,0.4451E+01,
     +0.4247E+01,0.4052E+01,0.3864E+01,0.3684E+01,0.3512E+01,0.3347E+01,
     +0.3189E+01,0.3037E+01,0.2892E+01,0.2753E+01,0.2620E+01,0.2493E+01,
     +0.2371E+01,0.2255E+01,0.2143E+01,0.2036E+01,0.1934E+01,0.1837E+01,
     +0.1744E+01,0.1655E+01,0.1569E+01,0.1488E+01,0.1410E+01,0.1336E+01,
     +0.1265E+01,0.1197E+01,0.1132E+01,0.1070E+01,0.1011E+01,0.9548E+00,
     +0.9009E+00,0.8494E+00,0.8002E+00,0.7532E+00,0.7083E+00,0.6654E+00,
     +0.6245E+00,0.5853E+00,0.5479E+00,0.5122E+00,0.4781E+00,0.4455E+00,
     +0.4143E+00,0.3846E+00,0.3562E+00,0.3291E+00,0.3033E+00,0.2787E+00,
     +0.2554E+00,0.2331E+00,0.2121E+00,0.1921E+00,0.1733E+00,0.1555E+00,
     +0.1389E+00,0.1233E+00,0.1088E+00,0.9536E-01,0.8297E-01,0.7162E-01,
     +0.6129E-01,0.5197E-01,0.4362E-01,0.3622E-01,0.2971E-01,0.2405E-01,
     +0.1918E-01,0.1505E-01,0.1158E-01,0.8708E-02,0.6375E-02,0.4517E-02,
     +0.3072E-02,0.1986E-02,0.1204E-02,0.6725E-03,0.3380E-03,0.1481E-03,
     +0.8291E-04,0.4476E-04,0.2322E-04,0.1153E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,7),I=1,104) /
     +0.7228E+01,0.6909E+01,0.6602E+01,0.6308E+01,0.6025E+01,0.5753E+01,
     +0.5492E+01,0.5241E+01,0.5001E+01,0.4770E+01,0.4549E+01,0.4336E+01,
     +0.4132E+01,0.3937E+01,0.3750E+01,0.3570E+01,0.3398E+01,0.3233E+01,
     +0.3075E+01,0.2924E+01,0.2779E+01,0.2641E+01,0.2508E+01,0.2381E+01,
     +0.2259E+01,0.2143E+01,0.2032E+01,0.1926E+01,0.1824E+01,0.1727E+01,
     +0.1635E+01,0.1546E+01,0.1462E+01,0.1381E+01,0.1304E+01,0.1230E+01,
     +0.1160E+01,0.1093E+01,0.1030E+01,0.9688E+00,0.9109E+00,0.8556E+00,
     +0.8030E+00,0.7528E+00,0.7051E+00,0.6596E+00,0.6164E+00,0.5752E+00,
     +0.5361E+00,0.4989E+00,0.4635E+00,0.4300E+00,0.3981E+00,0.3679E+00,
     +0.3392E+00,0.3121E+00,0.2864E+00,0.2621E+00,0.2392E+00,0.2176E+00,
     +0.1973E+00,0.1782E+00,0.1603E+00,0.1436E+00,0.1280E+00,0.1135E+00,
     +0.1000E+00,0.8764E-01,0.7626E-01,0.6587E-01,0.5643E-01,0.4791E-01,
     +0.4027E-01,0.3348E-01,0.2750E-01,0.2229E-01,0.1780E-01,0.1398E-01,
     +0.1078E-01,0.8136E-02,0.5999E-02,0.4307E-02,0.2999E-02,0.2017E-02,
     +0.1302E-02,0.8019E-03,0.4669E-03,0.2542E-03,0.1275E-03,0.5771E-04,
     +0.3366E-04,0.1924E-04,0.1073E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,8),I=1,104) /
     +0.7148E+01,0.6830E+01,0.6525E+01,0.6232E+01,0.5950E+01,0.5679E+01,
     +0.5420E+01,0.5170E+01,0.4931E+01,0.4702E+01,0.4481E+01,0.4270E+01,
     +0.4067E+01,0.3873E+01,0.3687E+01,0.3509E+01,0.3338E+01,0.3174E+01,
     +0.3017E+01,0.2867E+01,0.2723E+01,0.2585E+01,0.2454E+01,0.2328E+01,
     +0.2207E+01,0.2092E+01,0.1982E+01,0.1877E+01,0.1776E+01,0.1680E+01,
     +0.1589E+01,0.1501E+01,0.1417E+01,0.1338E+01,0.1262E+01,0.1189E+01,
     +0.1120E+01,0.1054E+01,0.9911E+00,0.9312E+00,0.8742E+00,0.8200E+00,
     +0.7683E+00,0.7192E+00,0.6724E+00,0.6280E+00,0.5858E+00,0.5457E+00,
     +0.5076E+00,0.4715E+00,0.4372E+00,0.4047E+00,0.3739E+00,0.3448E+00,
     +0.3172E+00,0.2912E+00,0.2666E+00,0.2435E+00,0.2216E+00,0.2011E+00,
     +0.1819E+00,0.1639E+00,0.1471E+00,0.1314E+00,0.1168E+00,0.1033E+00,
     +0.9085E-01,0.7939E-01,0.6891E-01,0.5936E-01,0.5072E-01,0.4295E-01,
     +0.3602E-01,0.2987E-01,0.2448E-01,0.1980E-01,0.1578E-01,0.1236E-01,
     +0.9515E-02,0.7172E-02,0.5282E-02,0.3789E-02,0.2638E-02,0.1774E-02,
     +0.1147E-02,0.7080E-03,0.4138E-03,0.2265E-03,0.1144E-03,0.5228E-04,
     +0.3071E-04,0.1768E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,9),I=1,104) /
     +0.5653E+01,0.5385E+01,0.5128E+01,0.4881E+01,0.4645E+01,0.4419E+01,
     +0.4202E+01,0.3995E+01,0.3796E+01,0.3606E+01,0.3424E+01,0.3250E+01,
     +0.3084E+01,0.2925E+01,0.2772E+01,0.2627E+01,0.2488E+01,0.2356E+01,
     +0.2229E+01,0.2109E+01,0.1993E+01,0.1883E+01,0.1779E+01,0.1679E+01,
     +0.1584E+01,0.1493E+01,0.1407E+01,0.1324E+01,0.1246E+01,0.1172E+01,
     +0.1101E+01,0.1034E+01,0.9704E+00,0.9098E+00,0.8524E+00,0.7978E+00,
     +0.7462E+00,0.6972E+00,0.6508E+00,0.6069E+00,0.5653E+00,0.5260E+00,
     +0.4889E+00,0.4539E+00,0.4208E+00,0.3896E+00,0.3602E+00,0.3325E+00,
     +0.3064E+00,0.2819E+00,0.2589E+00,0.2373E+00,0.2171E+00,0.1982E+00,
     +0.1804E+00,0.1639E+00,0.1485E+00,0.1341E+00,0.1208E+00,0.1084E+00,
     +0.9698E-01,0.8641E-01,0.7667E-01,0.6773E-01,0.5954E-01,0.5207E-01,
     +0.4527E-01,0.3913E-01,0.3359E-01,0.2862E-01,0.2420E-01,0.2028E-01,
     +0.1684E-01,0.1383E-01,0.1124E-01,0.9011E-02,0.7127E-02,0.5550E-02,
     +0.4248E-02,0.3190E-02,0.2345E-02,0.1682E-02,0.1175E-02,0.7947E-03,
     +0.5186E-03,0.3245E-03,0.1932E-03,0.1083E-03,0.5631E-04,0.2662E-04,
     +0.1599E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA XMIN/5.E-05/,XMAX/.95/
      DATA ISTEP/0/
      IF(ISTEP.EQ.0) THEN
        DO 2 I=1,IX
          ENT(I)=LOG10(XCO(I))
    2   CONTINUE
        NENT(1)=IX
        NENT(2)=IQ
        DO 3 I=1,IQ
          ENT(IX+I)=LOG10(Q2(I))
    3   CONTINUE
        ISTEP=1
      ENDIF
      IF (STRFUN(1:2) .EQ. 'UP' ) THEN
      IFUN =1
      ELSE IF (STRFUN(1:2) .EQ. 'DO') THEN
      IFUN =2
      ELSE IF (STRFUN(1:2) .EQ. 'GL') THEN
      IFUN =3
      ELSE IF (STRFUN(1:2) .EQ. 'QB') THEN
      IFUN =4
      ELSE IF (STRFUN(1:2) .EQ. 'UB') THEN
      IFUN =5
      ELSE IF (STRFUN(1:2) .EQ. 'SB') THEN
      IFUN =6
      ELSE IF (STRFUN(1:2) .EQ. 'CB') THEN
      IFUN =7
      ELSE IF (STRFUN(1:2) .EQ. 'BB') THEN
      IFUN =8
      ELSE IF (STRFUN(1:2) .EQ. 'TB') THEN
      IFUN =9
      ENDIF
      FUNC=0.
C     IF(X.GT.XMIN.AND.X.LT.XMAX) THEN
      IF(X.LT.XMAX) THEN
      ARG(1)=LOG10(X)
      ARG(2)=LOG10(QSTAR2)
      FUNC =FINT(NARG,ARG,NENT,ENT,XQDUM(1,1,IFUN))
      ENDIF
      IF (FUNC.LT.0.) FUNC=0.
      END
