/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.beans.WeakPropertyChangeListener;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;

public abstract class AbstractDrawingEditorAction
extends AbstractAction {
    protected DrawingEditor editor;
    private EventHandler eventHandler = new EventHandler();

    public AbstractDrawingEditorAction(DrawingEditor drawingEditor) {
        this.setEditor(drawingEditor);
    }

    public void setEditor(DrawingEditor drawingEditor) {
        if (this.eventHandler != null) {
            this.unregisterEventHandler();
        }
        this.editor = drawingEditor;
        if (this.eventHandler != null) {
            this.registerEventHandler();
            this.updateEnabledState();
        }
    }

    protected void updateEnabledState() {
        this.setEnabled(this.editor != null && this.editor.isEnabled());
    }

    public DrawingEditor getEditor() {
        return this.editor;
    }

    protected DrawingView getView() {
        return this.editor.getActiveView();
    }

    protected Drawing getDrawing() {
        return this.getView().getDrawing();
    }

    protected void fireUndoableEditHappened(UndoableEdit undoableEdit) {
        this.getDrawing().fireUndoableEditHappened(undoableEdit);
    }

    public void setUpdateEnabledState(boolean bl) {
        if (this.eventHandler != null != bl) {
            if (bl) {
                this.eventHandler = new EventHandler();
                this.registerEventHandler();
            } else {
                this.unregisterEventHandler();
                this.eventHandler = null;
            }
        }
        if (bl) {
            this.updateEnabledState();
        }
    }

    public boolean isUpdatEnabledState() {
        return this.eventHandler != null;
    }

    private void unregisterEventHandler() {
        if (this.editor != null) {
            this.editor.removePropertyChangeListener(this.eventHandler);
        }
    }

    private void registerEventHandler() {
        if (this.editor != null) {
            this.editor.addPropertyChangeListener(new WeakPropertyChangeListener(this.eventHandler));
        }
    }

    private class EventHandler
    implements PropertyChangeListener {
        private EventHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("enabled")) {
                AbstractDrawingEditorAction.this.updateEnabledState();
            }
        }
    }
}

