//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: volslider.cpp,v 1.1 2002/01/30 12:08:38 muse Exp $
//
//  (C) Copyright 2000 Werner Schweer (ws@seh.de)
//=========================================================

#include <math.h>
#include "../audiothread.h"
#include "volslider.h"
#include "globals.h"

//---------------------------------------------------------
//   VolSlider
//---------------------------------------------------------

VolSlider::VolSlider(QWidget* parent, AudioNode* s)
   : Slider(parent, "vol", Slider::Vertical, Slider::None, Slider::BgTrough | Slider::BgSlot)
      {
      src = s;
      connect(this, SIGNAL(valueChanged(double)), SLOT(valueChanged(double)));
      }

//---------------------------------------------------------
//   volChanged
//---------------------------------------------------------

void VolSlider::valueChanged(double val)
      {
      double vol = pow(10.0, val/20.0);
      audioThread->msgSetVolume(src, vol);
      emit volChanged(val);
      }


