//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: stkgui.cpp,v 1.1 2002/01/30 12:08:39 muse Exp $
//
//    This is a simple GUI implemented with QT for
//    stk software synthesizer.
//
//  (C) Copyright 2001 Werner Schweer (ws@seh.de)
//=========================================================

#include <unistd.h>
#include <stdlib.h>

#include <qapplication.h>
#include <qsocketnotifier.h>
#include "stkgui.h"

QString homeDir;
QString instanceName;

//---------------------------------------------------------
//   StkGui
//---------------------------------------------------------

StkGui::StkGui()
   : StkGuiBase(0, "stkgui", WType_TopLevel | WDestructiveClose),
     MidiRawIn()
      {
      QSocketNotifier* s = new QSocketNotifier(0, QSocketNotifier::Read);
      connect(s, SIGNAL(activated(int)), SLOT(readStdin(int)));
      }

//---------------------------------------------------------
//   readStdin
//---------------------------------------------------------

void StkGui::readStdin(int fd)
      {
      unsigned char buffer[128];
      int n = ::read(fd, buffer, 128);
      dataInput(buffer, n);
      }

void StkGui::sysexReceived(const unsigned char*, int)
      {
      }

void StkGui::eventReceived(int, int, int)
      {
      }

//---------------------------------------------------------
//   main
//---------------------------------------------------------

int main(int argc, char* argv[])
      {
      homeDir = argv[0];
      instanceName = argv[1];

      if (homeDir[0] != '/')
            homeDir = ".";

      QApplication app(argc, argv, true);
      QWidget* w = new StkGui;
      if (argc > 1)
            w->setCaption(instanceName);
      w->show();
      app.connect(&app, SIGNAL(lastWindowClosed()), &app, SLOT(quit()));
      qApp->exec();
      }

