//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: comment.cpp,v 1.1 2002/01/30 14:54:03 muse Exp $
//  (C) Copyright 2001 Werner Schweer (ws@seh.de)
//=========================================================

#include "comment.h"
#include "song.h"
#include "track.h"
#include <qmultilineedit.h>
#include <qlabel.h>

//---------------------------------------------------------
//   Comment
//---------------------------------------------------------

Comment::Comment(QWidget* parent, const char* name = 0)
   : CommentBase(parent, name)
      {
      }

//---------------------------------------------------------
//   textChanged
//---------------------------------------------------------

void Comment::textChanged()
      {
      setText(textentry->text());
      }

//---------------------------------------------------------
//   TrackComment
//---------------------------------------------------------

TrackComment::TrackComment(Track* t, QWidget* parent, const char* name = 0)
   : Comment(parent, name)
      {
      setCaption(tr("MusE: Track Comment"));
      track = t;
      trackId = track->sn();
      connect(song, SIGNAL(songChanged(int)), SLOT(songChanged(int)));
      textentry->setText(track->comment());
      connect(textentry, SIGNAL(textChanged()), SLOT(textChanged()));
      label1->setText(tr("Track Comment:"));
      label2->setText(track->tname());
      }

//---------------------------------------------------------
//   songChanged
//---------------------------------------------------------

void TrackComment::songChanged(int flags)
      {
      if ((flags & (SC_TRACK_INSERTED|SC_TRACK_REMOVED|SC_TRACK_MODIFIED)) == 0)
            return;
// printf("song changed %x\n", this);
      TrackList* tl = song->tracks();
      iTrack it;
      for (it = tl->begin(); it != tl->end(); ++it) {
            if ((*it)->sn() == trackId) {
                  track = *it;
                  break;
                  }
            }
      if (it == tl->end()) {
            close(true);
            return;
            }
      label2->setText(track->tname());
      if (track->comment() != textentry->text()) {
            disconnect(textentry, SIGNAL(textChanged()), this, SLOT(textChanged()));
            textentry->setText(track->comment());
            textentry->setCursorPosition(1000, 1000);
            connect(textentry, SIGNAL(textChanged()), this, SLOT(textChanged()));
            }
// printf("song changed %x    end\n", this);
      }

//---------------------------------------------------------
//   setText
//---------------------------------------------------------

void TrackComment::setText(const QString& s)
      {
      track->setComment(s);
      song->update(SC_TRACK_MODIFIED);
      }

