//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: tb1.cpp,v 1.1 2002/01/30 14:54:04 muse Exp $
//  (C) Copyright 1999 Werner Schweer (ws@seh.de)
//=========================================================

#include "config.h"
#include <assert.h>
#include <stdio.h>

#include <qlabel.h>
#include <qlayout.h>
#include "lcombo.h"
#include <qlistbox.h>
#include <qtoolbutton.h>
#include "tb1.h"
#include "globals.h"
#include "poslabel.h"
#include "pitchlabel.h"

static int rasterTable[] = {
      //------                8    4     2
      1, 4,  8, 16, 32,  64, 128, 256,  512, 1024,
      1, 6, 12, 24, 48,  96, 192, 384,  768, 1536,
      1, 9, 18, 36, 72, 144, 288, 576, 1152, 2304
      };

static const char* rasterStrings[] = {
      "Aus", "2pp", "5pp", "64T", "32T", "16T", "8T", "4T", "2T", "1T",
      "Aus", "3pp", "6pp", "64",  "32",  "16",  "8",  "4",  "2",  "1",
      "Aus", "4pp", "7pp", "64.", "32.", "16.", "8.", "4.", "2.", "1."
      };

static int quantTable[] = {
      1, 16, 32,  64, 128, 256,  512, 1024,
      1, 24, 48,  96, 192, 384,  768, 1536,
      1, 36, 72, 144, 288, 576, 1152, 2304
      };

static const char* quantStrings[] = {
      "Aus", "64T", "32T", "16T", "8T", "4T", "2T", "1T",
      "Aus", "64",  "32",  "16",  "8",  "4",  "2",  "1",
      "Aus", "64.", "32.", "16.", "8.", "4.", "2.", "1."
      };

//---------------------------------------------------------
//   genToolbar
//    solo time pitch raster quant
//---------------------------------------------------------

Toolbar1::Toolbar1(MainWindow* parent, int r=96, int q=96, bool sp=true)
   : ToolBar("tools", parent)
      {
      showPitch = sp;
      setHorizontalStretchable(true);

      solo = new QToolButton(this);
      solo->setText(tr("Solo"));
      solo->setToggleButton(true);

      //---------------------------------------------------
      //  Cursor Position
      //---------------------------------------------------

      QLabel* label = new QLabel("Cursor", this, "Cursor");
      label->setAlignment(AlignRight|AlignVCenter);
      label->setIndent(3);
      pos   = new PosLabel(this, "pos");
      if (showPitch) {
            pitch = new PitchLabel(this);
            pitch->setEnabled(false);
            }

      //---------------------------------------------------
      //  Raster, Quant.
      //---------------------------------------------------

      raster = new LabelCombo(tr("Snap"), this);
      quant  = new LabelCombo(tr("Quantize"), this);

      QListBox* rlist = new QListBox(this);
      QListBox* qlist = new QListBox(this);
      rlist->setMinimumWidth(95);
      qlist->setMinimumWidth(95);
      raster->setListBox(rlist);
      quant->setListBox(qlist);
      rlist->setColumnMode(3);
      qlist->setColumnMode(3);
      for (int i = 0; i < 30; i++)
            rlist->insertItem(rasterStrings[i], i);
      for (int i = 0; i < 24; i++)
            qlist->insertItem(quantStrings[i], i);
      setRaster(r);
      setQuant(q);

      //---------------------------------------------------
      //  To Menu
      //---------------------------------------------------

      LabelCombo* to = new LabelCombo(tr("To"), this);
      QListBox* toList = new QListBox(this);
      to->setListBox(toList);
      toList->insertItem(tr("All Events"), 0);
      toList->insertItem(tr("Looped Ev."),   CMD_RANGE_LOOP);
      toList->insertItem(tr("Selected Ev."), CMD_RANGE_SELECTED);
      toList->insertItem(tr("Looped+Sel."),  CMD_RANGE_LOOP | CMD_RANGE_SELECTED);

      connect(raster, SIGNAL(activated(int)), SLOT(_rasterChanged(int)));
      connect(quant,  SIGNAL(activated(int)), SLOT(_quantChanged(int)));
      connect(to,     SIGNAL(activated(int)), SIGNAL(toChanged(int)));
      connect(solo, SIGNAL(toggled(bool)), SIGNAL(soloChanged(bool)));
      pos->setEnabled(false);
      }

//---------------------------------------------------------
//   rasterChanged
//---------------------------------------------------------

void Toolbar1::_rasterChanged(int index)
      {
      emit rasterChanged(rasterTable[index]);
      }

//---------------------------------------------------------
//   quantChanged
//---------------------------------------------------------

void Toolbar1::_quantChanged(int index)
      {
      emit quantChanged(quantTable[index]);
      }

//---------------------------------------------------------
//   setPitch
//---------------------------------------------------------

void Toolbar1::setPitch(int val)
      {
      if (showPitch) {
            pitch->setEnabled(val != -1);
            pitch->setPitch(val);
            }
      }

void Toolbar1::setInt(int val)
      {
      if (showPitch) {
            pitch->setEnabled(val != -1);
            pitch->setInt(val);
            }
      }

//---------------------------------------------------------
//   setTime
//---------------------------------------------------------

void Toolbar1::setTime(int val)
      {
      if (!pos->isVisible()) {
            printf("NOT visible\n");
            return;
            }
      pos->setEnabled(val != -1);
      pos->setValue(val);
      }

//---------------------------------------------------------
//   setRaster
//---------------------------------------------------------

void Toolbar1::setRaster(int val)
      {
      for (int i = 0; i < 30; i++) {
            if (val == rasterTable[i]) {
                  raster->setCurrentItem(i);
                  return;
                  }
            }
      assert(0);
      }

//---------------------------------------------------------
//   setQuant
//---------------------------------------------------------

void Toolbar1::setQuant(int val)
      {
      for (int i = 0; i < 24; i++) {
            if (val == quantTable[i]) {
                  quant->setCurrentItem(i);
                  return;
                  }
            }
      assert(0);
      }

//---------------------------------------------------------
//   setSolo
//---------------------------------------------------------

void Toolbar1::setSolo(bool flag)
      {
      solo->setOn(flag);
      }

//---------------------------------------------------------
//   setPitchMode
//---------------------------------------------------------

void Toolbar1::setPitchMode(bool flag)
      {
//      pitch->setPitchMode(flag);
      }

