//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: waveedit.h,v 1.1.1.1 2003/10/29 10:06:14 wschweer Exp $
//  (C) Copyright 2000 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __WAVE_EDIT_H__
#define __WAVE_EDIT_H__

#include <qwidget.h>
#include "midieditor.h"

class QToolButton;
class PartList;
class WaveView;
class ScrollScale;
class QSlider;
class PosLabel;
class QResizeEvent;
class SNode;

//---------------------------------------------------------
//   WaveEdit
//---------------------------------------------------------

class WaveEdit : public MidiEditor {
      static QColor bg;

      WaveView* view;
      QSlider* ymag;
      QToolBar* tools;
      QToolBar* tb1;
      QToolButton* solo;
      PosLabel* pos1;
      PosLabel* pos2;

      static int _widthInit, _heightInit;

      Q_OBJECT
      virtual void closeEvent(QCloseEvent*);
      virtual void resizeEvent(QResizeEvent* ev);

   private slots:
      void cmd(int);
      void setTime(int t);
      void soloChanged(SNode* s);
      void soloChanged(bool flag);

   signals:
      void deleted(int);

   public:
      WaveEdit(PartList*);
      ~WaveEdit();
      virtual void readStatus(Xml&);
      virtual void writeStatus(int, Xml&) const;
      static void readConfiguration(Xml&);
      static void writeConfiguration(int, Xml&);
      static QColor configBg()         { return bg; }
      static void setConfigBg(QColor _bg) { bg = _bg; }
      void setBg(QColor _bg);
      };

#endif

