/* 
 * Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef _DB_QUERY_RESULTSET_H_
#define _DB_QUERY_RESULTSET_H_

#include <grts/structs.db.query.h>
#include "sqlide/recordset_be.h"

db_query_ResultsetRef WBPUBLICBACKEND_PUBLIC_FUNC grtwrap_recordset(db_query_EditorRef owner, Recordset::Ref rset);


class WBPUBLICBACKEND_PUBLIC_FUNC db_query_Resultset::ImplData
{
public:
  ImplData(db_query_ResultsetRef aself, boost::shared_ptr<Recordset> rset);
  
  std::map<std::string, int> column_by_name;
  db_query_Resultset *self;
  boost::shared_ptr<Recordset> recordset;
  size_t cursor;
};

#endif
