#include "model/wb_user_datatypes.h"
#include "user_types_box.h"
#include "base/string_utilities.h"

using base::strfmt;

/**
 * @file  user_types_box.cpp
 * @brief 
 */


UserTypesBox::UserTypesBox(wb::WBContextUI *wbui)
  : _wbui(wbui)
{
  set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC);
  add(_tree);

  _model= ListModelWrapper::create(wbui->get_usertypes_tree(),  &_tree, "UserTypesBox");
  _model->model().append_string_column(wb::UserDatatypeListBE::Name, _("Name"), RO, WITH_ICON);
  _model->model().append_string_column(wb::UserDatatypeListBE::Definition, _("Definition"), RO, NO_ICON);
  _model->model().append_string_column(wb::UserDatatypeListBE::Flags, _("Flags"), RO, NO_ICON);

  _tree.set_model(_model);
  
  show_all();
}


void UserTypesBox::refresh()
{
  _tree.unset_model();
  
  _tree.set_model(_model);
}
