/* 
 * Copyright (c) 2007, 2012, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef _MDC_CANVAS_VIEW_OPENGL_H_
#define _MDC_CANVAS_VIEW_OPENGL_H_

#include "mdc_canvas_public.h"
#include "mdc_canvas_view.h"


BEGIN_MDC_DECLS

class MYSQLCANVAS_PUBLIC_FUNC OpenGLCanvasView : public CanvasView
{
public:
  OpenGLCanvasView(int width, int height);
  virtual ~OpenGLCanvasView();

  virtual bool has_gl() const { return true; }

  virtual bool initialize();
  
  static void check_error();

  virtual void make_current()= 0;
  virtual void remove_current()= 0;
  virtual void swap_buffers()= 0;

  virtual void begin_repaint(int, int, int, int);
  virtual void end_repaint();
};

END_MDC_DECLS

#endif /* _MDC_CANVAS_VIEW_OPENGL_H_ */
