#ifndef _WB_MODEL_REPORTING_H_
#define _WB_MODEL_REPORTING_H_

#include "wb_model_reporting_public_interface.h"

#include "grt/grt_manager.h"
#include "grts/structs.db.mysql.h"
#include "grts/structs.workbench.model.reporting.h"
#include "base/trackable.h"

class WBPLUGINWBMODELREPORTINGBE_PUBLIC_FUNC WbModelReporting : public base::trackable
{
  bec::GRTManager *_manager;
  db_mysql_CatalogRef _catalog;
  grt::DictRef _options;

  workbench_model_reporting_TemplateInfoRef _template_info;
  std::string _template_dir;

  workbench_model_reporting_TemplateStyleInfoRef _template_style_info;

public:

  WbModelReporting(bec::GRTManager *grtm);

  bec::GRTManager *get_grt_manager() const { return _manager; }

  void start_sync(const boost::function<void ()> &finish_cb);
  void sync_finished(grt::ValueRef res);
  grt::ValueRef sync_task(grt::GRT*, grt::StringRef);

  db_mysql_CatalogRef get_catalog() const { return _catalog; }

  void set_option(const std::string& name, const std::string& value);
  void set_option(const std::string& name, int value);


  std::vector<std::string> get_available_reporting_templates();

  void set_active_template(const std::string& template_name);

  std::vector<std::string> get_available_reporting_template_style_names();

  std::string get_reporting_template_description();
  std::string get_reporting_template_main_filename();


  void set_active_template_style(const std::string& template_style_name);

  std::string get_reporting_template_style_description();
  std::string get_reporting_template_style_preview_image_filename();
  bool get_reporting_template_can_use_markup();
};


#endif // _WB_MODEL_REPORTING_H_

