## Copyright (C) 2004  Dragan Tubic
## 
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2, or (at your option)
## any later version.
## 
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details. 
## 
## You should have received a copy of the GNU General Public License
## along with this file.  If not, write to the Free Software Foundation,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

## -*- texinfo -*-
## @deftypefn {Function File} {} vtk_clear
## Clears all rendered actors, title, and scalar bar.  Does not clear
## the axes or outline.
## @end deftypefn
## @seealso{vtk_close}

## Author: Jonathan Stickel


function vtk_clear

  f=vtk_figure(0);

  ## clear the rendered actors, but not the axes or outline
  for i = 2:f.renderer.GetActors().GetNumberOfItems()
    f.renderer.RemoveProp(f.renderer.GetActors().GetLastActor());
  end

  ## clear existing scalarbar and title, if they exist
  i=0;
  while i < f.renderer.GetProps().GetNumberOfItems();
    if ( f.renderer.GetProps().GetItemAsObject(i).IsA("vtkScalarBarActor") ||
	f.renderer.GetProps().GetItemAsObject(i).IsA("vtkTextActor") )
      f.renderer.RemoveProp( f.renderer.GetProps().GetItemAsObject(i) );
      --i;
    endif
    ++i;
  endwhile

  vtk_update(f);

endfunction
