## Copyright (C) 2004  Dragan Tubic
## 
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2, or (at your option)
## any later version.
## 
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details. 
## 
## You should have received a copy of the GNU General Public License
## along with this file.  If not, write to the Free Software Foundation,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

## -*- texinfo -*-
## @deftypefn {Function File} {[@var{color}, @var{mt}, @var{lsty}] =} vtk_get_line_spec(@var{fmt})
## Octaviz internal function for processing format specifications.
## @end deftypefn
## @seealso{vtk_parse_params}


## Author: Dragan Tubic

function [color, marker_type, line_style] = vtk_get_line_spec( format_string )
  
  format_array = format_string + 0;
  
  codes = zeros(255,1);
  %% Colors
  %% r = Red, g = Green, b = Blue, c = Cyan, m = Magenta, y = Yellow, k = Black, w = White
  color_inds = "rgbcmykw" + 0;
  codes(color_inds) = 1;
  %% Marker types
  marker_inds = "+o*.xsd^v><ph" + 0;
  codes(marker_inds) = 2;
  %% Line styles
  line_inds = "-,:" + 0;
  codes(line_inds) = 3;
  
  line_style = "-";
  color = [0 0 1];
  marker_type = "*";
  
  
  for i = 1:length(format_array)
    if codes(format_array(i)) == 1
      colors = [1 0 0; 0 1 0; 0 0 1; 0 1 1; 1 0 1; 1 1 0; 0 0 0; 1 1 1];
      ind = index("rgbcmykw",format_string(i));
      color = colors(ind,:);
    elseif codes(format_array(i)) == 2
      marker_type = format_string(i);
    elseif codes(format_array(i)) == 3
      line_style = format_string(i);
    else
      error( strcat( "Invalid LineSpec string ",format_string ) );
    end
  end	
endfunction

