/*****************************************************************************
Copyright (c) 2011,2012 Lab of Parallel Software and Computational Science,ISCAS
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

   1. Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.

   2. Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in
      the documentation and/or other materials provided with the
      distribution.
   3. Neither the name of the ISCAS nor the names of its contributors may
      be used to endorse or promote products derived from this software
      without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

**********************************************************************************/

#include "common.h"

#include <string.h>

static char* openblas_config_str=""
#ifdef USE64BITINT
  "USE64BITINT "
#endif
#ifdef NO_CBLAS
  "NO_CBLAS "
#endif
#ifdef NO_LAPACK
  "NO_LAPACK "
#endif
#ifdef NO_LAPACKE
  "NO_LAPACKE "
#endif
#ifdef DYNAMIC_ARCH
  "DYNAMIC_ARCH "
#endif
#ifdef NO_AFFINITY
  "NO_AFFINITY "
#endif
#ifndef DYNAMIC_ARCH
  CHAR_CORENAME
#endif
  ;

#ifdef DYNAMIC_ARCH
char *gotoblas_corename();
static char tmp_config_str[256];
#endif


char* CNAME() {
#ifndef DYNAMIC_ARCH
  return openblas_config_str;
#else
  strcpy(tmp_config_str, openblas_config_str);
  strcat(tmp_config_str, gotoblas_corename());
  return tmp_config_str;
#endif
}


char* openblas_get_corename() {
#ifndef DYNAMIC_ARCH 
  return CHAR_CORENAME;
#else
  return gotoblas_corename();
#endif
}
