// --------------------------------------------------------------------------
//                   OpenMS -- Open-Source Mass Spectrometry
// --------------------------------------------------------------------------
// Copyright The OpenMS Team -- Eberhard Karls University Tuebingen,
// ETH Zurich, and Freie Universitaet Berlin 2002-2013.
//
// This software is released under a three-clause BSD license:
//  * Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
//  * Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//  * Neither the name of any author or any participating institution
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
// For a full list of authors, refer to the file AUTHORS.
// --------------------------------------------------------------------------
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL ANY OF THE AUTHORS OR THE CONTRIBUTING
// INSTITUTIONS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
// OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
// WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
// OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
// ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// --------------------------------------------------------------------------
// $Maintainer: Hannes Roest $
// $Authors: George Rosenberger, Hannes Roest, Witold Wolski $
// --------------------------------------------------------------------------

#include <OpenMS/CONCEPT/ClassTest.h>

#include <boost/assign/std/vector.hpp>
#include <boost/assign/list_of.hpp>

///////////////////////////
#include <OpenMS/ANALYSIS/OPENSWATH/DATAACCESS/MRMFeatureAccessOpenMS.h>

#include <OpenMS/ANALYSIS/MRM/ReactionMonitoringTransition.h>
///////////////////////////

using namespace OpenMS;
using namespace std;

START_TEST(MRMFeatureAccessOpenMS, "$Id: OpenSwathMRMFeatureAccessOpenMS_test.C 10915 2013-04-04 20:14:57Z aiche $")

/////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////

//FeatureOpenMS
{
FeatureOpenMS* ptr = 0;
FeatureOpenMS* nullPointer = 0;

START_SECTION(FeatureOpenMS())
{
  Feature f;
  ptr = new FeatureOpenMS(f);
  TEST_NOT_EQUAL(ptr, nullPointer)
}
END_SECTION

START_SECTION(~FeatureOpenMS())
{
  delete ptr;
}
END_SECTION
}

//MRMFeatureOpenMS
{
MRMFeatureOpenMS* ptr = 0;
MRMFeatureOpenMS* nullPointer = 0;

START_SECTION(MRMFeatureOpenMS())
{
  MRMFeature f;
  ptr = new MRMFeatureOpenMS(f);
  TEST_NOT_EQUAL(ptr, nullPointer)
}
END_SECTION

START_SECTION(~MRMFeatureOpenMS())
{
  delete ptr;
}
END_SECTION
}

//TransitionGroupOpenMS
{
TransitionGroupOpenMS <MSSpectrum<Peak1D>, ReactionMonitoringTransition>* ptr = 0;
TransitionGroupOpenMS <MSSpectrum<Peak1D>, ReactionMonitoringTransition>* nullPointer = 0;

START_SECTION(TransitionGroupOpenMS())
{
  MRMTransitionGroup <MSSpectrum <Peak1D>, ReactionMonitoringTransition> trgroup;
  ptr = new TransitionGroupOpenMS <MSSpectrum <Peak1D>, ReactionMonitoringTransition> (trgroup);
  TEST_NOT_EQUAL(ptr, nullPointer)
}
END_SECTION

START_SECTION(~TransitionGroupOpenMS())
{
  delete ptr;
}
END_SECTION
}

//SignalToNoiseOpenMS
{
SignalToNoiseOpenMS<Peak1D>* ptr = 0;
SignalToNoiseOpenMS<Peak1D>* nullPointer = 0;

START_SECTION(SignalToNoiseOpenMS())
{
  OpenMS::MSSpectrum<> chromat;
  ptr = new SignalToNoiseOpenMS<Peak1D>(chromat, 1.0, 3.0);
  TEST_NOT_EQUAL(ptr, nullPointer)
}
END_SECTION

START_SECTION(~SignalToNoiseOpenMS())
{
  delete ptr;
}
END_SECTION
}
/////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////
END_TEST



