// $Id: CartridgeSlotManager.hh 11757 2010-11-23 21:41:42Z m9710797 $

#ifndef CARTRIDGESLOTMANAGER_HH
#define CARTRIDGESLOTMANAGER_HH

#include "noncopyable.hh"
#include <string>
#include <memory>

namespace openmsx {

class MSXMotherBoard;
class CartCmd;
class HardwareConfig;
class CartridgeSlotInfo;

class CartridgeSlotManager : private noncopyable
{
public:
	explicit CartridgeSlotManager(MSXMotherBoard& motherBoard);
	~CartridgeSlotManager();

	static int getSlotNum(const std::string& slot);

	void createExternalSlot(int ps);
	void createExternalSlot(int ps, int ss);
	void removeExternalSlot(int ps);
	void removeExternalSlot(int ps, int ss);
	void testRemoveExternalSlot(int ps, const HardwareConfig& allowed) const;
	void testRemoveExternalSlot(int ps, int ss, const HardwareConfig& allowed) const;

	// Query/allocate/free external slots
	void getSpecificSlot(unsigned slot, int& ps, int& ss) const;
	void getAnyFreeSlot(int& ps, int& ss) const;
	void allocateSlot(int ps, int ss, const HardwareConfig& hwConfig);
	void freeSlot(int ps, int ss, const HardwareConfig& hwConfig);

	// Allocate/free external primary slots
	void allocatePrimarySlot(int& ps, const HardwareConfig& hwConfig);
	void freePrimarySlot(int ps, const HardwareConfig& hwConfig);

	bool isExternalSlot(int ps, int ss, bool convert) const;

private:
	int getSlot(int ps, int ss) const;

	struct Slot {
		Slot();
		~Slot();
		bool exists() const;
		bool used(const HardwareConfig* allowed = NULL) const;

		std::auto_ptr<CartCmd> command;
		const HardwareConfig* config;
		unsigned useCount;
		int ps;
		int ss;
	};
	static const unsigned MAX_SLOTS = 16 + 4;
	Slot slots[MAX_SLOTS];
	MSXMotherBoard& motherBoard;
	const std::auto_ptr<CartCmd> cartCmd;
	const std::auto_ptr<CartridgeSlotInfo> extSlotInfo;
	friend class CartCmd;
	friend class CartridgeSlotInfo;
};

} // namespace openmsx

#endif
