//                                               -*- C++ -*-
/**
 *  @file  TrendTransform.hxx
 *  @brief Abstract top-level class for all numerical math function implementations
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 *  Id:      $Id: TrendTransform.hxx 2392 2012-02-17 18:35:43Z schueller $
 */
#ifndef OPENTURNS_TRENDTRANSOFORM_HXX
#define OPENTURNS_TRENDTRANSOFORM_HXX


#include "TemporalFunction.hxx"
#include "NumericalMathFunction.hxx"

BEGIN_NAMESPACE_OPENTURNS

/**
 * @class TrendTransform
 *
 * The class that simulates a dynamical function based on a
 * numerical math function that acts only on the temporal part
 * of a time series.
 */
class TrendTransform
  : public TemporalFunction
{
  CLASSNAME;
public:

  typedef NumericalMathEvaluationImplementation::Implementation EvaluationImplementation;

  /** Default constructor */
  TrendTransform();

  /** Parameter constructor */
  TrendTransform(const NumericalMathFunction & function);

  /** Parameter constructor */
  TrendTransform(const EvaluationImplementation & p_evaluation);

  /** Parameter constructor */
  TrendTransform(const NumericalMathEvaluationImplementation & evaluation);

  /** Virtual constructor */
  virtual TrendTransform * clone() const;

  /** Comparison operator */
  Bool operator ==(const TrendTransform & other) const;

  /** String converter */
  String __repr__() const;
  String __str__(const String & offset = "") const;

  /** Operator () */
  using TemporalFunction::operator();
  TimeSeries operator() (const TimeSeries & inTS) const;


  /** Method save() stores the object through the StorageManager */
  void save(Advocate & adv) const;

  /** Method load() reloads the object from the StorageManager */
  void load(Advocate & adv);

}; /* class TrendTransform */


END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_TRENDTRANSOFORM_HXX */
