//                                               -*- C++ -*-
/**
 *  @file  OTType.hxx
 *  @brief The external header file of Open TURNS for subdir Type
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-02-11 16:49:59 +0100 (Wed, 11 Feb 2009) $
 *  Id:      $Id: OTType.hxx 1129 2009-02-11 15:49:59Z dutka $
 */

#ifndef OPENTURNS_OTTYPE_HXX
#define OPENTURNS_OTTYPE_HXX

#include "Cache.hxx"
#include "Collection.hxx"
#include "Description.hxx"
#include "DescriptionImplementation.hxx"
#include "IdentityMatrix.hxx"
#include "Indices.hxx"
#include "Matrix.hxx"
#include "MatrixImplementation.hxx"
#include "NumericalPoint.hxx"
#include "NumericalPointWithDescription.hxx"
#include "PersistentCollection.hxx"
#include "SquareMatrix.hxx"
#include "SymmetricMatrix.hxx"
#include "SymmetricTensor.hxx"
#include "Tensor.hxx"
#include "TensorImplementation.hxx"
#include "DomainImplementation.hxx"
#include "Domain.hxx"
#include "Interval.hxx"
#include "ComplexMatrixImplementation.hxx"
#include "ComplexMatrix.hxx"
#include "HermitianMatrix.hxx"
#include "SquareComplexMatrix.hxx"
#include "TriangularComplexMatrix.hxx"

#endif /* OPENTURNS_OTTYPE_HXX */
