//                                               -*- C++ -*-
/**
 *  @file  BurrFactory.hxx
 *  @brief Factory for Burr distribution
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (lun. 11 avril 2011) $
 *  Id:      $Id: BurrFactory.hxx 1866 2011-04-11 10:32:27Z schueller $
 */
#ifndef OPENTURNS_BURRFACTORY_HXX
#define OPENTURNS_BURRFACTORY_HXX

#include "OTprivate.hxx"
#include "DistributionImplementationFactory.hxx"
#include "Burr.hxx"

BEGIN_NAMESPACE_OPENTURNS



/**
 * @class BurrFactory
 */
class BurrFactory
  : public DistributionImplementationFactory
{
public:

  /** Default constructor */
  BurrFactory();

  /** Virtual constructor */
  virtual BurrFactory * clone() const;

  /* Here is the interface that all derived class must implement */
  using DistributionImplementationFactory::build;

  Burr * build(const NumericalSample & sample) const;
  Burr * build(const NumericalPointCollection & parameters) const;
  Burr * build() const;

}; /* class BurrFactory */


END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_BURRFACTORY_HXX */
