//                                               -*- C++ -*-
/**
 *  @file  t_FittingTest_std.cxx
 *  @brief The test file of class Test
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 *  Id:      $Id: t_FittingTest_std.cxx 2392 2012-02-17 18:35:43Z schueller $
 */
#include <iostream>
#include <iomanip>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include <cmath>
#include "FittingTest.hxx"
#include "NumericalSample.hxx"
#include "Collection.hxx"
#include "SquareMatrix.hxx"
#include "IdentityMatrix.hxx"
#include "TestResult.hxx"
#include "NumericalPoint.hxx"
#include "Distribution.hxx"
#include "Beta.hxx"
#include "Exponential.hxx"
#include "Gamma.hxx"
#include "Geometric.hxx"
#include "Gumbel.hxx"
#include "Histogram.hxx"
#include "Logistic.hxx"
#include "LogNormal.hxx"
#include "Normal.hxx"
#include "Poisson.hxx"
#include "Student.hxx"
#include "Triangular.hxx"
#include "TruncatedNormal.hxx"
#include "Uniform.hxx"
#include "Weibull.hxx"
#include "UserDefined.hxx"
#include "DistributionImplementationFactory.hxx"
#include "UniformFactory.hxx"
#include "BetaFactory.hxx"
#include "NormalFactory.hxx"

using namespace OT;
using namespace OT::Test;


int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);
  setRandomGenerator();

  Collection<Distribution> continuousDistributionCollection;
  Collection<Distribution> discreteDistributionCollection;
  Collection<Distribution> distributionCollection;

  Beta beta(2.,3.,0.,1.);
  distributionCollection.add(beta);
  continuousDistributionCollection.add(beta);

  Gamma gamma(1.,2.,3.);
  distributionCollection.add(gamma);
  continuousDistributionCollection.add(gamma);

  Gumbel gumbel(1.,2.);
  distributionCollection.add(gumbel);
  continuousDistributionCollection.add(gumbel);

  LogNormal lognormal(1.,1.,2.);
  distributionCollection.add(lognormal);
  continuousDistributionCollection.add(lognormal);

  Logistic logistic(1.,1.);
  distributionCollection.add(logistic);
  continuousDistributionCollection.add(logistic);

  Normal normal(1.,2.);
  distributionCollection.add(normal);
  continuousDistributionCollection.add(normal);

  TruncatedNormal truncatednormal(1.,1.,0.,3.);
  distributionCollection.add(truncatednormal);
  continuousDistributionCollection.add(truncatednormal);

  Student student(10.,10.);
  distributionCollection.add(student);
  continuousDistributionCollection.add(student);

  Triangular triangular(-1.,2.,4.);
  distributionCollection.add(triangular);
  continuousDistributionCollection.add(triangular);

  Uniform uniform(1.,2.);
  distributionCollection.add(uniform);
  continuousDistributionCollection.add(uniform);

  Weibull weibull(1., 1., 2.);
  distributionCollection.add(weibull);
  continuousDistributionCollection.add(weibull);

  Geometric geometric(.5);
  distributionCollection.add(geometric);
  discreteDistributionCollection.add(geometric);

  Poisson poisson(2.);
  distributionCollection.add(poisson);
  discreteDistributionCollection.add(poisson);

  Collection<UserDefinedPair> collection(3, UserDefinedPair(NumericalPoint(1), 0.0));

  NumericalPoint point(1);
  point[0] = 1.0;
  collection[0] = UserDefinedPair(point, 0.3);
  point[0] = 2.0;
  collection[1] = UserDefinedPair(point, 0.2);
  point[0] = 3.0;
  collection[2] = UserDefinedPair(point, 0.5);
  UserDefined userdefined(collection);
  distributionCollection.add(userdefined);
  discreteDistributionCollection.add(userdefined);

  UnsignedLong size(100);

  UnsignedLong continuousDistributionNumber(continuousDistributionCollection.getSize());
  UnsignedLong discreteDistributionNumber(discreteDistributionCollection.getSize());
  UnsignedLong distributionNumber(continuousDistributionNumber + discreteDistributionNumber);
  Collection<NumericalSample> sampleCollection(distributionNumber);
  Collection<NumericalSample> continuousSampleCollection(continuousDistributionNumber);
  Collection<NumericalSample> discreteSampleCollection(discreteDistributionNumber);
  for (UnsignedLong i = 0; i < continuousDistributionNumber; i++)
    {
      continuousSampleCollection[i] = continuousDistributionCollection[i].getNumericalSample(size);
      sampleCollection[i] = continuousSampleCollection[i];
    }
  for (UnsignedLong i = 0; i < discreteDistributionNumber; i++)
    {
      discreteSampleCollection[i] = discreteDistributionCollection[i].getNumericalSample(size);
      sampleCollection[continuousDistributionNumber + i] = discreteSampleCollection[i];
    }
  FittingTest::DistributionFactoryCollection factoryCollection;
  factoryCollection.add(UniformFactory());
  factoryCollection.add(BetaFactory());
  factoryCollection.add(NormalFactory());
  NumericalSample aSample(Uniform(-1.5, 2.5).getNumericalSample(size));
  fullprint << "best model BIC=" << FittingTest::BestModelBIC(aSample, factoryCollection) << std::endl;
  fullprint << "best model Kolmogorov=" << FittingTest::BestModelKolmogorov(aSample, factoryCollection) << std::endl;

  SquareMatrix resultBIC(distributionNumber);
  for (UnsignedLong i = 0; i < distributionNumber; i++)
    {
      for (UnsignedLong j = 0; j < distributionNumber; j++)
        {
          const NumericalScalar value(FittingTest::BIC(sampleCollection[i], distributionCollection[j], 0));
          resultBIC(i, j) = (fabs(value) < 1.0e-6 ? 0.0 : value);
        }
    }
  fullprint << "resultBIC=" << resultBIC << std::endl;
  SquareMatrix resultKolmogorov(continuousDistributionNumber);
  for (UnsignedLong i = 0; i < continuousDistributionNumber; i++)
    {
      for (UnsignedLong j = 0; j < continuousDistributionNumber; j++)
        {
          const NumericalScalar value(FittingTest::Kolmogorov(continuousSampleCollection[i], continuousDistributionCollection[j], 0.95, 0).getPValue());
          resultKolmogorov(i, j) = (fabs(value) < 1.0e-6 ? 0.0 : value);
        }
    }
  fullprint << "resultKolmogorov=" << resultKolmogorov << std::endl;
  SquareMatrix resultChiSquared(discreteDistributionNumber - 1);
  for (UnsignedLong i = 0; i < discreteDistributionNumber - 1; i++)
    {
      for (UnsignedLong j = 0; j < discreteDistributionNumber - 1; j++)
        {
          const NumericalScalar value(FittingTest::ChiSquared(discreteSampleCollection[i], discreteDistributionCollection[j], 0.95, 0).getPValue());
          resultChiSquared(i, j) = (fabs(value) < 1.0e-6 ? 0.0 : value);
        }
    }
  fullprint << "resultChiSquared=" << resultChiSquared << std::endl;
  return ExitCode::Success;
}
