//                                               -*- C++ -*-
/**
 *  @file  t_Wilks_std.cxx
 *  @brief The test file of class Wilks for standard methods
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 *  Id:      $Id: t_Wilks_std.cxx 2392 2012-02-17 18:35:43Z schueller $
 */
#include <iostream>
#include <sstream>
#include <exception>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "NumericalPoint.hxx"
#include "Wilks.hxx"
#include "Normal.hxx"
#include "RandomVector.hxx"
#include "Distribution.hxx"

using namespace OT;
using namespace OT::Test;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  try {
    Distribution distribution(Normal(0.0, 1.0));
    std::cout << "distribution=" << distribution << std::endl;
    RandomVector vector(distribution);
    std::cout << "vector=" << vector << std::endl;
    Wilks algo(vector);
    NumericalPoint alpha(2);
    alpha[0] = 0.9;
    alpha[1] = 0.95;
    NumericalPoint beta(2);
    beta[0] = 0.9;
    beta[1] = 0.95;
    for (UnsignedLong a = 0; a < 2; a++)
      {
        fullprint << "alpha=" << alpha[a] << std::endl;
        for (UnsignedLong b = 0; b < 2; b++)
          {
            fullprint << "beta=" << beta[b] << std::endl;
            for (UnsignedLong i = 0; i < 5; i++)
              {
                // Sample size for various parameters set
                fullprint << "n(" << alpha[a] << ", " << beta[b] << ", " << i << ")=" << Wilks::ComputeSampleSize(alpha[a], beta[b], i) << std::endl;
                // Quantile estimation using Wilks method
                fullprint << "Quantile of level=" << alpha[a] << " with confidence=" << beta[b] << " using upper statistics=" << i << " gives estimate=" << algo.computeQuantileBound(alpha[a], beta[b], i) << std::endl;
              }
          }
      }
  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }

  return ExitCode::Success;
}
