// SWIG file typ_module.i
// Author : $LastChangedBy: schueller $
// Date : $LastChangedDate: 2012-01-04 12:26:21 +0100 (Wed, 04 Jan 2012) $
// Id : $Id: typ_module.i 2302 2012-01-04 11:26:21Z schueller $

%module(package="openturns", docstring="Internal data types.") typ
%feature("autodoc","1");

%{
#include "OTconfig.hxx"
#include "OTCommon.hxx"
#include "OTType.hxx"
%}

%include typemaps.i
%include OTtypes.i
%include OTexceptions.i
%include std_vector.i

/* Base/Common */
%import common_module.i

/* Wrapper */
%import wrapper_module.i
%import BaseWrapperTemplateDefs.i

/* Base/Type */
%include PersistentCollection.i
%include DescriptionImplementation.i
%include Description.i
%include NumericalPoint.i
%include NumericalPointWithDescription.i
%include Indices.i

%include DomainImplementation.i
%include Interval.i
%include Domain.i

%include MatrixImplementation.i
%include Matrix.i
%include SquareMatrix.i
%include SymmetricMatrix.i
%include TensorImplementation.i
%include Tensor.i
%include SymmetricTensor.i
%include Cache.i
%include ComplexMatrixImplementation.i
%include ComplexMatrix.i
%include SquareComplexMatrix.i
%include HermitianMatrix.i
%include TriangularComplexMatrix.i

/* At last we include template definitions */
%include BaseTypTemplateDefs.i
