#! /usr/bin/env python

from openturns import *

TESTPREAMBLE()
RandomGenerator().SetSeed(0)

try :

    # We create a numerical point of dimension 1
    point = NumericalPoint(4)
    ref_point = point

    point[0] = 101
    point[1] = 202
    point[2] = 303
    point[3] = 404

    print "point = " , repr(ref_point)


    # We create a 'constant' RandomVector from the NumericalPoint
    vect = RandomVector(point)
    print "vect=" , vect

    # Check standard methods of class RandomVector
    print "vect dimension=" , vect.getDimension()
    print "vect realization (first )=" , repr(vect.getRealization())
    print "vect sample =" , repr(vect.getNumericalSample(5))

    # We create a numerical math function
    myFunction = NumericalMathFunction("poutre")

    # We create a composite random vector
    output = RandomVector(myFunction, vect)

    # We create an Event from this RandomVector

    myEvent = Event(output,ComparisonOperator(Less()), 50)
    print "myEvent=" , repr(myEvent)

    # We compute one realization of the event
    print "myEvent realization=" , repr(myEvent.getRealization())

    # We compute a sample of the event
    print "myEvent sample=" , repr(myEvent.getNumericalSample(10))

    # We create an Event using a domain implementation
    domain = Domain(Interval(1))

    myDomainEvent = Event(output, domain)
    "myDomainEvent=" , myDomainEvent

    # We compute one realization of the event
    print "myDomainEvent realization=" , repr(myDomainEvent.getRealization())

    # We compute a sample of the domain event
    print "myDomainEvent sample=" , repr(myDomainEvent.getNumericalSample(10))


    # Test for Event_Process - Defaut process is WhiteNoise

    # Building a process from a White Noise
    whiteNoise = WhiteNoise()

    myProcess = Process(whiteNoise)

    myProcessEvent = Event(myProcess, domain)
    print "myProcessEvent=" , myProcessEvent

    realization = myProcessEvent.getRealization()
    # We compute one realization of the event
    print "myProcessEvent realization=" , repr(realization)

except :
    import sys
    print "t_Event_std.py", sys.exc_type, sys.exc_value
