/*
 * settings.c
 *
 * 
 * Author: 
 *  Richard Hult <rhult@hem.passagen.se>
 * 
 *  http://www.dtek.chalmers.se/~d4hult/oregano/ 
 * 
 * Copyright (C) 1999,2000  Richard Hult 
 * 
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the 
 * License, or (at your option) any later version. 
 * 
 * This program is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <unistd.h>
#include <gnome.h>
#include <glade/glade.h>
#include "main.h"
#include "settings.h"
#include "schematic.h"
#include "schematic-view.h" 
#include "dialogs.h"
#include "oregano-utils.h"
#include "oregano-config.h"

typedef struct {
	Schematic *sm;
	GnomePropertyBox *pbox;

	GtkWidget *w_show_log;

	GtkWidget *w_spice_path;
	GtkWidget *w_compress_files;
} Settings;

#define SETTINGS(x) ((Settings*)(x))

static void 
changed_cb (GtkWidget *widget, Settings *s)
{
	gnome_property_box_changed (GNOME_PROPERTY_BOX (s->pbox));
}

static void
remove_item_cb ( GtkWidget *widget, GnomeEntry *entry) {
   GtkList *lst;
   GList   *sel;
   gchar   *txt;

   txt = gtk_entry_get_text ( GTK_ENTRY (gnome_entry_gtk_entry (entry)));
   lst   =  GTK_LIST ( entry->combo.list );
   if ( lst ) {
      sel = g_list_copy (lst->selection);
      if ( sel ) {
	 gtk_list_remove_items(lst,sel);
	 g_list_free (sel);

	 sel = entry->items;
	 for ( ;sel;sel = sel->next) {
		 if ( ! strcmp(txt,sel->data) )
			 g_list_remove (entry->items,sel->data);
	 }
      }
   }
}

static void
apply_callback (GtkWidget *w, gint page_nr, Settings *s)
{
	if (page_nr == -1 ) {
		if (oregano.simexec)
			g_free (oregano.simexec);
		oregano.simexec = gtk_editable_get_chars (
			GTK_EDITABLE (gnome_file_entry_gtk_entry (GNOME_FILE_ENTRY (s->w_spice_path))), 0, -1);

		oregano.compress_files = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (s->w_compress_files));  
		oregano.show_log = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (s->w_show_log));  
		
		oregano_config_save ();
	}
}

static gint 
close_callback (GtkWidget *widget, Settings *s)
{
	s->pbox = NULL;
	return FALSE;
}

static gint 
delete_event_cb (GtkWidget *widget, GdkEvent *event, gpointer data)
{
	return FALSE;
}

gpointer
settings_new (Schematic *sm)
{
	Settings *s;

	s = g_new0 (Settings, 1);
	s->sm = sm;

	return s;
}

void
settings_show (GtkWidget *widget, SchematicView *sv)
{
	GtkWidget *w, *pbox;
	GnomeEntry *w0;
	GladeXML *gui;
	Settings *s;
	Schematic *sm;

	g_return_if_fail (sv != NULL);

	sm = schematic_view_get_schematic (sv);
	s = schematic_get_settings (sm);

	/* Only allow one instance of the property box per schematic. */
	if (SETTINGS (s)->pbox){
		gdk_window_raise (GTK_WIDGET (SETTINGS (s)->pbox)->window);
 		return;
	}		

	if (!g_file_exists (OREGANO_GLADEDIR "/settings.glade")) {
		oregano_error (_("Could not create settings dialog."));
		return;
	}

	gui = glade_xml_new (OREGANO_GLADEDIR "/settings.glade", "toplevel");
	if (!gui) {
		oregano_error (_("Could not create settings dialog."));
		return;
	}

	w = glade_xml_get_widget (gui, "toplevel");
	if (!w) {
		oregano_error (_("Could not create settings dialog."));
		return;
	}

	pbox = w;
	s->pbox = GNOME_PROPERTY_BOX (pbox);

	gtk_signal_connect (GTK_OBJECT (pbox), "delete_event",
			    GTK_SIGNAL_FUNC (delete_event_cb), s);

	/* Setup callbacks. */
	gtk_signal_connect (GTK_OBJECT (pbox), "apply",
			    GTK_SIGNAL_FUNC (apply_callback), s);
	gtk_signal_connect (GTK_OBJECT (pbox), "close",
			    GTK_SIGNAL_FUNC (close_callback), s);

	w = glade_xml_get_widget (gui, "spice-path-entry");
	s->w_spice_path = w;
	gnome_file_entry_set_title (GNOME_FILE_ENTRY (w), "Path to spice executable");
	gtk_entry_set_text (GTK_ENTRY (gnome_file_entry_gtk_entry (GNOME_FILE_ENTRY (w))),
			   oregano.simexec);
	gtk_signal_connect (GTK_OBJECT (gnome_file_entry_gtk_entry (GNOME_FILE_ENTRY (w))),
			    "changed",
			    GTK_SIGNAL_FUNC (changed_cb), s);

	w = glade_xml_get_widget (gui, "compress-enable");
	s->w_compress_files = w;
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (w), oregano.compress_files);
	gtk_signal_connect (GTK_OBJECT (w), "clicked", GTK_SIGNAL_FUNC (changed_cb), s);

	w = glade_xml_get_widget (gui, "log-enable");
	s->w_show_log = w;
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (w), oregano.show_log);
	gtk_signal_connect (GTK_OBJECT (w), "clicked", GTK_SIGNAL_FUNC (changed_cb), s);

	w = glade_xml_get_widget (gui, "grid-size");
	gtk_widget_set_sensitive (w, FALSE);
	w = glade_xml_get_widget (gui, "realtime-enable");
	gtk_widget_set_sensitive (w, FALSE);

	
	w = glade_xml_get_widget (gui, "library-path-entry");
	gtk_widget_set_sensitive (w, FALSE);
	w0 = GNOME_ENTRY (gnome_file_entry_gnome_entry (GNOME_FILE_ENTRY (w)));
	gnome_entry_set_history_id(w0,"Libraries Path");
	gnome_entry_set_max_saved (w0, 100 );
	gnome_entry_load_history (w0);
	w = glade_xml_get_widget (gui, "btn_remove_lib_path");
	gtk_widget_set_sensitive (w, FALSE);
	gtk_signal_connect (GTK_OBJECT (w), "clicked", GTK_SIGNAL_FUNC (remove_item_cb), w0);

	w = glade_xml_get_widget (gui, "model-path-entry");
	gtk_widget_set_sensitive (w, FALSE);
	w0 = GNOME_ENTRY (gnome_file_entry_gnome_entry (GNOME_FILE_ENTRY (w)));
	gnome_entry_set_history_id(w0,"Models Path");
	gnome_entry_set_max_saved (w0, 100 );
	gnome_entry_load_history (w0);

	w = glade_xml_get_widget (gui, "btn_remove_model_path");
	gtk_widget_set_sensitive (w, FALSE);
	gtk_signal_connect (GTK_OBJECT (w), "clicked", GTK_SIGNAL_FUNC (remove_item_cb), w0);
}

