
/******************************************************************************
**
**  Copyright (C) 2006 Brian Wotring.
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, view a current copy of the license
**  file here:
**
**      http://www.hostintegrity.com/osiris/LICENSE
**
******************************************************************************/

/*****************************************************************************
**
**  File:    md_config.h
**  Date:    June 3, 2002
**
**  Author:  Brian Wotring
**  Purpose: interact with local file system to read in config information
**           from hosts directory.
**
******************************************************************************/

#ifndef MD_CONFIG_H_
#define MD_CONFIG_H_


int osi_host_read_configs( OSI_HOST *host );
int osi_host_read_config_briefs( OSI_HOST *host );

osi_list osi_read_shared_config_briefs();

OSI_SCAN_CONFIG * osi_host_read_config_with_name( const char *host,
                                                const char *name );

OSI_SCAN_CONFIG * osi_host_read_config_with_id( const char *host,
                                              const char *id );

OSI_SCAN_CONFIG * osi_host_read_default_config( const char *os_name );

int osi_host_remove_config_with_name( const char *host,
                                      const char *name );

int osi_config_write_with_name( OSI_SCAN_CONFIG *cfg, const char *host,
                                const char *name );

OSI_CONFIG_BRIEF * osi_host_read_config_brief_with_name( const char *host,
                                                         const char *name );


#endif
