#include "aptplugincontainer.h"

#include <qaction.h>
#include <qpopupmenu.h>
#include <qmessagebox.h>

// NPlugin
#include <plugincontainer.h>
#include <iprogressobserver.h>
#include <iprovider.h>

// NUtil
#include <progressdisplaydlg.h>

// NApplication
#include "applicationfactory.h"
#include "runcommand.h"

// NApt
#include "dumpavailpackagedb.h"


// NPlugin
#include "aptpluginfactory.h"
#include "aptsearchplugin.h"
#include "packagestatusplugin.h"
#include "packagedescriptionplugin.h"
#include "installedversionplugin.h"
#include "availableversionplugin.h"



extern "C" 
{ 
	NPlugin::PluginContainer* new_aptplugin() 
	{
		return new NPlugin::AptPluginContainer;
	} 
	
	NPlugin::PluginInformation get_pluginInformation()
	{
		return NPlugin::PluginInformation("aptplugin", "1.2", "Benjamin Mesing");
	} 
}

namespace NPlugin
{

/////////////////////////////////////////////////////
// Constructors/ Destructors
/////////////////////////////////////////////////////

AptPluginContainer::AptPluginContainer( )
  : BasePluginContainer()
{ 
	addPlugin("AptSearchPlugin");
	addPlugin("PackageStatusPlugin");
	addPlugin("PackageDescriptionPlugin");
	addPlugin("InstalledVersionPlugin");
	addPlugin("AvailableVersionPlugin");
	_pAptSearchPlugin = 0;
	_pPackageStatusPlugin = 0;
	_pPackageDescriptionPlugin = 0;
	_pInstalledVersionPlugin = 0;
	_pAvailableVersionPlugin = 0;
	_pPackageDB = 0;
	_pAptUpdateAction = new QAction(QObject::tr("apt-get Update"), 0, this, "AptUpdateAction");
	_pAptUpdateAction->setStatusTip(QObject::tr("call \"apt-get update\" updating the package database"));
	connect( _pAptUpdateAction, SIGNAL(activated()), SLOT(onAptUpdate()) );
	_pReloadDbAction = new QAction(QObject::tr("Reload Package Database"), 0, this, "ReloadDbAction");
	_pReloadDbAction ->setStatusTip(QObject::tr("reloads the package database from disk (e.g. if apt-get update was performed externally)"));
	connect( _pReloadDbAction, SIGNAL(activated()), SLOT(onReloadDb()) );

}

 
AptPluginContainer::~AptPluginContainer( )
{
	delete pluginFactory();
	delete _pPackageDB;
}


/////////////////////////////////////////////////////
// Plugin Container Interface
/////////////////////////////////////////////////////
 
bool AptPluginContainer::init(IProvider* pProvider)
{
	NUtil::IProgressObserver* pObserver = pProvider->progressObserver();
	pObserver->setProgressRange(0, 97, true);
	_pPackageDB = new NApt::DumpAvailPackageDB(pObserver, pProvider->packages().size());
	BasePluginContainer::init(pProvider, new AptPluginFactory(pProvider, this, _pPackageDB, _pPackageDB));
	pObserver->setProgressRange(97, 98, true);
	_pAptSearchPlugin = dynamic_cast<AptSearchPlugin*>(requestPlugin("AptSearchPlugin"));
	_pPackageStatusPlugin = dynamic_cast<PackageStatusPlugin*>(requestPlugin("PackageStatusPlugin"));
	pObserver->setProgressRange(98, 99, true);
	_pPackageDescriptionPlugin = dynamic_cast<PackageDescriptionPlugin*>(requestPlugin("PackageDescriptionPlugin"));
	_pInstalledVersionPlugin = dynamic_cast<InstalledVersionPlugin*>(requestPlugin("InstalledVersionPlugin"));
	_pAvailableVersionPlugin = dynamic_cast<AvailableVersionPlugin*>(requestPlugin("AvailableVersionPlugin"));
	pObserver->setProgressRange(99, 100, true);
	_pAptUpdateAction->addTo(provider()->systemMenu());
	_pReloadDbAction->addTo(provider()->systemMenu());
	return true;
}


/////////////////////////////////////////////////////
// IAptMediator Interface
/////////////////////////////////////////////////////

QStringList AptPluginContainer::searchPatterns()
{
	if (!_pAptSearchPlugin)
		return QStringList();
	return _pAptSearchPlugin->searchPatterns();
}

/////////////////////////////////////////////////////
// AptPluginContainer functions
/////////////////////////////////////////////////////

void AptPluginContainer::onAptUpdate()
{
	if ( geteuid() != 0 )	// check if the user have super user priviledges
	{
		QMessageBox::information( provider()->mainWindow(), tr("Need Root Priviledges"), 
			tr("You need super user priviledges to execute this command.\n"
			  "Please start the application as root and try again."));
		return;
	}
	_pAptUpdateAction->setEnabled(false);
	// this will fetch us the update of the db
	NApplication::ApplicationFactory fac;
	_pCommand = fac.getRunCommand("AptUpdateProcess");
	QString command = "/usr/bin/apt-get";
	QString arg1 = "update";
	connect(_pCommand, SIGNAL(quit()), SLOT(onAptUpdateFinished()) );
	_pCommand->addArgument(command);
	_pCommand->addArgument(arg1);
	if ( !_pCommand->start() )
	{
		provider()->reportError( tr("Command not executed"), tr("The command <tt>") + command 
			+ " " + arg1 + tr("</tt> could not be executed.\n") );
		_pAptUpdateAction->setEnabled(true);
		delete _pCommand;
		_pCommand = 0;
	}
}


void AptPluginContainer::onAptUpdateFinished()
{
	if (_pCommand->processExitedSuccessful())
	{
 		NUtil::ProgressDisplayDlg dlg(provider()->mainWindow(), "PluginProgressDlg", true);
		dlg.show();
		_pPackageDB->reloadPackageInformation(&dlg);
	}
	delete _pCommand;
	_pCommand = 0;
	_pAptUpdateAction->setEnabled(true);
}

void AptPluginContainer::onReloadDb()
{
	NUtil::ProgressDisplayDlg dlg(provider()->mainWindow(), "PluginProgressDlg", true);
	dlg.show();
	_pPackageDB->reloadPackageInformation(&dlg);
}

}	// namespace NPlugin
