#include <stdlib.h>

#include <string.h>

#include <glib.h>

#include <pan/base/article.h>
#include <pan/base/base-prefs.h>
#include <pan/base/debug.h>
#include <pan/base/group.h>
#include <pan/base/pan-glib-extensions.h>
#include <pan/base/server.h>

static void
pan_init (void)
{
	gchar * base;
	gchar * data_dir;
	gchar * download_dir;

	base = getenv ("srcdir");
	base = g_strdup_printf ("%s/", base!=NULL ? base : getenv("PWD"));
	data_dir = g_strdup_printf ("%s/data/", base);
	download_dir = g_strdup_printf ("%s/data/save/", base);
	base_prefs_init (data_dir, download_dir, 1000, FALSE, FALSE);
	g_free (data_dir);
	g_free (download_dir);
}


int
main (void)
{
	gint test = 0;
	Server * s;
	Group * g;
	Article * a;
	Article * a1;
	const gchar * cpch;
	gchar buf[512];

	g_thread_init (NULL);
	pan_init ();

	s = server_new ();
	s->name = g_strdup ("Server");
	g = group_new (s, "alt.test");
	group_ref_articles (g, NULL);

	/* ctor sanity */
	++test;
	a1 = article_new (g);
	if (a1==NULL) return test;
	if (a1->crosspost_qty != 0) return test;
	if (a1->part != 0) return test;
	if (a1->parts != 0) return test;
	if (a1->linecount != 0) return test;
	if (a1->state != 0) return test;
	if (a1->unread_children != 0) return test;
	if (a1->date != 0) return test;
	if (a1->threads != NULL) return test;
	if (a1->parent != NULL) return test;
	if (a1->author_addr != NULL) return test;
	if (a1->author_real != NULL) return test;
	if (a1->subject != NULL) return test;
	if (a1->message_id != NULL) return test;
	if (a1->references != NULL) return test;
	g_message ("PASS article ctor sanity check");
	a1->message_id = g_strdup ("<foobar.foo.bar>");
	a1->number = 1;

	/* set header: no chunk */
	++test;
	cpch = "When the Levee Breaks";
	article_set_header (a1, HEADER_SUBJECT, cpch, 0);
	if (a1->subject!=cpch) return test;
	g_message ("PASS article_set_header, no chunk");

	/* clear header */
	++test;
	article_remove_header (a1, HEADER_SUBJECT);
	if (a1->subject!=NULL) return test;
	g_message ("PASS article_remove_header");

	/* set header: chunk */
	++test;
	article_set_header (a1, HEADER_SUBJECT, cpch, DO_CHUNK);
	if (a1->subject==NULL || a1->subject==cpch) return test;
	if (pan_strcmp(a1->subject, cpch)) return test;
	g_message ("PASS article_set_header, do chunk");

	/* set-author-from-header */
	++test;
	a = a1;

	article_set_author_from_header (a, "joe@foo.com");
	article_get_author_str (a, buf, sizeof(buf));
	if (pan_strcmp(buf, "\"joe\" <joe@foo.com>")) return test;
	article_get_short_author_str (a, buf, sizeof(buf));
	if (pan_strcmp(buf, "joe")) return test;

	article_set_author_from_header (a, "joe@foo.com (Joe Bob)");
	article_get_author_str (a, buf, sizeof(buf));
	if (pan_strcmp(buf, "\"Joe Bob\" <joe@foo.com>")) return test;
	article_get_short_author_str (a, buf, sizeof(buf));
	if (pan_strcmp(buf, "Joe Bob")) return test;

	article_set_author_from_header (a, "Joe Bob <joe@foo.com>");
	article_get_author_str (a, buf, sizeof(buf));
	if (pan_strcmp(buf, "\"Joe Bob\" <joe@foo.com>")) return test;
	article_get_short_author_str (a, buf, sizeof(buf));
	if (pan_strcmp(buf, "Joe Bob")) return test;

	article_set_author_from_header (a, "Joe Bob");
	article_get_author_str (a, buf, sizeof(buf));
	if (pan_strcmp(buf, "\"Joe Bob\" <unknown@spammesenseless.net>")) return test;
	article_get_short_author_str (a, buf, sizeof(buf));
	if (pan_strcmp(buf, "Joe Bob")) return test;
	g_message ("PASS article_set_author_from_header 1");


	/* encoded authors */
	++test;
	article_set_author_from_header (a1,
		"\"Jrgen Irgendwie\" <juergen.irgendwie@email.com>");
	if (pan_strcmp(a1->author_addr,
		"juergen.irgendwie@email.com")) return test;
	if (pan_strcmp(a1->author_real, "Jrgen Irgendwie")) return test;
	article_get_author_str (a1, buf, sizeof(buf));
	if (pan_strcmp(buf, "\"Jrgen Irgendwie\" <juergen.irgendwie@email.com>")) return test;
	article_get_short_author_str (a1, buf, sizeof(buf));
	if (pan_strcmp(buf,"Jrgen Irgendwie")) return test;
	g_message ("PASS article_set_author_from_header");

	/* more encoded authors */
	++test;
	cpch = "some@email.com (M. =?ISO-8859-1?Q?H=F6lle?=)";
	article_set_author_from_header (a, cpch);
	if (pan_strcmp (a->author_addr,"some@email.com")) return test;
	if (pan_strcmp (a->author_real,"M. Hlle")) return test;
	article_get_author_str (a, buf, sizeof(buf));
	if (pan_strcmp (buf, "\"M. Hlle\" <some@email.com>")) return test;
	article_get_short_author_str (a, buf, sizeof(buf));
	if (pan_strcmp (buf, "M. Hlle")) return test;
	g_message ("PASS encoded author header test");

	/* success */
	g_message ("All article tests passed");
	return 0;
}
