#ifndef INCLUDE_WINDOW_H
#define INCLUDE_WINDOW_H

#include "Connection.h"

class BaseWindow {

 public:

  BaseWindow();
  virtual ~BaseWindow();

  // Returns the item factory for the menu
  virtual GtkItemFactory * getItemFactory();

  // Event generated - we switched to page x.
  virtual void pageSwitch(int);

  // Please switch to the next page.
  virtual void nextPage();
  // Please switch to page x.
  virtual void switchPage(int);

  // Please attempt to swallow an application.
  virtual void swallow();

  // Please close the currently active window.
  virtual void closeWindow();

  // Please add a notebook page with specified name.
  virtual GtkWidget * addPageForApp(char *);

  // Please add a page with specified name and specified contents.
  virtual void addPage(char *, GtkWidget *);

  // Add a notebook page with this connection in it.
  virtual void addConnection(Connection *);

  virtual void removeConnection(Connection *);
  virtual Connection * getCurrentConnection();

  virtual void nextText(Connection *);

  virtual void addCustomMenu(char *, GtkItemFactoryCallback);

  virtual void setToolbarVisible(bool);
  virtual void getDimensions(int *, int *);

  virtual void display();

  virtual void setTitleBar(char *);
  virtual void setIcon(char *);

 private:

};

#endif //  INCLUDE_WINDOW_H
