#ifndef INCLUDE_TRIGGER_ENTITY_H
#define INCLUDE_TRIGGER_ENTITY_H

#include "Connection.h"
#include "Entity.h"

#include <regex.h>

typedef enum {
  TriggerSimple,
  TriggerRegex
} TriggerType;

class TriggerEntity : public Entity {

 public:

  TriggerEntity();
  ~TriggerEntity();

  void setMudName(char *);
  void setText(char *);
  void setTriggerType(TriggerType);
  void setBody(char *);
  void setStripColour(bool);

  char * getMudName();
  char * getText();
  TriggerType getTriggerType();
  char * getBody();
  bool getStripColour();

  void save(FILE *);
  bool load(FILE *, char *);

  void execute(Connection *, char *, char *);
  bool findExecute(EntityType, char *, char *, void *, bool);

  GtkWidget * getWidgets();

  void apply();

 private:

  void compile();

  char * mud;
  char * body;
  char * text;
  TriggerType trigger_type;

  GtkWidget *trigger_name;
  GtkWidget *trigger_text;
  GtkTextBuffer * trigger_description_buffer;
  GtkTextBuffer * trigger_body_buffer;
  GtkWidget *trigger_options;
  GtkWidget *option_menu;
  GtkWidget *colour_checkbutton;

  regex_t regexp;

  bool stripColour;
};

#endif // INCLUDE_TRIGGER_ENTITY_H
