/**
 * SamplePlugin; an example plugin for Papaya.
 *
 * Only include system level header files from your plugin, plus your
 * plugin's header file and Win32PluginAPI.cpp.
 */


// Include your plugin's own header file.
#include "SamplePlugin.h"

// All plugins must include this, even on UNIX platforms where .sos are sane.
#include "Win32PluginAPI.cpp"

static SamplePlugin * sample;

// Configure the minor and major versions of this plugin.
#define MAJOR "1"
#define MINOR "0"

extern "C" G_MODULE_EXPORT void plugin_init(plugin_address_table_t * pat) {
  plugin_address_table_init(pat);
  sample = new SamplePlugin();
}

extern "C" G_MODULE_EXPORT void plugin_cleanup(void) {
  delete sample;
}

extern "C" G_MODULE_EXPORT char * plugin_query_name() {
  return "SamplePlugin";
}

extern "C" G_MODULE_EXPORT char * plugin_query_description() {
  return "";
}

extern "C" G_MODULE_EXPORT char * plugin_query_major() {
  return MAJOR;
}

extern "C" G_MODULE_EXPORT char * plugin_query_minor() {
  return MINOR;
}

SamplePlugin::SamplePlugin() {
  version = 1.0;
  name = strdup("SamplePlugin");

  // This MUST be done after all variable initialisation as it can cause
  // onEvent(Event *, Connection *) to be called.
  register_plugin(this, VERSION);

  // If you want to analyse any input, output, prompts or telnet options, uncomment the appropriate lines.
  //  plugin_handler_add_output_filter(get_plugin_handler(), this);
  //  plugin_handler_add_intput_filter(get_plugin_handler(), this);
  //  plugin_handler_add_prompt_filter(get_plugin_handler(), this);
  //  plugin_handler_add_telopt_filter(get_plugin_handler(), this);
}

SamplePlugin::~SamplePlugin() {
  free(name);

  unregister_plugin(this);
}

// Uncomment this if you want to parse input from the user
//void G_MODULE_EXPORT SamplePlugin::input(Connection * conn, char * input) {
//}

// Uncomment this if you want to parse output from the MUD
//void G_MODULE_EXPORT SamplePlugin::output(Connection * conn, char * input) {
//}

// Uncomment this if you want to parse incoming prompts
//void G_MODULE_EXPORT SamplePlugin::prompt(Connection * conn, char * input) {
//}

// Uncomment this if you want to respond to servers negotiating various options
//bool G_MODULE_EXPORT SamplePlugin::teloptAllowRemote(Connection * conn, int option) {
//  return false;
//}

// Uncomment this to perform functions when a remote option's state changes.
//void G_MODULE_EXPORT SamplePlugin::teloptHandleRemote(Connection * conn, int option, bool onoff) {
//}

// Uncomment this if you want to support local telnet options.
//bool G_MODULE_EXPORT SamplePlugin::teloptAllowLocal(Connection * conn, int option) {
//  return false;
//}

// Uncomment this if you want to do telnet suboption negotiation.
//void G_MODULE_EXPORT SamplePlugin::teloptSubneg(Connection * conn, int option, char * data, int data_len) {
//}

// Uncomment this if you want to respond to "EvConnect" and "EvDisconnect"
// events.
//void G_MODULE_EXPORT SamplePlugin::onEvent(Event * event, Connection * conn) {
//}

// Uncomment this if you want to receive TurfProtocol client messages.
//void G_MODULE_EXPORT SamplePlugin::clientMessage(Connection * conn, char * text) {
//}
