#include <malloc.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include "zchat.h"

extern int session_id;
extern struct connection * first_connection;

void zchat_name_change(struct connection * c, struct zmudheader * zhead, char * data) {
  char buf[16384];

  data[zhead->id] = '\0';
  if (c->clientinfo.name)
    free(c->clientinfo.name);

  c->clientinfo.name = strdup(data);
  
  sprintf(buf, "*** Client %d has changed name to %s. ***\n", c->fd, data);
  output_append(buf);
}


void zchat_request_connections(struct connection * c, struct zmudheader * zhead, char * data) {
  char buf[16384];
  char buf2[16384];
  int first = 0;
  struct connection * tmp = first_connection;
  struct command * cmd = new_command();

  buf[0] = '\0';
  buf2[0] = '\0';

  for (; tmp; tmp = tmp->next) {
    if (c->status == ConnConnected && c->client) {
      int port = ntohs(c->client->sin_port);

      if (first)
	sprintf(buf2, ",%s,%d", c->hostname, port);
      else {
	sprintf(buf2, "%s,%d", c->hostname, port );
	first++;
      }

      strcat(buf, buf2);
    }
  }

  /* Make a command with buf as the data. */
  cmd->id = ConnectionList;
  cmd->len = strlen(buf);
  cmd->data = strdup(buf);

  build_command(cmd);
  send_command(c, cmd);
}

void zchat_connection_list(struct connection * c, struct zmudheader * zhead, char * data) {

  char * pc = data;
  char * host = pc;
  char * port;

  while ((pc = strchr(pc, ','))) {
    
    if (!pc)
      return;

    *pc = '\0';
    pc++;

    port = pc;
    pc = strchr(pc, ',');
    
    if (pc)
      *pc = '\0';

    pc++;

    printf("Connection from %s:%s", host, port);
    host = pc;
  }

  /* @@ Do something with this list. */

}

void zchat_text_everybody(struct connection * c, struct zmudheader * zhead, char * data) {

  char * text = data + 4;
  int id;

  memcpy(&id, data, 4);
  if (id == session_id)
    return;

  /* @@ Propagate this message to all our clients. */

  data[zhead->len] = '\0';
  output_append(text);
}


void zchat_text_personal(struct connection * c, struct zmudheader * zhead, char * data) {
  char * text = data + 4;
  int id;

  memcpy(&id, data, 4);
  if (id == session_id)
    return;

  data[zhead->len] = '\0';
  output_append(text);
}

void zchat_text_group(struct connection * c, struct zmudheader * zhead, char * data) {
  char * text = data + 4;
  int id;

  memcpy(&id, data, 4);
  if (id == session_id)
    return;

  data[zhead->len] = '\0';
  output_append(text);
}

void zchat_message(struct connection * c, struct zmudheader * zhead, char * data) {
  char * text = data + 4;
  int id;

  memcpy(&id, data, 4);
  if (id == session_id)
    return;

  data[zhead->len] = '\0';
  output_append(text);
}

void zchat_version(struct connection * c, struct zmudheader * zhead, char * data) {
  data[zhead->len] = '\0';

  if (c->clientinfo.version)
    free(c->clientinfo.version);
  c->clientinfo.version = strdup(data);

  printf("Set client version to %s.\n", c->clientinfo.version);
}

void zchat_ping_request(struct connection * c, struct zmudheader * zhead, char * data) {

  /* Create a command, and set the data field to be anything. */
  struct command * cmd = new_command();

  cmd->data = strdup("");
  cmd->id = PingRequest;
  cmd->len = 0;

  send_command(c, cmd);
}

void zchat_ping_response(struct connection * c, struct zmudheader * zhead, char * data) {

  /* We need to see what the time is now, and compare this to the time we
   * initiated a ping_request.
   */

}

void zchat_icon(struct connection * c, struct zmudheader * zhead, char * data) {
}

void zchat_status(struct connection * c, struct zmudheader * zhead, char * data) {
  c->clientinfo.status = *data;
}

void zchat_email_address(struct connection * c, struct zmudheader * zhead, char * data) {
  data[zhead->len] = '\0';

  if (c->clientinfo.email)
    free(c->clientinfo.email);
  c->clientinfo.email = strdup(data);

  printf("Set client email address to %s.\n", c->clientinfo.email);
}

void zchat_request_pgp_key(struct connection * c, struct zmudheader * zhead, char * data) {
}

void zchat_pgpkey(struct connection * c, struct zmudheader * zhead, char * data) {
}

void zchat_send_command(struct connection * c, struct zmudheader * zhead, char * data) {
}

void send_stamp() {
  struct command * cmd = new_command();
  cmd->id = Stamp;
  cmd->len = 4;
  cmd->data = (char *)malloc(4);
  memcpy(cmd->data, &session_id, 4);

  send_command_to_all(cmd);
}

void zchat_stamp(struct connection * c, struct zmudheader * zhead, char * data) {

  int id;
  memcpy(&id, data, 4);

  if (id == session_id) {
    session_id = rand();
    send_stamp();
  }
}

