/*
   ____    _ __           ____               __    ____
  / __/___(_) /  ___ ____/ __ \__ _____ ___ / /_  /  _/__  ____
 _\ \/ __/ / _ \/ -_) __/ /_/ / // / -_|_-</ __/ _/ // _ \/ __/
/___/\__/_/_.__/\__/_/  \___\_\_,_/\__/___/\__/ /___/_//_/\__(_)

Copyright on 2012 SciberQuest Inc.
*/
#include "pqSQFieldTracer.h"

#include <QCheckBox>
#include <QWidget>

#include <iostream>

//-----------------------------------------------------------------------------
pqSQFieldTracer::pqSQFieldTracer(
      pqProxy* pxy,
      QWidget* p)
             :
  pqAutoGeneratedObjectPanel(pxy,p)
{
  #if defined pqSQFieldTracerDEBUG
  std::cerr << ":::::pqSQFieldTracer::pqSQFieldTracer" << std::endl;
  #endif

  // master and worker block sizes are only relevant if
  // dynamic scheduling is selected. If it is not selected
  // then disable master, and worker block entries.

  QCheckBox *dynSched
    = this->findChild<QCheckBox*>("UseDynamicScheduler");

  QWidget *masterBlock=this->findChild<QWidget*>("MasterBlockSize");
  QWidget *workerBlock=this->findChild<QWidget*>("WorkerBlockSize");

  // disable signals during construction. PV 3.16 will create/destroy
  // the panel as the object is selected/unselected in the browser.
  this->blockSignals(true);
  dynSched->blockSignals(true);
  masterBlock->blockSignals(true);
  workerBlock->blockSignals(true);

  // initialize based on current state, set by PV SM.
  if (!dynSched->isChecked())
    {
    masterBlock->setEnabled(false);
    workerBlock->setEnabled(false);
    }

  // sync dyanmic load balancing toggle and its assoiciated items
  connect(dynSched,SIGNAL(clicked(bool)),masterBlock,SLOT(setEnabled(bool)));
  connect(dynSched,SIGNAL(clicked(bool)),workerBlock,SLOT(setEnabled(bool)));

  // enable signals now that things are setup.
  this->blockSignals(false);
  dynSched->blockSignals(false);
  masterBlock->blockSignals(false);
  workerBlock->blockSignals(false);
}

//-----------------------------------------------------------------------------
void pqSQFieldTracer::accept()
{
  #if defined pqSQFieldTracerDEBUG
  std::cerr << ":::::pqSQFieldTracer::accept" << std::endl;
  #endif

  /* -- I don't recall why this was done, and I don't see
        a good reason for it now.

  // dynamic scheduling can only be selected prior to the
  // first apply, because of some technicallity in the way
  // PV pipeline executes. Prevent changes after first
  // apply.

  QCheckBox *dynSched
    = this->findChild<QCheckBox*>("UseDynamicScheduler");

  dynSched->setEnabled(false);
  */

  this->pqAutoGeneratedObjectPanel::accept();
}
