/*****************************************************************************
 *                                                                           *
 * Program:   paul                                                           *
 *            (P)rogramm zur (A)uswertung und (U)mformung von                *
 *            (L)aserbildern                                                 *
 * Uses:      GTK+ 1.2                                                       *
 * Modul:     gtkpaul.c                                                      *
 *            GTK interface for paul                                         *
 * Author:    Andreas Tille                                                  *
 * Date:      14.06.1998                                                     *
 * Copyright: Andreas Tille, 1999; GNU Public License                        *
 *                                                                           *
 *****************************************************************************/

#include <ctype.h>
#include "paul.h"
#include "callback.h"
 

static char * backward_xpm[] = {
"15 17 4 1",
"       c None s None",
".      c #BFBBFF",
"X      c #3F3F3F",
"o      c black",
"              .",
"             ..",
"           .XX.",
".        .XooX.",
"       .XooooX.",
"     .XooooooX.",
"   .XooooooooX.",
" .XXoooooooooX.",
".XXooooooooooX.",
" .XXoooooooooX.",
"   .XooooooooX.",
"     .XooooooX.",
"       .XooooX.",
"         .XooX.",
"           .XX.",
"             ..",
"              ."};

static char * stop_xpm[] = {
"16 16 4 1",
"       c None s None",
".      c #BFBFBF",
"X      c #3F3F3F",
"o      c black",
" .............. ",
".XXXXXXXXXXXXXX.",
".XooooooooooooX.",
".XooooooooooooX.",
".XooooooooooooX.",
".XooooooooooooX.",
".XooooooooooooX.",
".XooooooooooooX.",
".XooooooooooooX.",
".XooooooooooooX.",
".XooooooooooooX.",
".XooooooooooooX.",
".XooooooooooooX.",
".XooooooooooooX.",
".XXXXXXXXXXXXXX.",
" .............. "};

static char * foreward_xpm[] = {
"15 17 4 1",
"       c None s None",
".      c #BFBFBF",
"X      c #3F3F3F",
"o      c black",
".              ",
"..             ",
".XX.           ",
".XooX.         ",
".XooooX.       ",
".XooooooX.     ",
".XooooooooX    ",
".XoooooooooXX. ",
".XooooooooooXX.",
".XoooooooooXX. ",
".XooooooooX.   ",
".XooooooX.     ",
".XooooX.       ",
".XooX.         ",
".XX.           ",
"..             ",
".              "};

int CreatePicture(PAUL *p)
/* create initial window, define event functions and show window
 */
{
  p->show = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_usize(p->show, BILD(p->piclist)->W, BILD(p->piclist)->H);
  gtk_widget_set_uposition(p->show, 0, 0);
  
  gtk_widget_set_events(p->show, gtk_widget_get_events(p->show) | 
                        GDK_BUTTON_MOTION_MASK |
                        GDK_POINTER_MOTION_HINT_MASK | GDK_POINTER_MOTION_MASK |
                        GDK_BUTTON_PRESS_MASK );

  gtk_widget_realize(p->show); /* creates the window which is checked in the following test */
  g_return_val_if_fail ( p->show->window, RET_ERR );
  gtk_widget_show(p->show);
  gtk_clist_select_row(GTK_CLIST(p->filelist), 0, 0);

  gdk_window_set_hints(p->show->window, 0, 0, 0, 0, 0, 0, GDK_HINT_MIN_SIZE);
  gtk_signal_connect(GTK_OBJECT(p->show), "key_press_event", GTK_SIGNAL_FUNC(PictureKeyPressed), p);
  gtk_widget_set_app_paintable (p->show, TRUE);   
  gtk_signal_connect(GTK_OBJECT(p->show), "configure_event", GTK_SIGNAL_FUNC(ConfigureCallback), p);
  return RET_OK;
}

static GtkWidget *PixButton(GtkWidget *hbox, char **xpm, GdkWindow *dummy)
{
  GtkWidget *button, *label_box, *pixwid;
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GdkColor  *transparent = NULL;

  button = gtk_button_new();
  gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 2);
  
  pixmap = gdk_pixmap_create_from_xpm_d(dummy, &mask, transparent, xpm);
  label_box = gtk_hbox_new (FALSE, 0);
  pixwid    = gtk_pixmap_new(pixmap, mask);
  gtk_container_add (GTK_CONTAINER(label_box), pixwid);
  gtk_misc_set_padding(GTK_MISC(pixwid), 3, 1);
  gtk_container_add(GTK_CONTAINER(button), label_box);

  return button;
}

static int CreateControlNotebook(PAUL *p)
/* Create notebook containing animation control buttons
 */
{
  GtkWidget *hbox, *bb, *bs, *bf, *dummy;

  g_return_val_if_fail ( IS_PAUL(p), RET_ERR );
  if ( p->ctrl && GTK_IS_NOTEBOOK(p->ctrl) ) return RET_OK;

  p->ctrl = gtk_notebook_new();
  gtk_notebook_set_show_tabs(GTK_NOTEBOOK(p->ctrl), FALSE);
  gtk_notebook_set_show_border(GTK_NOTEBOOK(p->ctrl), FALSE);

  hbox = gtk_hbox_new(FALSE, 10);
  gtk_notebook_append_page(GTK_NOTEBOOK(p->ctrl), hbox, NULL);

  dummy = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_widget_realize(dummy); /* creates the GdkWindow which is needed to create the pixmaps */

  bb = PixButton(hbox, backward_xpm, dummy->window);
  gtk_signal_connect(GTK_OBJECT(bb), "clicked", GTK_SIGNAL_FUNC(PictureAnimate), p);

  bs = PixButton(hbox, stop_xpm, dummy->window);
  gtk_signal_connect(GTK_OBJECT(bs), "clicked", GTK_SIGNAL_FUNC(StopPictureAnimate), p);  

  bf = PixButton(hbox, foreward_xpm, dummy->window);
  gtk_signal_connect(GTK_OBJECT(bf), "clicked", GTK_SIGNAL_FUNC(PictureAnimate), p);
  gtk_widget_destroy(dummy);

  gtk_object_set_user_data(GTK_OBJECT(p->ctrl), bb);
  gtk_object_set_user_data(GTK_OBJECT(bb), bs);
  gtk_object_set_user_data(GTK_OBJECT(bs), bf);
  gtk_object_set_user_data(GTK_OBJECT(bf), bb);
 
  gtk_widget_show_all(p->ctrl);
  SetAnimateControl(p);
  ButtonSensitive(p);
  return RET_OK;
}

int GtkInterface(PAUL *p)
/* create GTK interface for paul
 * --- Parameter: ---
 * PAUL *p              : PAUL structure
 * --- Return: ---
 * int   GtkInterface() : RET_OK or RET_ERR
 */
{
  GtkWidget           *PaulWindow;      /* Menue + main_vbox                         */
  GtkWidget           *p_table,         /* filelist, operation image, animate button */
                      *vbox;            /* vbox containing menubar and p_table       */
  GtkAccelGroup       *accel_group;

  g_return_val_if_fail ( IS_PAUL(p), RET_ERR );

  gtk_widget_push_visual(gdk_imlib_get_visual());
  gtk_widget_push_colormap(gdk_imlib_get_colormap());

  /* create the dialog box */
  PaulWindow = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_uposition(PaulWindow, MIN((p->piclist ? BILD(p->piclist)->W+10 : 500),500), 0);
  gtk_signal_connect(GTK_OBJECT(PaulWindow), "destroy", GTK_SIGNAL_FUNC(DoPaulExit), p);
  gtk_signal_connect(GTK_OBJECT(PaulWindow), "delete-event", GTK_SIGNAL_FUNC(gtk_true), NULL);

  gtk_window_set_title(GTK_WINDOW(PaulWindow), exename);

  vbox = gtk_vbox_new (FALSE, 1);

  accel_group = gtk_accel_group_new();
  p->items    = gtk_item_factory_new(GTK_TYPE_MENU_BAR, "<main>", accel_group);
  if ( BuildMenu(p) == RET_ERR ) return RET_ERR; 

  gtk_accel_group_attach(accel_group, GTK_OBJECT(PaulWindow));

  gtk_box_pack_start(GTK_BOX(vbox), gtk_item_factory_get_widget(p->items, "<main>"),
			  FALSE, FALSE, 0);
  
  gtk_container_add(GTK_CONTAINER(PaulWindow), vbox);
  gtk_container_set_border_width(GTK_CONTAINER(vbox), 3);

  p_table = gtk_table_new(4, 1, FALSE);
  gtk_container_add(GTK_CONTAINER(vbox), p_table);
   
  p->w = gtk_scrolled_window_new(NULL, NULL);
  gtk_object_set_user_data(GTK_OBJECT(p->w), NULL);  /* set userdata explicitely NULL */
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(p->w), 
                                 GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_widget_set_usize(p->w, 250, 350);
  gtk_table_attach_defaults(GTK_TABLE(p_table), p->w, 0, 1, 0, 1);
  
  CreateGtkListOfImages(p);
  gtk_container_add(GTK_CONTAINER(p->w), GTK_WIDGET(p->filelist));
  
  p->activ = p->piclist;
#ifdef PHYSICAL_PAUL
  if ( PG && PG->D && PG->Dt ) ShowPhaseCurve(p, PG);
#endif
 
  if ( p->op ) CreateOperationImageWindow(p);

  if ( CreateControlNotebook(p) == RET_OK ) 
    gtk_table_attach_defaults(GTK_TABLE(p_table), p->ctrl, 0, 1, 2, 3);

  if ( CreatePicture(p) ) {
    g_warning(_("Cannot create window to show images"));
    PaulExit(p);
  }
  if ( IsAnimation(p->opt) ) PictureAnimate(NULL, p);

  MenueSensitive(p);
  if ( HistogrammFlag(p->opt->f) ) ShowHistograms(p->piclist);
  gtk_widget_show_all(PaulWindow);
  

  return RET_OK;
}
