# pcd2html: package pcd2html_uti.pm
# Copyright Andreas Tille <tille@physik.uni-halle.de>
#
# Perl utilities and names for pcd2html
$sysconfdir = "/etc" ;
$configname = "pcd2html.conf" ;
$pcd_info = "photo_cd/info.pcd" ;
$pcd2html_home = $ENV{"HOME"} . "/.pcd2html" ;
$pcd_css = "pcd.css" ;

$config = "$sysconfdir/$configname";
stat($config) || die "Missing config file $config" ; 
open(CONF, $config) || die "Error while opening config file $config" ;
while ( <CONF> ) {
  unless ( /[ \t]*#/ ) {
    chomp( $cdrom = $_ );
  }
}
close(CONF) || die "Error while closing file $config" ;

$LinkTdString = 'td class="linktype"' ;

%english = ( "hext",   ".html" ,
             "lang",   "en" ,
             "next",   "next" ,
             "prev",   "previous",
             "back",   "back to index page" ,
             "text",   ".eng" ,
             "index",  "index.html" ,
             "otitle", "Deutsche Version dieser Seite" ,
             "slide",  "Slide show of all these images" ,
             "back_m", "back to main page" ,
             "top",    "back" ,
             "home",   "Home page" ,
             "other",  "index_de.html"
	    );
%german = (  "hext",  "_de.html" ,
             "lang",  "de" ,
             "next",  "n&auml;chstes" ,
             "prev",  "vorhergehendes" ,
             "back",  "zur&uuml;ck zur Indexseite" ,
             "text",  ".deu" ,
             "index", "index_de.html" ,
             "otitle", "English copy of this page",
             "slide",  "Alle Bilder nacheinander" ,
             "back_m", "zur&uuml;ck zur Hauptseite" ,
             "top",    "zur&uuml;ck" ,
             "home",   "Hauptseite" ,
             "other",  "index.html"
  	    );

$pcd2html_uti = "pcd2html_uti" ;

# check whether a CD is mounted and try to mount if fail
# return true if the mounted CD is a Kodak Photo CD
sub mounted_pcd {
  unless ( mounted() ) {
    unless ( $ENV{"OSTYPE"} =~ /linux/i ) {
      warn "Don't know how to mount CD drive on an " . $ENV{"OSTYPE"} . " system\n" ;
      return 0;
    }
    print "Warning: CD not mounted at $cdrom.  Trying to mount...\n" ;
    unless ( `cat /etc/fstab` =~ /$cdrom/ ) { 
      warn "Error: $cdrom not contained in /etc/fstab.  Giving up.\n" ;
      return 0;
    }
    if ( system ( "mount $cdrom" ) ) {
      warn "Unable to mount $cdrom.  Please ask your system administrator." ;
      return 0;
    }
  }

  unless ( stat("$cdrom/$pcd_info") ) {
    warn "CD in $cdrom doesn't seem to be a Kodak Photo CD!\n";
    return 0;
  }
  return 1;
}

# Check output of `mount` for CD dircetory
sub mounted {
  $mounted = `mount`;

  if ( $mounted =~ /$cdrom/ ) { 
    return 1
  }
  return 0;
}


#### Method: pcd_get_key
# Obtain Kodak Photo CD keys
#
####
sub pcd_get_key {
  my ( $key, $info, %keys ) ;

  unless ( mounted_pcd() ) {
    warn "No Kodak Photo CD mounted on $cdrom.\n";
    return undef ;
  }
  
  unless ( open(INFO, "$cdrom/$pcd_info" ) ) {
     warn "Error while opening Kodak Photo CD information\n" ;
     return undef ;
  }
  chomp ($info = <INFO>) ;
  close(INFO) ;
  $info =~ s/[^0-9]*([0-9]*)[^0-9].*/$1/ ;
  
  if ( stat( "$pcd2html_home" ) ) {
    unless ( open(HOME, "$pcd2html_home" ) ) {
      warn "Error while opening $pcd2html_home\n" ;
      return undef ;
    }
    while ( <HOME> ) {
      unless ( /[ \t]*#/ ) {
        chomp ;
        s/# .*// ;
        $a = $b = $_ ;
        $a =~ s/[ \t]*(\w*)[ \t].*/$1/ ;
        $b =~ s/[ \t]*$a[ \t]*(\w*)[ \t]*.*/$1/ ;
        $keys{$b} = $a ;
      }
    }
    close(HOME);
    $key = $keys{$info} ;
  } else {
    unless ( open(HOME, ">$pcd2html_home" ) ) {
      warn "Error while creating $pcd2html_home\n" ;
      return undef;
    }
    select (HOME) ;
    print "# pcd2html: keys for different Kodak Photo CDs\n" ;
    print "# <key used in rules file> <specification number of CD>\n";
    print "#\n" ;
    select (STDOUT) ;
    close(HOME) ;
  }  
  unless ( $key ) {
    print "This Kodak Photo CD was not used before.\n" ;
    print "Which key should be used in the rules file? " ;
    while ( 1 ) {
      $key = <STDIN> ;
      chomp ( $key ) ;
      unless ( $key =~ /\W/ ) { last ; }
      print "Only letters, digits and `_` are allowed in keys\n" ;
      print "Please insert valid key! " ;
    }
    unless ( open(HOME, ">>$pcd2html_home" ) ) {
      warn "Error while opening $pcd2html_home\n" ;
      return undef ;
    }
    select (HOME) ;
    print "$key $info\n" ;
    select (STDOUT) ;
    close(HOME) ;
  }
  return $key ;
}  

sub OpenRules {
  unless ( -f "rules" ) {
    print STDERR "There is no rules file.\n" ;
    return -1;
  }

  unless  ( pcd_get_key() ) {
    print STDERR "pcd2html: Sorry, can't obtain PCD key.\n" ;
    return -1;
  }

  unless ( open(RULES, "rules" ) ) {
    print STDERR "Error while opening rules. ($!)\n" ;
    return -1 ;
  }
  return 0;
}

######################################################
# Get author from finger information
#
sub GetAuthor {
  @finger = `finger $ENV{"LOGNAME"}` ;
  foreach ( @finger ) {
    if ( /Name/ ) {
      chomp ;
      s/.*Name: *//;
      return $_ ;
    }
  }
}

sub GetDate {
  $_ = `date +%Y-%m-%d%t%T%z` ; 
  chomp ;
  return $_ ;
}

#############################################################
# Get email from environment or build from loginname@host
#
sub GetEmail {
  my ( $email ) ;

  $email = $ENV{"EMAIL"} ;
  if ( defined( $email ) && $email =~ /\w/ ) { 
    return $email ; 
  }
  $_ = `hostname` ;
  $_ = `host $_` ;
  /([^\s]*)/ ;

  return $ENV{"LOGNAME"} . "\@$1" ;
}

##############################################################
# Read first line (without #) as title information
#
sub GetTitle {
  my ($title, $file) ;

  $file="$_[0]$_[2]" ;
  if ( -f $file ) {
    open(FILE, $file ) || die "Unable to open $file\n" ;
    while ( <FILE> ) {
      unless ( /^#/ ) {
        chomp ;
        $title = $_ ;
	last ;
      }
    }
    close FILE ;
    $textfile = $file ;
  } else {
    $title = $_[1] ;
    $textfile = "none" ;
  }
  return ( $title, $textfile ) ;
}

################################################################
#  Print header of HTML information with certain keywords
#
sub MyHtmlStart{
  my ( $title, $author, $date, $keywords, $css, $internal ) ;
  
  $author = GetAuthor() ;
  $date   = GetDate() ;
  $title    = $_[0];
  $keywords = $_[1];
  $content  = $_[2];
  $css      = $_[3];
  $internal = $_[4];

  print '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0//EN">' ;
  if ( defined ($internal) ) {
    print $internal ;
  }
  print "\n<html>\n<head>\n" ;
  print "<title>$title</title>\n" ;

  print "<meta name=\"date\" content=\"$date\">\n" ;
  print "<meta name=\"author\" content=\"$author\">\n" ;
  print "<meta name=\"generator\" content=\"pcd2html\">\n" ;
  if ( defined ( $keywords ) ) {
    print '<meta name="keywords" lang="' . $item{"lang"} . "\" content=\"$keywords\">\n" ;
  }
  if ( defined ( $content ) ) {
    print '<meta name="content" lang="' . $item{"lang"} . "\" content=\"$content\">\n" ;
  }
  if ( defined ( $css ) ) {
    print "<link rel=stylesheet type=\"text/css\" href=\"$css\">\n" ;
  }
  print "</head>\n<body>\n" ;
}

###################################################################
# Print end of HTML information with subscription
#
sub MyHtmlEnd {
  my ( $email, $using, $date, $author );

  $_ = GetDate() ;
  /([\-\d]*).*/ ;
  $date = $1 ;
  print "<p class=\"footer\">\n" ;
  if ( $_[0] eq "de" ) {
    print "Diese Seite wurde am " ;
    $_ = $date ;
    /(\d*)-(\d*)-(\d*)/ ;
    print "$3.$2.$1 durch " ;
    $using = "mittels" ;
  } else {
    print "This page was created on $date by " ;
    $using = "using" ;
  }
  $email  = GetEmail() ;
  $author = GetAuthor() ;
  print "<a href=\"mailto:$email\">$author</a> $using pcd2html" ;
  if ( $_[0] eq "de" ) { print " erstellt" ; }
  print ".\n</small>\n</body>\n</html>\n" ;
}

###################################################################
#  Read complete file information into a single string
#
sub File2String {
  my ( $string ) ;

  if ( -f $_[0] ) {
    open(FILE, $_[0] ) || die "Unable to open $$_[0] file\n" ;
    $string = "" ;
    while ( <FILE> ) {
      unless ( /[ \t]*#/ ) {
        chomp ;
        $string = "$string $_" ;
      }
    }
    close FILE ;
  }
  return $string ;
}

############################################################################
#  Convert file contents to HTML
#  blank lines  -> <br>
#  8 bit ISO -> HTML
#  --- Parameters: ---
#  $filename
#  optional flag, if first valid line (== title) should be printed as
#  heading line (default) or should be suppressed on the page if (flag == 0)
#
sub File2HTML {
  my ( $filename, $print_headline, $i );

  $filename    = $_[0] ;
  $print_headline = 0;
  if ( defined ( $_[1] ) && $_[1] == 0 ) {
      $print_headline = 1 ;
  }
  
  $i = 0;
  unless ( open(TEXT, "$filename" ) ) {
    warn "Error while opening $filename.\n" ;
  } else {
    while ( <TEXT> ) { 
      unless ( /^#/ ) {
        if ( $print_headline && $i == 0 && /$title/ ) { next ; }
        $i++ ;
        Iso2Html () ;
        if ( /^\s*$/ ) { print "<br>\n" ; } 
	print ; 
      }
    }
    close TEXT ;
  }
}

###################################################################
#  Search for file with <name>.<ext> where <name> is the argument
#  of this function and <ext> some known extensions of image file
#  formats.  Returns first valid image name found.
#
sub ExistingPicWithName {
  my ( $name, $ext, @extensions ) ;
  @extensions = ( "jpg", "gif", "png", "tif" ) ;

  $name = $_[0] ;
  unless ( defined($name) ) { return undef ; }

  foreach $ext (@extensions) {
    if ( -f "$name.$ext" ) {
      return "$name.$ext" ;
    }
  }
  return undef ;
}

##################################################################
#  Convert 8 bit ISO characters into HTML syntax
#
sub Iso2Html {
  s//\&Aring;/ ;
  s//\&AElig;/ ;
  s//\&Ccedil;/ ;
  s//\&Egrave;/ ;
  s//\&Eacute;/ ;
  s//\&Ecirc;/ ;
  s//\&Euml;/ ;
  s//\&Igrave;/ ;
  s//\&Iacute;/ ;
  s//\&Icirc;/ ;
  s//\&Iuml;/ ;
  s//\&ETH;/ ;
  s//\&Ntilde;/ ;
  s//\&Ograve;/ ;
  s//\&Oacute;/ ;
  s//\&Ocirc;/ ;
  s//\&Otilde;/ ;
  s//\&Ouml;/ ;
  s//\&times;/ ;
  s//\&Oslash;/ ;
  s//\&Ugrave;/ ;
  s//\&Uacute;/ ;
  s//\&Ucirc;/ ;
  s//\&Uuml;/ ;
  s//\&Yacute;/ ;
  s//\&THORN;/ ;
  s//\&szlig;/ ;
  s//\&agrave;/ ;
  s//\&aacute;/ ;
  s//\&acirc;/ ;
  s//\&atilde;/ ;
  s//\&auml;/ ;
  s//\&aring;/ ;
  s//\&aelig;/ ;
  s//\&ccedil;/ ;
  s//\&egrave;/ ;
  s//\&eacute;/ ;
  s//\&ecirc;/ ;
  s//\&euml;/ ;
  s//\&igrave;/ ;
  s//\&iacute;/ ;
  s//\&icirc;/ ;
  s//\&iuml;/ ;
  s//\&eth;/ ;
  s//\&ntilde;/ ;
  s//\&ograve;/ ;
  s//\&oacute;/ ;
  s//\&ocirc;/ ;
  s//\&otilde;/ ;
  s//\&ouml;/ ;
  s//\&divide;/ ;
  s//\&oslash;/ ;
  s//\&ugrave;/ ;
  s//\&uacute;/ ;
  s//\&ucirc;/ ;
  s//\&uuml;/ ;
  s//\&yacute;/ ;
  s//\&thorn;/ ;
  s//\&yuml;/ ;
  s//\&Ocirc;/ ;
  s//\&Otilde;/ ;
}
