/*******************************************************************/
/* (C) Klangatelier Algorythmics                                   */
/*******************************************************************/

/* --------------------------------------------------------------- */
/*       Typendefinition.                                          */
/* --------------------------------------------------------------- */
#ifndef PARSE_H
#define PARSE_H

#ifndef MIDIDEFS_H
#include "mididefs.h"
#endif

/*maximale groesse einer MIDI message (SYSEX) */
/* some vendors adds the header bytes to it, normal not allowed ;-) */
#define MAX_DATA MD_MAX_MESSAGE_LEN+64 

#define MP_SMPTE_FORWARD  0x10
#define MP_SMPTE_STOP     0x00
#define MP_SMPTE_REVERSE -0x10

typedef struct _midiparser{

  int port_no;        /* to control midi MIDI Ports */

  int cmd_stat;      /* running status */
  int cmd_byte;      /* aktuelle nummer der message bytes */
  int cmd_len;       /* laenges der midi message */

  byte p_kanal,p_befehl; /* kanal und Befehl getrennt */

  byte p_data[MAX_DATA]; /* algemeine mididaten */

  /* smpte */
  int smpte_frameidx;
  int smpte_status;
  int smpte_count;
  int frame;
  int sec;
  int min;
  int hr;

  /* primitive or detailed (see below)*/
  void (*cmd_2byte)(struct _midiparser *p);
  void (*cmd_3byte)(struct _midiparser *p);
  void (*cmd_sysex)(struct _midiparser *p); /* auer sysex und realtime */
  void (*raw)(int portno, int byte);

  /* detailed */

  /* midi notonoff or (midinoteon, midinote off)*/
  void (*noteonoff)(int portno, int channel, int pitch, int onvel,int offvel);
  /* or */
  void (*noteon)(int portno, int channel, int pitch, int velo);
  void (*noteoff)(int portno, int channel, int pitch, int velo);

  void (*controlchange)(int portno, int channel, int ctlnumber, int value);
  void (*programchange)(int portno, int channel, int value);
  void (*pitchbend)(int portno, int channel, int value);
  void (*aftertouch)(int portno, int channel, int value);
  void (*polyaftertouch)(int portno, int channel, int pitch, int value);

  void (*mode)(int portno,int mode,int value); 
  void (*quarterframe)(int portno,int frame,int sec,int min,int hr);
  void (*songposition)(int portno,int pos);
  void (*songselect)(int portno,int nr);
  void (*tunerequest)(int portno);
  
  void (*sysex)(int portno,int len,byte *data); 
  void (*realtime)(int portno,int rt); 
} MIDIParser;

/* -------------------------------------------------------------------- */
/*    Funktionsprototypen.                                              */
/* -------------------------------------------------------------------- */

/* Rckgabe von midi_parse */

#define MP_REALTIME  0xFF
#define MP_SYSEX     0xF0
#define MP_EOS       0xF7
#define MP_CHANNEL   0x80
#define MP_COMMON    0xF1
#define MP_SYSTEM    0xF6
#define MP_DATA		1
#define MP_ERROR     0

MIDIParser *mp_parse_init(int portnr);

void mp_parse_exit(MIDIParser *p);

int mp_parse(MIDIParser *p,byte b);


#endif /* PARSE_H */
