/*
 *  Penguineyes, a linuxified version of Xeyes
 *  Copyright (C) 1998/1999 Neil Howie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <unistd.h>
#include <math.h>
#include <gtk/gtk.h>
#include <gdk_imlib.h>

#include "penguineyes.h"

static long get_time(void)
{
    struct timeval tv;

    gettimeofday(&tv, NULL);

    return tv.tv_sec;
}

struct {
    struct coord p[4];
} hands[3];

GdkGC *clock_gc = NULL;

void draw_clock(void)
{
    GdkPoint p[4];
    int i;

    if (!default_theme->clock) return;

    if (!clock_gc) clock_gc = gdk_gc_new(mainWindow->window);

    for (i = 2; i >= 0; i--) {
	GdkColor c;
	int j;

	for (j = 0; j < 4; j++) {
	    p[j].x = hands[i].p[j].x;
	    p[j].y = hands[i].p[j].y;
	}

	c = default_theme->clock->hands[i].colour;

	setColour(clock_gc, c.red, c.blue,c.green);

	gdk_draw_polygon(mainWindow->window, clock_gc, TRUE, p, 4);

/*
 *
 *	polygon is as:
 *
 *	0------------------3
 *	|                  |
 *	|                  |
 *	1------------------2
 */

	gdk_draw_line(mainWindow->window, clock_gc, p[0].x, p[0].y,
		p[1].x, p[1].y);

	gdk_draw_line(mainWindow->window, clock_gc, p[1].x, p[1].y,
		p[2].x, p[2].y);

	gdk_draw_line(mainWindow->window, clock_gc, p[2].x, p[2].y,
		p[3].x, p[3].y);

	gdk_draw_line(mainWindow->window, clock_gc, p[0].x, p[0].y,
		p[3].x, p[3].y);
    }
}

static time_t last_time;

static void set_hand(struct clock_settings *clock, int idx, double angle)
{
    struct hand_settings *h = &(clock->hands[idx]);
    int mx, my, mav;

    mx = clock->rpos.x + clock->rdim.w/2;
    my = clock->rpos.y + clock->rdim.h/2;

    mav = (clock->rdim.w + clock->rdim.h)/2;

    hands[idx].p[0].x = mx + (int)(sin(angle-M_PI/2.0)*(mav*h->width[0]));
    hands[idx].p[0].y = my - (int)(cos(angle-M_PI/2.0)*(mav*h->width[0]));

    hands[idx].p[1].x = mx - (int)(sin(angle-M_PI/2.0)*(mav*h->width[0]));
    hands[idx].p[1].y = my + (int)(cos(angle-M_PI/2.0)*(mav*h->width[0]));

    hands[idx].p[2].x =
	mx + (int)(sin(angle)*(double)(clock->rdim.w/2)*h->length)
	- (int)(sin(angle-M_PI/2.0)*(mav*h->width[1]));
    hands[idx].p[2].y =
	my - (int)(cos(angle)*(double)(clock->rdim.h/2)*h->length)
	+ (int)(cos(angle-M_PI/2.0)*(mav*h->width[1]));

    hands[idx].p[3].x =
	mx + (int)(sin(angle)* (double)(clock->rdim.w/2)*h->length)
	    + (int)(sin(angle-M_PI/2.0)*(mav*h->width[1]));
    hands[idx].p[3].y =
	my - (int)(cos(angle)*(double)(clock->rdim.h/2)*h->length)
	- (int)(cos(angle-M_PI/2.0)*(mav*h->width[1]));
}

void update_clock(gboolean force)
{
    time_t time;
    struct tm *now;
    int hours, minutes, seconds;
    double angle;
    struct timeval tv;

    struct clock_settings *clock;

    g_return_if_fail(((clock = default_theme->clock) != NULL));

    gettimeofday(&tv, NULL);

    time = tv.tv_sec;
    if (!force && !(clock->smooth) && (time == last_time)) return;

    last_time = time;

    now = localtime(&time);

    hours = now->tm_hour%12;
    minutes = now->tm_min;
    seconds = now->tm_sec;

    angle = (M_PI*2.0*(double)(hours*60+minutes))/(12.0*60.0);
    set_hand(clock, 0, angle);

    angle = (M_PI*2.0*(double)(minutes*60+seconds))/(60.0*60.0);
    set_hand(clock, 1, angle);

    if (clock->smooth) {
	angle = (M_PI*2.0*(double)(seconds*1000000+tv.tv_usec))
	    /(60.0*1000000.0);
    } else {
	angle = (M_PI*2.0*(double)seconds)/60.0;
    }

    set_hand(clock, 2, angle);

    if (!sourcePenguin) return;

    draw_area(clock->rpos.x-1, clock->rpos.y-1,
	    clock->rdim.w+2, clock->rdim.h+2);

    draw_clock();

    return;
}

