#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include "npstringarray.h"
#include "npfile.h"
#include "npgroup.h"
#include "npnode.h"
#include "nptree.h"

int NP_Tree::get_groups( char *server, NP_Stringarray& group_array )
{
   if ( server == NULL )
   {
      strcpy( error_message, "NP_Tree: get_groups(): NULL server name passed"
              " as arguments." );
      return 1;
   }

   if ( !total_nodes || nodes == NULL )
   {
      strcpy( error_message, "NP_Tree: get_groups(): "
              "this tree object is empty." );
      return 1;
   }

   if ( group_array.clear() )
   {
      snprintf( error_message, sizeof error_message, "NP_Tree: get_groups(): "
                "%s", group_array.get_error());
      return 1;
   }
   
   NP_Node **pointer = nodes;
   int i;
   for( i = 0; i < total_nodes; ++i )
   {
      if ( !strcmp( ( *pointer )->get_name(), server ))
         break;
      ++pointer;
   }

   if ( i == total_nodes )
   {
      snprintf( error_message, sizeof error_message, "NP_Tree: get_groups(): "
                "no such node in this tree: %s", server );
      return 1;
   }

   int total;
   if ( ( *pointer )->get_stats( &total, NULL, NULL, NULL, NULL ))
   {
      snprintf( error_message, sizeof error_message, "NP_Tree: get_groups(): "
                "%s", ( *pointer )->get_error());
      return 1;
   }

   for( i = 0; i < total; ++i )
      if ( group_array.add_item( ( **pointer )[ i ] ))
      {
         snprintf( error_message, sizeof error_message, "NP_Tree: "
                   "get_groups(): %s", group_array.get_error() );
         return 1;
      }

   return 0;
}
