#include "npconfig.h"

void clist_add_callback( GtkWidget *widget, gint row, gint col,
                         GdkEvent *event, gpointer data )
{
   NP_Config *config =
      ( NP_Config *)gtk_object_get_data( GTK_OBJECT( widget ),
                                         "config" );
 
   if ( config == NULL )
      return;

   config->active_clist_line = row;
   
   if ( event == NULL || event->type != GDK_2BUTTON_PRESS )
      return;

   char *text[ 2 ];
   gtk_clist_get_text( GTK_CLIST( widget ), row, 0, &text[ 0 ] );
   gtk_clist_get_text( GTK_CLIST( widget ), row, 1, &text[ 1 ] );
   gtk_clist_append( GTK_CLIST( data ), text );

   ++config->group_clist_lines;

   int total = config->temp_deleted.get_total();
   if ( total < 0 )
      config->temp_deleted.print_error();
   else
      if ( total )
         for( int i = 0; i < total; ++i )
         {
            char *match = ( char *)config->temp_deleted[ i ];

            if ( match == NULL )
            {
               config->temp_deleted.print_error();
               break;
            }
            else
               if ( !strcmp( text[ 0 ], strchr( match, '-' ) + 1 ))
               {
                  if ( config->temp_deleted.remove_item( match ))
                  {
                     config->temp_deleted.print_error();
                     break;
                  }
                  
                  total = config->temp_deleted.get_total();
                  if ( total < 0 )
                  {
                     config->temp_deleted.print_error();
                     break;
                  }
               }
         }

   config->dirty = 1;
   
   char buffer[ 256 ];
   snprintf( buffer, sizeof buffer, "%d Subscribed Newsgroups",
             config->group_clist_lines );
   gtk_clist_set_column_title( GTK_CLIST( data ), 0, buffer );

   return;
}

   
   
