/* $Id: control.h,v 1.1 2001/10/25 15:55:45 knepley Exp $ */

/* Main include file for the Control test problem */

#ifndef __CONTROL_H
#define __CONTROL_H

#include "tao.h"
#include "petscsles.h"
#include "gsolver.h"

extern int CONTROL_COOKIE;
extern int CONTROL_ComputeField;

struct _ControlContext {
  PETSCHEADER(int)
  Grid                   grid;        /* The problem grid */

  MeshBoundary2D         boundaryCtx; /* Describes the domain boundary */
  MeshGeometryContext    geometryCtx; /* Describes the domain geometry */

  SLES                   sles;        /* The linear solver context */
  GMat                   A;           /* The system matrix */
  GVec                   u;           /* The solution vector */
  GVec                   f;           /* The rhs vector */
  GVec                   uExact;      /* The exact solution vector */

  GVec                   constantL;   /* The constant vector over field \lambda */
  MatNullSpace           nullSpace;   /* The psace spanned by uConstant */

  TAO_SOLVER             tao;               /* The Tao solver context */
  TAO_APPLICATION        taoApp;            /* The Tao application context */
  GVec                   lagrangianDensity; /* The work vector for calculating L (or density of L) */
  GVec                   lowerBound;        /* The lower bound for all variables */
  GVec                   upperBound;        /* The upper bound for all variables */

  int                    dim;         /* The problem dimension */
  PetscTruth             linear;      /* Using linear elements (as opposed to quadratic) */
  int                    refineStep;  /* The step to start refining the mesh */
  int                    numLoops;    /* The number of systems to solve */

  GVecErrorKSPMonitorCtx monitorCtx;  /* Specialized monitor for grid vector linear solves */
};
typedef struct _ControlContext *ControlContext;

/* Creation functions */
EXTERN int ControlContextCreate(MPI_Comm, ControlContext *);
EXTERN int ControlContextSetup(ControlContext);
EXTERN int ControlContextCreateMeshBoundary(ControlContext);
EXTERN int ControlContextDestroyMeshBoundary(ControlContext);
EXTERN int ControlContextCreateMesh(ControlContext, Mesh *);
EXTERN int ControlContextCreateGrid(ControlContext);
EXTERN int ControlContextRefineGrid(ControlContext);
EXTERN int ControlContextCreateTao(ControlContext);
EXTERN int ControlCreateStructures(ControlContext);

/* Setup functions */
EXTERN int ControlSetupGrid(ControlContext);
EXTERN int ControlSetupRhsFunction(Grid, ControlContext);
EXTERN int ControlSetupBC(Grid, ControlContext);
EXTERN int ControlSetupKSP(KSP, ControlContext);
EXTERN int ControlSetupPC(PC, ControlContext);
EXTERN int ControlSetupBounds(ControlContext);
EXTERN int ControlSetupStructures(ControlContext);

/* Cleanup functions */
EXTERN int ControlDestroyStructures(ControlContext);
EXTERN int ControlDestroy(ControlContext);
EXTERN int ControlContextDestroy(ControlContext);

/* Checking functions */
EXTERN int MatCheckSymmetry(Mat);
EXTERN int ControlCheckSolution(ControlContext, GVec, const char []);

/* Callback functions */
EXTERN int SolutionFunction(int, int, double *, double *, double *, PetscScalar *, void*);
EXTERN int MultiplierSolutionFunction(int, int, double *, double *, double *, PetscScalar *, void*);
EXTERN int ControlSolutionFunction(int, int, double *, double *, double *, PetscScalar *, void*);
EXTERN int RhsFunction(int, int, double *, double *, double *, PetscScalar *, void*);
EXTERN int ControlFormFunctionGradient(TAO_SOLVER, Vec, double *, Vec, void *);
EXTERN int ControlFormHessian(TAO_SOLVER, Vec, Mat *, Mat *, MatStructure *, void *);

/* Solver functions */
EXTERN int ControlSolve(ControlContext, GVec, GVec, int *);
EXTERN int ControlComputeField(ControlContext);

#endif /* __CONTROL_H */
