/* $Id: unstructured_2d.h,v 1.2 2000/02/01 17:02:52 knepley Exp $ */

/* Main include file for the Stokes flow test problem */

#ifndef __UNSTRUCTURED_2D_H
#define __UNSTRUCTURED_2D_H

#include "mesh.h"

struct _MeshContext {
  PETSCHEADER(int)
  Mesh                mesh;          /* The problem mesh */

  int                 numLocalNodes; /* The number of nodes on an element */
  MeshBoundary2D      boundaryCtx;   /* Describes the domain boundary */
  MeshGeometryContext geometryCtx;   /* Describes the domain geometry */

  int                 numRefine;     /* The number of refinement steps */
  int                 numCoarsen;    /* The number of coarsening steps */
};
typedef struct _MeshContext *MeshContext;

/* Creation functions */
extern int MeshContextCreate(MPI_Comm, MeshContext *);
extern int MeshContextDestroy(MeshContext);

/* Setup functions */
extern int MeshContextSetup(MeshContext);
extern int MeshContextCleanup(MeshContext);
extern int MeshContextCreateMesh(MeshContext);
extern int MeshContextRefineMesh(MeshContext);
extern int MeshContextCoarsenMesh(MeshContext);
extern int MeshContextDestroyMesh(MeshContext);

/* Checking functions */

/* Callback functions */

/* Main computation */
extern int MeshContextRun(MeshContext);

#endif /* __UNSTRUCTURED_2D_H */
