#! /usr/bin/perl -w

$usage = q(
  options:
    --help       this help screen
    --version    the version of this script
    --verbose    verbose mode
    
 -c --count=<d>  how many entries to quote
);

# option scanning
my @argv; # the options that are left after parsing, usually filenames
my %opt; # options and their values
for (@ARGV)
{
    if (/^-/) 
    {	if (/^--version\b/) { print "1.0" and die; }
        if (/^--help\b/) { print $usage and die; }
        if (/^--([-\w]*)\b=?(.*)/) { $opt{"$1"} = $2; next; }
        if (/^-(\w)\b=?(.*)/) { $opt{"$1"} = $2; next; }
    }
    push @argv, $_;
}

my ($day,$month) = (localtime)[3..4]; # month is 0..11

my $count = 1000;
$count = $opt{"c"} if exists $opt{"c"};
$count = $opt{"count"} if exists $opt{"count"};
$count = 1000 if 0 > $count or $count > 1000 ;

if (not defined $argv[0])
{
   print "missing input filename";
   print $usage and die;
}

my $F = $argv[0];
open F, "<$F" or die "could not open input filename <$F>, $!";

my $i = 0;
my @lines;
while (<F>)
{
  --$count if /^\d\d/;
  last if $count < 0;
  push @lines, txt2html($_);
}
close F; 

if( not defined $argv[1] )
{
   print "",@lines,"";
}else
{
   $F = $argv[1];
   open F, ">$F" or die "could not open output file <$F>, $!";
   print F "\n<p><pre><small>\n",@lines,"\n</small></pre></p>\n";
   close F;
}

sub txt2html
{
   $_ = $_[0];
   s {\&} {\&amp;}g;
   s {\<} {\&lt;}g;
   s {\>} {\&gt;}g;
   s {\b([-.\w\d]+\@[-.\w\d]+\.[\w]+)\b} "<a href=\"mailto:$1\">$1<\/a>"g;
   s {\b(http://[-+\.\/\w\d]+)} "<a href=\"$1\">$1<\/a>"g;
   s {^( +\* +)(Release)} "$1<b>$2</b>" ;
   s {^ \* } " <b>*</b> ";
   s {^  \* } "  <b>*</b> ";
  
   if (/^(\d+)-(\d+)-(\d+)/)
   {
       if ((1 <= $2 && $2 <= 12 && 1 <= $2 && $2 <= 31)
       and ($2 == $month   &&            $day + 25 <= $3 
         || $2 == $month+1 && $3 <= $day && $day-7 <= $3 ))
       {
           s:(\d+-\d+-\d+):$1<font color=red><sup>new</sup></font>: ;
       }
   }

   return $_;
}

