/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996-2000 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    support@pftp.de
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#if defined USE_POSIX_THREAD
#define _REENTRANT
#include <pthread.h>
#endif
#ifdef FreeBSD
#include <sys/types.h>
#include <sys/errno.h>
#endif
#if defined SunOS_SOLARIS || defined unicos
#include <fcntl.h>
#endif
#include <dirent.h>
#if defined Linux || defined NEXTSTEP
#include <sys/dir.h>
#endif
#include <string.h>
#include "main.h"

#ifdef __USE_FILE_OFFSET64
#define PFTP_PRINTF_LLD "%lld"
#else
#define PFTP_PRINTF_LLD "%ld"
#if defined HAVE_SENDFILE && defined Linux
#include <sys/sendfile.h>
#endif
#endif

#ifndef R_OK
#define R_OK 4
#endif

#if !defined __RH_CYGLINT__
extern void set_tty(int);
#endif
extern off_t offset[SONAME];
extern void check_bandwidth(size_t);
extern void test_the_net_write(int, double *);
extern void send_udps(int, double *);
extern void free_vec(char **);
extern void add_abs_file_name(char *, char *, struct stat *);
extern int get_next_file_name(char *);
void init_sending(int, char *, char *);
 
#if defined __RH_CYGLINT__
#define PFTP__OPEN_OPTION__ O_RDONLY|O_BINARY
#else
#define PFTP__OPEN_OPTION__ O_RDONLY
#endif

char fstr[BUFSIZE];
off_t length=0;
ssize_t n, check;
char *bstrptr=NULL;
struct stat buf;

void sending(client_type  *clientstr)
{
   char bstr[BIG_BUFSIZE];
   char sttmp[LONAME];
   char linkcontents[LONAME];
   size_t rr=0;
   int ofse=0;
   DIR *ff;
#if defined Linux
   struct direct *dir;
#else
   struct dirent *dir;
#endif
   char *hostname = (*statstr)->_HOSTNAME_;
   char name[LONAME], *tmpname=NULL;
   size_t BUFFER_SIZE = (*statstr)->_STDIN_BUFSIZ_ ? (*statstr)->_STDIN_BUFSIZ_: DEFAULT_STRING_SIZE;
   FILE *fe=stderr;
   double ci=0;
#if defined HAVE_SENDFILE && defined Linux && !defined __USE_FILE_OFFSET64
   off_t fileoffset=0;
#endif
   int mode=0;
   int ft=0, fd=(*statstr)->fd;
   int percent=0;
#ifdef Linux
   size_t maxrr=BUFFER_SIZE;
#else
   size_t maxrr=BUFFER_SIZE > BIG_BUFSIZE ? BIG_BUFSIZE: BUFFER_SIZE;
#endif

   /*
    * Read password, send message file ...
    */
   init_sending(fd, name, hostname);

   if ((*statstr)->_STANDARD_INPUT_) {
      add_abs_file_name(strdup("-"), NULL, (struct stat *)NULL);
   }
   else if (!(*statstr)->READFROMSTDIN) {
      char **argv=clientstr->argv+clientstr->argc;
      while ((clientstr->argc)--) {
         argv--;
         add_abs_file_name(strdup(*argv), NULL, (struct stat *)NULL);
      }
   }

   /*
    * Loop through the file list.
    */
   while ((*statstr)->READFROMSTDIN || get_next_file_name(name)) {
      if (!(*statstr)->_STANDARD_INPUT_) {
         if ((*statstr)->READFROMSTDIN) {
            if ((*statstr)->KDE_FRONTEND) fprintf(slfp, "COME ON\n");
            if (!fgets(sttmp, LONAME, stdin)) {
               (*statstr)->READFROMSTDIN = 0;
               continue;
            }
            *(sttmp + LONAME - 1) = '\0';
            for (tmpname=sttmp; *tmpname && *tmpname != '\n'; tmpname++);
            *tmpname = '\0';
            strcpy(name, sttmp);
         }

         /*
          * Get protection bits.
          */
         if (!(*statstr)->SENDMAKELINKS) {
            if (stat(name, &buf)) {
               if (slfp) fprintf(slfp, "** %s: %s\n", name, _PFTP_ERROR_ARRAY_);
               if (pftplog) {
                  if ((fe = fopen(pftplog, "a"))) {
                     fprintf(fe, "** File %s doesn't exist!\n", name);
                     fclose(fe);
                  }
               }
               continue;
            }
         }
         else {
            if (lstat(name, &buf)) {
               if (slfp) fprintf(slfp, "** %s: %s\n", name, _PFTP_ERROR_ARRAY_);
               if (pftplog) {
                  if ((fe = fopen(pftplog, "a"))) {
                     fprintf(fe, "** File %s doesn't exist!\n", name);
                     fclose(fe);
                  }
               }
               continue;
            }
         }
         mode = buf.st_mode;

         /*
          * Check file.
          */
         if ((*statstr)->SENDMAKELINKS && (buf.st_mode & S_IFMT) == S_IFLNK) {
            memset(linkcontents, 0, LONAME);
            if (readlink(name, linkcontents, LONAME) < 0) {
               if (slfp) fprintf(slfp, "** Can't read link %s.\n", name);
               if (pftplog) {
                  if ((fe = fopen(pftplog, "a"))) {
                     fprintf(fe, "** Can't read link %s.\n", name);
                     fclose(fe);
                  }
               }
               continue;
            }
            if (!(fe = fopen((*statstr)->SENDMAKELINKS, "a"))) {
               if (slfp) fprintf(slfp, "** %s: %s\n", \
                                (*statstr)->SENDMAKELINKS, _PFTP_ERROR_ARRAY_);
               exit(PFTP_FILE_OPEN_ERR);
            }
            if (*name == '/') tmpname = name+1;
            else tmpname = name;
            fprintf(fe, PFTPLINKPROG, linkcontents, tmpname);
            fclose(fe);
            continue;
         }
#if defined __RH_CYGLINT__
         else if (!buf.st_size && (buf.st_mode & S_IFMT) == S_IFREG)
#else
         else if (!buf.st_size)
#endif
         {
            if ((*statstr)->send_file_info) {
               sprintf(fstr, "%s %d %d %d %ld %ld %s\nH", \
                      name, buf.st_mode, buf.st_uid, buf.st_gid, \
                      (long)buf.st_rdev, (long)buf.st_mtime, \
                      (buf.st_mode & S_IFMT) == S_IFIFO ? "p1": "g1");
               if (write(fd, fstr, strlen(fstr)) < 0) {
                  if (slfp) fprintf(slfp, "** write: %s\n", _PFTP_ERROR_ARRAY_);
                  exit(PFTP_WRITETONET_ERR);
               }
               if (slfp) {
                  if (!(*statstr)->KDE_FRONTEND) {
                     fprintf(slfp, "--> Sent information about %s to %s.\n", name, hostname);
                  }
                  else fprintf(slfp, "* Sent information about %s to %s.\n", name, hostname);
               }
            }
            else {
               if (slfp) fprintf(slfp, "** File %s is empty.\n", name);
               if (pftplog) {
                  if ((fe = fopen(pftplog, "a"))) {
                     fprintf(fe, "** File %s is empty.\n", name);
                     fclose(fe);
                  }
               }
            }
            continue;
         }
         /*
          * Check if file is readable.
          */
         else if (access(name, R_OK)) {
            if (slfp) fprintf(slfp, "** %s: %s\n", name, _PFTP_ERROR_ARRAY_);
            if (pftplog) {
               if ((fe = fopen(pftplog , "a"))) {
                  fprintf(fe, "** %s: %s\n", name, _PFTP_ERROR_ARRAY_);
                  fclose(fe);
               }
            }
            continue;
         }
         else if (((*statstr)->_RECURS_ || \
                 ((*statstr)->READFROMSTDIN && (*statstr)->send_file_info)) \
                 && (buf.st_mode & S_IFMT) == S_IFDIR) {
            if ((*statstr)->_RECURS_) {
               char *dir_vec[PFTP_MAX_PFM_ENTRY];
               int num;
               /*
                * Save directory information.
                */
               if ((*statstr)->send_file_info) {
                  add_abs_file_name(strdup(name), NULL, &buf);
               }

               if (!(ff = opendir(name))) {
                  if (slfp) fprintf(slfp, "** %s: %s\n", name, _PFTP_ERROR_ARRAY_);
                  if (pftplog) {
                     if ((fe = fopen(pftplog, "a"))) {
                        fprintf(fe, "** %s: %s\n", name, _PFTP_ERROR_ARRAY_);
                        fclose(fe);
                     }
                  }
                  continue;
               }

               for (num=0; (dir = readdir(ff)); num++)
               {
                  if (dir->d_ino && strcmp(".", dir->d_name) \
                     && strcmp("..", dir->d_name) \
                     && strlen(dir->d_name)) {
                     /* Work around for the buggy glibc threading. */
                     MEM_CHECK((*(dir_vec+num) = strdup(dir->d_name)));
                  }
                  else num--;
               }

               closedir(ff);
               while (--num >=0) {
                  add_abs_file_name(strdup(name), *(dir_vec+num), (struct stat *)NULL);
               }
            }
            continue;
         }
         else if ((buf.st_mode & S_IFMT) != S_IFREG) {
            if (slfp && !(*statstr)->READFROMSTDIN) {
               fprintf(slfp, "** %s is not a regular file.\n", name);
            }
            continue;
         }
      }
         
      /*
       * Open file descriptor for reading.
       */
      if ((*statstr)->_STANDARD_INPUT_) {
         ft = 0;
      }
      else if ((ft = open(name, PFTP__OPEN_OPTION__)) < 0) {
         if (slfp) fprintf(slfp, "** %s: %s\n", name, _PFTP_ERROR_ARRAY_);
         if (pftplog) {
            if ((fe = fopen(pftplog, "a"))) {
               fprintf(fe, "** %s: %s\n", name, _PFTP_ERROR_ARRAY_);
               fclose(fe);
            }
         }
         continue;
      }
      else if (*(offset+ofse) >= 0) {
         if (lseek(ft, *(offset+ofse), 0) < 0) {
            if (slfp) fprintf(slfp, "** %s: %s\n", name, _PFTP_ERROR_ARRAY_);
            exit(PFTP_FILE_SEEK_ERR);
         }
#if defined HAVE_SENDFILE && defined Linux && !defined __USE_FILE_OFFSET64
         fileoffset = *(offset+ofse);
#endif
         buf.st_size -= *(offset+ofse);
         ofse++;
      }

      /*
       * Send information about the file.
       */
      if (!(*statstr)->use_udp) {
         if ((*statstr)->version) {
            for (tmpname=name; *tmpname; tmpname++) {
               if (*tmpname == '\n') *tmpname = '_';
            }
         }
         else {
            for (tmpname=name; *tmpname; tmpname++) {
               if (*tmpname == ' ' || *tmpname == '\t' || *tmpname == '\n') {
                  *tmpname = '_';
               }
            }
         }
         if ((*statstr)->_STANDARD_INPUT_) {
            strcpy(name, "|"); mode = 0644; buf.st_size = 0;
            sprintf(fstr, "%s %d " PFTP_PRINTF_LLD "\nH", name, mode, buf.st_size);
         }
         else if ((*statstr)->send_file_info) {
            sprintf(fstr, "%s %d %d %d " PFTP_PRINTF_LLD " %ld f1\nH", \
                   name, mode, buf.st_uid, buf.st_gid, \
                   buf.st_size, (long)buf.st_mtime);
         }
         else sprintf(fstr, "%s %d " PFTP_PRINTF_LLD "\nH", name, mode, buf.st_size);
         if (write(fd, fstr, strlen(fstr)) < 0) {
            if (slfp) fprintf(slfp, "** write: %s\n", _PFTP_ERROR_ARRAY_);
            exit(PFTP_WRITETONET_ERR);
         }
      }

      /*
       * Read from local file and write to filter/remote
       * port unless we're sending udps.
       */
      if (slfp) {
         if (!(*statstr)->KDE_FRONTEND) {
            sprintf(bstr, "%s Sending %s %s to %s ...%s", \
            (*statstr)->show_percent ? "[  0%]": "*", \
            (*statstr)->_STANDARD_INPUT_ ? "a stream": "file", \
            (*statstr)->_STANDARD_INPUT_ ? "\b": name, hostname, \
            (*statstr)->_STANDARD_INPUT_ ? "\n": "");
            if ((*statstr)->show_percent) *(bstr+_WINCOLS_) = '\0';
            fprintf(slfp, bstr);
         }
         else fprintf(slfp, "FILE %s\n", name);
      }
      if (!(*statstr)->use_udp) {
         if (!(*statstr)->testbsize) {
            double sum=0;
            if (!(*statstr)->_STANDARD_INPUT_) {
               (*statstr)->lol = 1;
               rr = maxrr > buf.st_size ? buf.st_size: maxrr;
            }
            else rr = maxrr;
            if (!(*statstr)->_STDIN_BUFSIZ_) rr = 1;
#if defined HAVE_SENDFILE && defined Linux && !defined __USE_FILE_OFFSET64
            if (!(*statstr)->_STANDARD_INPUT_) {
               for (ci=0.0, n=1; n; ci+=(double)n) {
                  if ((n = sendfile(fd, ft, &fileoffset, rr)) < 0) {
                     if (slfp) fprintf(slfp, "** sendfile: %s\n", _PFTP_ERROR_ARRAY_);
                     exit(PFTP_WRITETONET_ERR);
                  }
                  if ((*statstr)->show_percent) {
                     if (!n) continue;
                     sum += (double)n;
                     percent = (int)(((double) sum / (double) buf.st_size) * 100.0);
                     if (!(*statstr)->KDE_FRONTEND) fprintf(slfp, "\r[%3d%%]", percent);
                     else fprintf(slfp, "P %d\n", percent);
                  }
                  /* waiting if necessary */
                  if ((*statstr)->_BANDWIDTH_) check_bandwidth(n);
               }
               fileoffset=0;
            }
            else {
#endif
            for (ci=0.0, n=0; (n = read(ft, bstr, rr)) > 0; ci+=(double)n) {
               for (check=0, length=n, bstrptr=bstr; length; length-=check, bstrptr+=check) {
                  if ((check = write(fd, bstrptr, length)) < 0) {
                     if (slfp) fprintf(slfp, "** write: %s\n", _PFTP_ERROR_ARRAY_);
                     exit(PFTP_WRITETONET_ERR);
                  }
               }
               if ((*statstr)->show_percent) {
                  sum += (double)n;
                  percent = (int)(((double) sum / (double) buf.st_size) * 100.0);
                  if (!(*statstr)->KDE_FRONTEND) fprintf(slfp, "\r[%3d%%]", percent);
                  else fprintf(slfp, "P %d\n", percent);
               }
               /* waiting if necessary */
               if ((*statstr)->_BANDWIDTH_) check_bandwidth(n);
            }
#if defined HAVE_SENDFILE && defined Linux && !defined __USE_FILE_OFFSET64
            }
#endif
            if (!(*statstr)->_STANDARD_INPUT_) close(ft);
         }
         else test_the_net_write(fd, &ci);
      }
      else {
         if (!(*statstr)->_STANDARD_INPUT_) {
            (*statstr)->lol = 1;
            (*statstr)->mul = buf.st_size;
         }
         send_udps(ft, &ci);
      }

      if (slfp) {
         fflush(slfp);
         if ((ci == (double)buf.st_size) || (*statstr)->_STANDARD_INPUT_ || (*statstr)->file_skipped) {
            if (!(*statstr)->KDE_FRONTEND) { 
               if ((*statstr)->lol) fputc(slfp == stderr ? '\r': '\n', slfp);
               fprintf(slfp, "%s %s (%.0f bytes) sent to %s.\n", \
               (*statstr)->show_percent ? "[100%]": "-->", \
               (*statstr)->_STANDARD_INPUT_ ? "Stream": name, ci, hostname);
               (*statstr)->file_skipped = 0;
               (clientstr)->print_wait = 1;
            }
         }
         else {
            /*
             * Though the network buffer is probably too big.
             */
            fprintf(slfp, "** Sending %s to %s failed!\n", (*statstr)->_STANDARD_INPUT_ ? "stream": name, hostname);
            if (pftplog) {
               if ((fe = fopen(pftplog, "a"))) {
                  fprintf(fe, "** Sending %s to %s failed!\n", (*statstr)->_STANDARD_INPUT_ ? "stream": name, hostname);
                  fclose(fe);
               }
            }
         }
      }
   }
   if ((*statstr)->SENDMAKELINKS \
      && !stat((*statstr)->SENDMAKELINKS, &buf) \
      && (buf.st_size > PFTPSCRIPTINITLEN)) {
      /*
       * Send Link script if links were found.
       */
      if ((ft = open((*statstr)->SENDMAKELINKS, PFTP__OPEN_OPTION__)) < 0) {
         if (slfp) fprintf(slfp, "** %s: %s\n", (*statstr)->SENDMAKELINKS, _PFTP_ERROR_ARRAY_);
         exit(PFTP_FILE_OPEN_ERR);
      }
      sprintf(fstr, PFTPMAKELINKS " 448 " PFTP_PRINTF_LLD "\nH", buf.st_size);
      if (write(fd, fstr, strlen(fstr)) < 0) {
         if (slfp) fprintf(slfp, "** write: %s\n", _PFTP_ERROR_ARRAY_);
         exit(PFTP_WRITETONET_ERR);
      }
      if (slfp) {
         if (!(*statstr)->KDE_FRONTEND) fprintf(slfp, "* Sending link script to %s...\r", hostname);
         else fprintf(slfp, "FILE PFTP_MAKE_LINKS\n");
      }
      while ((n = read(ft, bstr, BUFSIZE)) > 0) {
         for (check=0, length=n, bstrptr=bstr; length; length-=check, bstrptr+=check) {
            if ((check = write(fd, bstrptr, length)) < 0) {
               if (slfp) fprintf(slfp, "** write: %s\n", _PFTP_ERROR_ARRAY_);
               exit(PFTP_WRITETONET_ERR);
            }
         }
      }
      close(ft);
      if (slfp) {
         if (!(*statstr)->KDE_FRONTEND) fprintf(slfp, "--> linking script (" PFTP_PRINTF_LLD " bytes) sent to %s.\n", buf.st_size, hostname);
         else fprintf(slfp, "* Linking script (" PFTP_PRINTF_LLD " bytes) sent.\n", buf.st_size);
      }
   }
}


void init_sending(int fd, char *name, char *hostname) {
   /*
    * Check if the client sends data to the daemon.  If so send
    * the destination directory and the password to the client.
    */
   if (!(*statstr)->use_udp) {
      if ((*statstr)->_PFTP_DAEMON_ && client_destdir && !*((*statstr)->from)) {
         int ll=0;
         char *passwd=NULL;

         if (*((*statstr)->pw_passwd)) passwd = (*statstr)->pw_passwd;
         else {
            MEM_CHECK((passwd = (char *)calloc(SONAME, sizeof(char))));
            memset(passwd, 0, SONAME);
            if (!(*statstr)->KDE_FRONTEND) {
#if !defined __RH_CYGLINT__
               set_tty(2);
#endif
               fprintf(stderr, "Password: "); fgets(passwd, SONAME, stdin);
#if !defined __RH_CYGLINT__
               set_tty(0);
#endif
               fputc('\r', stderr);
            }
            for (ll=0; *(passwd+ll); ll++) {
               if (*(passwd+ll) == '\n') *(passwd+ll) = '\0';
            }
         }
         sprintf(fstr, "DDIR %s\nPASS %s\nGOON 1\n", client_destdir, passwd);
         if (write(fd, fstr, strlen(fstr)) < 0) {
            if (slfp) fprintf(slfp, "** write: %s\n", _PFTP_ERROR_ARRAY_);
            exit(PFTP_WRITETONET_ERR);
         }
         memset(passwd, 0, SONAME);
         if (client_destdir) {
            free(client_destdir);
            client_destdir = NULL;
         }
      }
      else if ((data_subject || data_info) && *((*statstr)->from)) {
         off_t psize=0;
         if (data_info && !stat(data_info, &buf) && (buf.st_mode & S_IFMT) == S_IFREG) {
            int fip=0;
            if (data_subject) {
               sprintf(fstr, "Subject: %s\n", data_subject);
               psize = strlen(fstr);
            }
            if (psize || buf.st_size) {
               sprintf(name, PFTP_INFO_FILE " 384 " PFTP_PRINTF_LLD "\nH", psize+buf.st_size);
               if (write(fd, name, strlen(name)) < 0) {
                  if (slfp) fprintf(slfp, "** write: %s\n", _PFTP_ERROR_ARRAY_);
                  exit(PFTP_WRITETONET_ERR);
               }
            }
            if (data_subject) {
               for (check=0, length=psize, bstrptr=fstr; length; length-=check, bstrptr+=check) {
                  if ((check = write(fd, bstrptr, length)) < 0) {
                     if (slfp) fprintf(slfp, "** write: %s\n", _PFTP_ERROR_ARRAY_);
                     exit(PFTP_WRITETONET_ERR);
                  }
               }
            }
            if (buf.st_size) {
               if ((fip = open(data_info, PFTP__OPEN_OPTION__)) < 0) {
                  if (slfp) fprintf(slfp, "** %s: %s\n", data_info, _PFTP_ERROR_ARRAY_);
                  exit(PFTP_FILE_OPEN_ERR);
               }
               if (!(*statstr)->KDE_FRONTEND && slfp) {
                  fprintf(slfp, "* Sending message file to %s...\r", hostname);
               }
               while ((n = read(fip, fstr, DEFAULT_STRING_SIZE)) > 0) {
                  for (check=0, length=n, bstrptr=fstr; length; length-=check, bstrptr+=check) {
                     if ((check = write(fd, bstrptr, length)) < 0) {
                        if (slfp) fprintf(slfp, "** write: %s\n", _PFTP_ERROR_ARRAY_);
                        exit(PFTP_WRITETONET_ERR);
                     }
                  }
               }
               close(fip);
               if (slfp) {
                  if (!(*statstr)->KDE_FRONTEND) {
                     fprintf(slfp, "--> Message file (" PFTP_PRINTF_LLD " bytes) sent to %s.\n", psize+buf.st_size, hostname);
                  }
                  else fprintf(slfp, "* Message file (" PFTP_PRINTF_LLD " bytes) sent.\n", psize+buf.st_size);
               }
            }
         }
         else if (data_subject) {
            sprintf(fstr, "Subject: %s", data_subject);
            psize = strlen(fstr);
            sprintf(name, PFTP_INFO_FILE " 384 " PFTP_PRINTF_LLD "\nH", psize);
            if (write(fd, name, strlen(name)) < 0) {
               if (slfp) fprintf(slfp, "** write: %s\n", _PFTP_ERROR_ARRAY_);
               exit(PFTP_WRITETONET_ERR);
            }
            for (check=0, length=psize, bstrptr=fstr; length; length-=check, bstrptr+=check) {
               if ((check = write(fd, bstrptr, length)) < 0) {
                  if (slfp) fprintf(slfp, "** write: %s\n", _PFTP_ERROR_ARRAY_);
                  exit(PFTP_WRITETONET_ERR);
               }
            }
         }
      }
   }

   /*
    * Delete info file if `-M' was given on command line.
    */
   if ((*statstr)->delete_info) unlink(data_info);

   /*
    * Initialize Bandwidth if '-w' was given on command line.
    */
   if ((*statstr)->_BANDWIDTH_) check_bandwidth((size_t)0);
   if ((*statstr)->verbose && (*statstr)->READFROMSTDIN) {
      fprintf(slfp, "* Reading file and directory names from standard input.\n");
   }
}
