.TH PGDBF 1 "September 30 2012" "Version 0.6.2"
.SH NAME
pgdbf \- convert XBase / FoxPro tables to PostgreSQL

.SH SYNOPSIS
.B pgdbf
[\-cCdDeEhqQtTuU] [-m memofile] filename [indexcolumn ...]

.SH DESCRIPTION
PgDBF is a program for converting XBase databases - particularly FoxPro
tables with memo files - into a format that PostgreSQL can directly import.
It's a compact C project with no dependencies other than standard Unix
libraries. While the project is relatively tiny and simple, it's also
heavily optimized via profiling - routine benchmark were many times faster
than with other Open Source programs. In fact, even on slower systems,
conversions are typically limited by hard drive speed.
.P
.SS Features
PgDBF was designed with a few core principles:
.P
.RS
.B
Simplicity.
This code should be understandable by anyone who wants to hack it.
.P
.B
Robustness.
Every syscall that might possibly fail is checked for success.
.P
.B
Speed.
PgDBF was born to be the fastest conversion available anywhere.
.P
.B
Completeness.
It has full support for FoxPro memo files.
.P
.B
Portability.
PgDBF runs on 32- and 64-bit systems, and both little-endian (eg x86) and
big-endian (eg PowerPC) architectures.
.RE

.SS Performance
PgDBF's speed is generally limited by how fast it can read your hard drives.
A striped RAID of quick disks can keep PgDBF pretty well fed on a
single-processor system. One problem area is with memo files, which may
become very internally fragmented as memo fields are created, deleted, and
updated. For best results, consider placing the DBF and FPT files on a RAM
drive so that there's no seek penalty as there is with spinning hard drives,
or using a filesystem such as ZFS that caches aggressively.

One particularly fragmented 160MB table with memo fields used to take over
three minutes on a FreeBSD UFS2 filesystem. Moving the files to a RAM disk
dropped the conversion time to around 1.2 seconds.

A certain test table used during development comprises a 280MB DBF file and
a 660MB memo file. PgDBF converts this to a 1.3 million row PostgreSQL table
in about 11 seconds, or at a rate of almost 120,000 rows per second.

.SH OPTIONS
.TP
.B -c
Generate a
.B CREATE TABLE
statement to make a table with similar datatypes and column names as the DBF
file. Default.
.TP
.B -C
Suppress the
.B CREATE TABLE
statement.
.TP
.B -d
Generate a
.B DROP TABLE
statement before the
.B CREATE TABLE
statement. This is useful for replacing the contents of a table that already
exists in PostgreSQL. Default.
.TP
.B -D
Suppress the
.B DROP TABLE
statement.
.TP
.B -e
Change the
.B DROP TABLE
statement to
.B DROP TABLE IF EXISTS
so that newer versions of PostgreSQL (8.2+) will only attempt to drop the
table if it's already defined. PostgreSQL will return an error when
attempting to drop a table that does not exist unless
.B IF EXISTS
is used. Default.
.TP
.B -E
Do not use the
.B IF EXISTS
modifier to
.B DROP TABLE
for compatibility with versions of PostgreSQL older than 8.2.
.TP
.B -h
Print a help message, then exit.
.TP
.B -m memofile
The name of the associated memo file (if necessary).
.TP
.B -n
Create NUMERIC fields with type NUMERIC. Default.
.TP
.B -N
Create NUMERIC fields with type TEXT. Use this if rows contain invalid
number data in NUMERIC fields (which are essentially CHARACTER fields
behind the scenes).
.TP
.B -p
Show a progress bar during the conversion process.
.TP
.B -P
Do not show a progress bar. Default.
.TP
.B -q
Enclose the name of the table in quotation marks in statements like "CREATE
TABLE", "DROP TABLE", and so on. This is useful in cases where the table
name is a PostgreSQL reserved word, and almost certainly harmless in all
other cases.
.TP
.B -Q
Do not enclose the name of the table in quotation marks. Default.
.TP
.B -s encoding
Set the encoding used in the input file. When given, output will be converted
from that encoding to UTF-8. Supported encodings depend on your version of the
iconv library. Available only if your copy of PgDBF was compiled with iconv
support.
.TP
.B -t
Wrap the entire script in a transaction. Default.
.TP
.B -T
Remove the wrapper transaction. This is generally not a good idea as it can
cause the table to appear completely empty to other clients during the data
copying phase. If the entire process occurs inside a transaction, the
update is atomic and other clients will have full access to all data in the
table at all times.
.TP
.B -u
Issue a
.B TRUNCATE TABLE
statement to clear the contents of a table before copying data into it.
.TP
.B -U
Suppress the
.B TRUNCATE TABLE
statement. Default.

.SH "OPTION NOTES"
The
.B -c
and
.B -d
arguments are incompatible with
.B -u
as it's pointless to truncate a newly-created table. Specifying
.B -c
or
.B -d
will disable the
.B TRUNCATE TABLE
statement as though
.B -U
was given. Similarly, using the
.B -u
argument will disable the
.B CREATE TABLE
and
.B DROP TABLE
statements as if
.B -C
and
.B -D
were given.

.SH BUGS
When multiple incompatible interpretations of a type are available, such as
the
.B B
type which can mean
.I "binary object"
in dBASE V or
.I "double-precision float"
in FoxPro, PgDBF currently uses the FoxPro interpretation.

Most XBase datatypes are supported, but some are not (yet). As of this
writing, PgDBF can handle \fIboolean\fP, \fIcurrency\fP, \fIdate\fP,
\fIdouble-precision float\fP, \fIfloat\fP, \fIgeneral\fP (although only
outputs empty strings; it's unclear how to resolve OLE objects at this
time), \fIinteger\fP, \fImemo\fP, \fInumeric\fP, \fItimestamp\fP, and
\fIvarchar\fP fields. If you need other datatypes, send a small sample
database for testing.

.SH AUTHOR
Kirk Strauser <kirk@strauser.com>
