#!/bin/sh
#
# $Progeny: packagetofile.sh,v 1.8 2002/01/18 06:19:54 dsp Exp $
#
# From a package's, name, find the "best" candidate deb to install
# Read package names on stdin, write filenames to stdout

if [ -z "$MIRROR" ] ; then
    echo "You must set the environment variable MIRROR to use this program" 1>&2
    exit 1
fi

# given the filename of a package (without path) echo the name, version, and
# arch, all space separated
pkgver() {
    dpkg -f "$@" | awk '/^Version: / { version=$2;} END { print version; }'
}

pkgname() {
    dpkg -f "$@" | awk '/^Package: / {package=$2 ;} END { print package ; }'
}

# Iron Package -- whose package version will remain supreme? who will become
#                 the next... Iron Package?!?!
# OR ... echo the file with the newest package
findwinner() {
    if dpkg --compare-versions $(pkgver $1) gt $(pkgver $2) ; then
        echo $1
    else
        echo $2
    fi
}

# read package names from stdin
while read package ; do
    fullpackage=""
    for archive in $MIRROR $OTHER_ARCHIVES ; do
        if [ "$archive" = "$MIRROR" ] ; then
            # the MIRROR is full of debian subdir... attempt to handle it
            lookin="$MIRROR/dists/$CODENAME/main/binary-* $MIRROR/dists/$CODENAME/contrib/binary-*"
            for file in $(find $lookin -name "${package}_*.deb") ; do
                fname=$(pkgname $file)
                if [ "$fname" = "$package" ] ; then
                    export fullpackage="$file"
                fi
            done
        else
            # assume $OTHER_ARCHIVES are flat archives...
            for file in $(ls -1 $archive/${package}_*.deb 2>/dev/null) ; do
                fname=$(pkgname $file)
                if [ "$fname" = "$package" ] ; then
                    # the package names match
                    if [ -z "$fullpackage" ] ; then
                        # find the higher versioned package if there's already
                        # one found
                        fullpackage=$file
                    else
                        # looks like this guy wasn't in the archive?
                        fullpackage=$(findwinner $file $fullpackage)
                    fi
                fi
            done
        fi
    done

    # show the output
    if [ -n $fullpackage ] ; then
        echo $fullpackage
    else
        echo "E: Can't find $package in $MIRROR $OTHER_ARCHIVES" 1>&2
    fi
done
