#include <stdio.h>

#include "printerqueues.h"

int main(int argc,char **argv)
{
	struct pqinfo *pq;

	if((pq=pqinfo_create()))
	{
		char *message="This is a quick test of printing...\n";
		int pcount=pq->GetPrinterCount(pq);
		int i;
		printf("%d printer queues available\n",pcount);
		for(i=0;i<pcount;++i)
		{
			const char *pn=pq->GetPrinterName(pq,i);
			const char *driver;
			printf("Printer: %s\n",pn);
			pq->SetPrinterQueue(pq,pn);
			driver=pq->GetDriver(pq);
			if(driver)
				printf("(using driver: %s)\n",driver);
			else
				printf("(driver unknown)\n");
		}

/*
		pq->SetPrinterQueue(pq,"Epson Stylus Photo R300");
		pq->InitialiseJob(pq);
		pq->InitialisePage(pq);
		pq->WriteData(pq,message,strlen(message));
		pq->EndPage(pq);
		pq->EndJob(pq);
*/

		pq->Dispose(pq);
	}

	return(0);
}
